/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.service.base.TicketLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class TicketLocalServiceImpl
extends TicketLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;

    public Ticket addDistinctTicket(long companyId, String className, long classPK, int type, String extraInfo, Date expirationDate, ServiceContext serviceContext) {
        this.ticketPersistence.removeByC_C_C_T(companyId, this._classNameLocalService.getClassNameId(className), classPK, type);
        return this.addTicket(companyId, className, classPK, type, extraInfo, expirationDate, serviceContext);
    }

    public Ticket addTicket(long companyId, String className, long classPK, int type, String extraInfo, Date expirationDate, ServiceContext serviceContext) {
        long ticketId = this.counterLocalService.increment();
        Ticket ticket = this.ticketPersistence.create(ticketId);
        ticket.setCompanyId(companyId);
        ticket.setCreateDate(new Date());
        ticket.setClassNameId(this._classNameLocalService.getClassNameId(className));
        ticket.setClassPK(classPK);
        ticket.setKey(PortalUUIDUtil.generate());
        ticket.setType(type);
        ticket.setExtraInfo(extraInfo);
        ticket.setExpirationDate(expirationDate);
        return (Ticket)this.ticketPersistence.update((BaseModel)ticket);
    }

    public void deleteTickets(long companyId, String className, long classPK) {
        this.ticketPersistence.removeByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public Ticket fetchTicket(String key) {
        return this.ticketPersistence.fetchByKey(key);
    }

    public Ticket getTicket(String key) throws PortalException {
        return this.ticketPersistence.findByKey(key);
    }

    public List<Ticket> getTickets(long companyId, String className, long classPK) {
        return this.ticketPersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<Ticket> getTickets(long companyId, String className, long classPK, int type) {
        return this.ticketPersistence.findByC_C_C_T(companyId, this._classNameLocalService.getClassNameId(className), classPK, type);
    }

    public List<Ticket> getTickets(String className, long classPK, int type) {
        return this.ticketPersistence.findByC_C_T(this._classNameLocalService.getClassNameId(className), classPK, type);
    }

    public Ticket updateTicket(long ticketId, String className, long classPK, int type, String extraInfo, Date expirationDate) throws PortalException {
        Ticket ticket = this.ticketPersistence.findByPrimaryKey(ticketId);
        ticket.setClassNameId(this._classNameLocalService.getClassNameId(className));
        ticket.setClassPK(classPK);
        ticket.setType(type);
        ticket.setExtraInfo(extraInfo);
        ticket.setExpirationDate(expirationDate);
        return (Ticket)this.ticketPersistence.update((BaseModel)ticket);
    }
}

