/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.exception.AvailableLocaleException;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.persistence.CompanyPersistence;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetPersistence;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.TreeMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutSetImpl;
import com.liferay.portal.service.base.VirtualHostLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.net.IDN;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;

public class VirtualHostLocalServiceImpl
extends VirtualHostLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(VirtualHostLocalServiceImpl.class);
    @BeanReference(type=CompanyPersistence.class)
    private CompanyPersistence _companyPersistence;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=LayoutSetPersistence.class)
    private LayoutSetPersistence _layoutSetPersistence;

    @Deprecated
    public VirtualHost fetchVirtualHost(long companyId, long layoutSetId) {
        return this.virtualHostPersistence.fetchByC_L_D(companyId, layoutSetId, true);
    }

    public VirtualHost fetchVirtualHost(String hostname) {
        VirtualHost virtualHost;
        block4: {
            if (Validator.isIPv6Address((String)hostname)) {
                try {
                    Inet6Address inet6Address = (Inet6Address)InetAddress.getByName(hostname);
                    hostname = inet6Address.getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)unknownHostException, (Throwable)unknownHostException);
                }
            }
        }
        if ((virtualHost = this.virtualHostPersistence.fetchByHostname(hostname)) == null && hostname.contains("xn--")) {
            virtualHost = this.virtualHostPersistence.fetchByHostname(IDN.toUnicode(hostname));
        }
        return virtualHost;
    }

    @Deprecated
    public VirtualHost getVirtualHost(long companyId, long layoutSetId) throws PortalException {
        return this.virtualHostPersistence.findByC_L_D(companyId, layoutSetId, true);
    }

    public VirtualHost getVirtualHost(String hostname) throws PortalException {
        try {
            return this.virtualHostPersistence.findByHostname(hostname);
        }
        catch (NoSuchVirtualHostException noSuchVirtualHostException) {
            if (hostname.contains("xn--")) {
                return this.virtualHostPersistence.findByHostname(IDN.toUnicode(hostname));
            }
            throw noSuchVirtualHostException;
        }
    }

    public List<VirtualHost> getVirtualHosts(long companyId, long layoutSetId) throws PortalException {
        return this.virtualHostPersistence.findByC_L(companyId, layoutSetId);
    }

    @Deprecated
    public VirtualHost updateVirtualHost(long companyId, long layoutSetId, String hostname) {
        List<VirtualHost> virtualHosts = this.updateVirtualHosts(companyId, layoutSetId, TreeMapBuilder.put((Object)hostname, (Object)"").build());
        if (virtualHosts.isEmpty()) {
            return null;
        }
        return virtualHosts.get(0);
    }

    public List<VirtualHost> updateVirtualHosts(long companyId, long layoutSetId, TreeMap<String, String> hostnames) {
        Group group;
        LayoutSet layoutSet = this._layoutSetPersistence.fetchByPrimaryKey(layoutSetId);
        Set availableLocales = LanguageUtil.getAvailableLocales();
        if (layoutSet != null) {
            availableLocales = LanguageUtil.getAvailableLocales((long)layoutSet.getGroupId());
        }
        ArrayList<VirtualHost> virtualHosts = new ArrayList<VirtualHost>(this.virtualHostPersistence.findByC_L(companyId, layoutSetId));
        boolean first = true;
        for (String curHostname : hostnames.navigableKeySet()) {
            String languageId;
            Locale locale;
            VirtualHost virtualHost = null;
            for (VirtualHost curVirtualHost : virtualHosts) {
                if (!curHostname.equals(curVirtualHost.getHostname())) continue;
                virtualHost = curVirtualHost;
                break;
            }
            if (virtualHost == null) {
                long virtualHostId = this.counterLocalService.increment();
                virtualHost = this.virtualHostPersistence.create(virtualHostId);
                virtualHost.setCompanyId(companyId);
                virtualHost.setLayoutSetId(layoutSetId);
                virtualHost.setHostname(curHostname);
                virtualHosts.add(virtualHost);
            }
            if ((locale = LocaleUtil.fromLanguageId((String)(languageId = hostnames.get(curHostname)), (boolean)true, (boolean)false)) == null) {
                locale = LocaleUtil.getSiteDefault();
            }
            if (!availableLocales.contains(locale)) {
                ReflectionUtil.throwException((Throwable)new AvailableLocaleException(languageId));
            }
            virtualHost.setDefaultVirtualHost(first);
            virtualHost.setLanguageId(languageId);
            first = false;
            this.virtualHostPersistence.update((BaseModel)virtualHost);
        }
        Iterator iterator = virtualHosts.iterator();
        while (iterator.hasNext()) {
            VirtualHost virtualHost = (VirtualHost)iterator.next();
            if (hostnames.containsKey(virtualHost.getHostname())) continue;
            iterator.remove();
            this.virtualHostPersistence.remove((BaseModel)virtualHost);
        }
        this.virtualHostPersistence.cacheResult(virtualHosts);
        Company company = this._companyPersistence.fetchByPrimaryKey(companyId);
        if (company != null) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                EntityCacheUtil.removeResult(company.getClass(), (Serializable)company.getPrimaryKeyObj());
                return null;
            });
            this._companyPersistence.clearCache((BaseModel)company);
        }
        if (layoutSet == null && Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && (group = this._groupPersistence.fetchByC_GK(companyId, PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME)) != null) {
            layoutSet = this._layoutSetPersistence.fetchByG_P(group.getGroupId(), false);
        }
        if (layoutSet != null) {
            this._layoutSetPersistence.clearCache((BaseModel)layoutSet);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                EntityCacheUtil.removeResult(LayoutSetImpl.class, (Serializable)Long.valueOf(layoutSetId));
                return null;
            });
        }
        return virtualHosts;
    }
}

