/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.templateparser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Transformer {
    private final Map<String, TemplateResource> _errorTemplateResources = new HashMap<String, TemplateResource>();
    private final boolean _restricted;

    public Transformer(String errorTemplatePropertyKey, boolean restricted) {
        this._restricted = restricted;
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        for (String langType : TemplateManagerUtil.getTemplateManagerNames()) {
            URL url;
            String errorTemplateId = this.getErrorTemplateId(errorTemplatePropertyKey, langType);
            if (!Validator.isNotNull((String)errorTemplateId) || (url = classLoader.getResource(errorTemplateId)) == null) continue;
            this._errorTemplateResources.put(langType, (TemplateResource)new URLTemplateResource(errorTemplateId, url));
        }
    }

    public Transformer(String transformerListenerPropertyKey, String errorTemplatePropertyKey, boolean restricted) {
        this(errorTemplatePropertyKey, restricted);
    }

    public String transform(ThemeDisplay themeDisplay, Map<String, Object> contextObjects, String script, String langType, UnsyncStringWriter unsyncStringWriter, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (Validator.isNull((String)langType)) {
            return null;
        }
        long companyId = 0L;
        long companyGroupId = 0L;
        long scopeGroupId = 0L;
        long siteGroupId = 0L;
        if (themeDisplay != null) {
            companyId = themeDisplay.getCompanyId();
            companyGroupId = themeDisplay.getCompanyGroupId();
            scopeGroupId = themeDisplay.getScopeGroupId();
            siteGroupId = themeDisplay.getSiteGroupId();
        }
        String templateId = String.valueOf(contextObjects.get("template_id"));
        templateId = this.getTemplateId(templateId, companyId, companyGroupId, scopeGroupId);
        Template template = this.getTemplate(templateId, script, langType);
        try {
            this.prepareTemplate(themeDisplay, template);
            template.putAll(contextObjects);
            long classNameId = GetterUtil.getLong((Object)contextObjects.get("class_name_id"));
            template.put((Object)"company", (Object)this.getCompany(themeDisplay, companyId));
            template.put((Object)"companyId", (Object)companyId);
            template.put((Object)"device", (Object)this.getDevice(themeDisplay));
            String templatesPath = this.getTemplatesPath(companyId, scopeGroupId, classNameId);
            template.put((Object)"permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
            template.put((Object)"randomNamespace", (Object)(StringUtil.randomId() + "_"));
            template.put((Object)"scopeGroupId", (Object)scopeGroupId);
            template.put((Object)"siteGroupId", (Object)siteGroupId);
            template.put((Object)"templatesPath", (Object)templatesPath);
            template.prepareTaglib(httpServletRequest, httpServletResponse);
            template.put((Object)"groupId", (Object)scopeGroupId);
            template.put((Object)"journalTemplatesPath", (Object)templatesPath);
            template.processTemplate((Writer)unsyncStringWriter, () -> this.getErrorTemplateResource(langType));
        }
        catch (Exception exception) {
            throw new TransformException("Unhandled exception", (Throwable)exception);
        }
        return unsyncStringWriter.toString();
    }

    protected Company getCompany(ThemeDisplay themeDisplay, long companyId) throws Exception {
        if (themeDisplay != null) {
            return themeDisplay.getCompany();
        }
        return CompanyLocalServiceUtil.getCompany((long)companyId);
    }

    protected Device getDevice(ThemeDisplay themeDisplay) {
        if (themeDisplay != null) {
            return themeDisplay.getDevice();
        }
        return UnknownDevice.getInstance();
    }

    protected String getErrorTemplateId(String errorTemplatePropertyKey, String langType) {
        return PropsUtil.get(errorTemplatePropertyKey, new Filter(langType));
    }

    protected TemplateResource getErrorTemplateResource(String langType) {
        return this._errorTemplateResources.get(langType);
    }

    protected Template getTemplate(String templateId, String script, String langType) throws Exception {
        StringTemplateResource templateResource = new StringTemplateResource(templateId, script);
        return TemplateManagerUtil.getTemplate((String)langType, (TemplateResource)templateResource, (boolean)this._restricted);
    }

    protected String getTemplateId(String templateId, long companyId, long companyGroupId, long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("#");
        if (companyGroupId > 0L) {
            sb.append(companyGroupId);
        } else {
            sb.append(groupId);
        }
        sb.append("#");
        sb.append(templateId);
        return sb.toString();
    }

    protected String getTemplatesPath(long companyId, long groupId, long classNameId) {
        return StringBundler.concat((Object[])new Object[]{"_TEMPLATE_CONTEXT_", "/", companyId, "/", groupId, "/", classNameId});
    }

    protected void prepareTemplate(ThemeDisplay themeDisplay, Template template) throws Exception {
        if (themeDisplay == null) {
            return;
        }
        template.prepare(themeDisplay.getRequest());
    }
}

