/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.upgrade.v7_0_0.util.GroupTable;
import com.liferay.portal.util.PropsValues;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;

public class UpgradeGroup
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.alter(GroupTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "name", "STRING null")});
        this.updateIndexes(GroupTable.class);
        this.updateGlobalGroupName();
    }

    protected void updateGlobalGroupName() throws Exception {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId from Company");){
            String[] stringArray = null;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong("companyId");
                    companyIds.add(companyId);
                }
            }
            catch (Throwable companyId) {
                stringArray = companyId;
                throw companyId;
            }
        }
        for (Long companyId : companyIds) {
            LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap();
            for (String languageId : PropsValues.LOCALES_ENABLED) {
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                localizedValuesMap.put(locale, LanguageUtil.get((ResourceBundle)LanguageResources.getResourceBundle(locale), (String)"global"));
            }
            String nameXML = LocalizationUtil.getXml((LocalizedValuesMap)localizedValuesMap, (String)"global");
            PreparedStatement preparedStatement = this.connection.prepareStatement("update Group_ set name = ? where companyId = ? and friendlyURL = '/global'");
            Throwable throwable = null;
            try {
                preparedStatement.setString(1, nameXML);
                preparedStatement.setLong(2, companyId);
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (preparedStatement == null) continue;
                if (throwable != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                preparedStatement.close();
            }
        }
    }
}

