/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.txt.UniversalEncodingDetector;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FileImpl
implements File {
    private static final String[] _SAFE_FILE_NAME_1 = new String[]{"&", ")", "(", ";"};
    private static final String[] _SAFE_FILE_NAME_2 = new String[]{PropsUtil.get("dl.store.file.impl.safe.file.name.2.ampersand"), PropsUtil.get("dl.store.file.impl.safe.file.name.2.close.parenthesis"), PropsUtil.get("dl.store.file.impl.safe.file.name.2.open.parenthesis"), PropsUtil.get("dl.store.file.impl.safe.file.name.2.semicolon")};
    private static final Log _log = LogFactoryUtil.getLog(FileImpl.class);
    private static final FileImpl _fileImpl = new FileImpl();

    public static FileImpl getInstance() {
        return _fileImpl;
    }

    public String appendParentheticalSuffix(String fileName, String suffix) {
        String fileNameWithoutExtension = this.stripExtension(fileName);
        String fileNameWithParentheticalSuffix = StringUtil.appendParentheticalSuffix((String)fileNameWithoutExtension, (String)suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNull((String)extension)) {
            return fileNameWithParentheticalSuffix;
        }
        return StringBundler.concat((String[])new String[]{fileNameWithParentheticalSuffix, ".", extension});
    }

    public String appendSuffix(String fileName, String suffix) {
        StringBundler sb = new StringBundler(4);
        String fileNameWithoutExtension = this.stripExtension(fileName);
        sb.append(fileNameWithoutExtension);
        sb.append(suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public void copyDirectory(java.io.File source, java.io.File destination) throws IOException {
        if (!source.exists() || !source.isDirectory()) {
            return;
        }
        this.mkdirs(destination);
        java.io.File[] fileArray = source.listFiles();
        if (fileArray == null) {
            return;
        }
        for (java.io.File file : fileArray) {
            if (file.isDirectory()) {
                this.copyDirectory(file, new java.io.File(destination.getPath() + java.io.File.separator + file.getName()));
                continue;
            }
            this.copyFile(file, new java.io.File(destination.getPath() + java.io.File.separator + file.getName()));
        }
    }

    public void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        this.copyDirectory(new java.io.File(sourceDirName), new java.io.File(destinationDirName));
    }

    public void copyFile(java.io.File source, java.io.File destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    public void copyFile(java.io.File source, java.io.File destination, boolean lazy) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (lazy) {
            String newContent;
            String oldContent;
            block9: {
                oldContent = null;
                try {
                    oldContent = this.read(source);
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)exception, (Throwable)exception);
                    }
                    return;
                }
                newContent = null;
                try {
                    newContent = this.read(destination);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug((Object)exception, (Throwable)exception);
                }
            }
            if (oldContent == null || !oldContent.equals(newContent)) {
                this.copyFile(source, destination, false);
            }
        } else {
            this.mkdirsParentFile(destination);
            StreamUtil.transfer((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(destination));
        }
    }

    public void copyFile(String source, String destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    public void copyFile(String source, String destination, boolean lazy) throws IOException {
        this.copyFile(new java.io.File(source), new java.io.File(destination), lazy);
    }

    public java.io.File createTempFile() {
        return this.createTempFile("");
    }

    public java.io.File createTempFile(byte[] bytes) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, bytes, false);
        return file;
    }

    public java.io.File createTempFile(InputStream inputStream) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, inputStream);
        return file;
    }

    public java.io.File createTempFile(String extension) {
        return new java.io.File(this.createTempFileName(extension));
    }

    public java.io.File createTempFile(String prefix, String extension) {
        return new java.io.File(this.createTempFileName(prefix, extension));
    }

    public String createTempFileName() {
        return this.createTempFileName(null, null);
    }

    public String createTempFileName(String extension) {
        return this.createTempFileName(null, extension);
    }

    public String createTempFileName(String prefix, String extension) {
        StringBundler sb = new StringBundler(7);
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/");
        if (Validator.isNotNull((String)prefix)) {
            sb.append(prefix);
        }
        sb.append(Time.getTimestamp());
        sb.append(PwdGenerator.getPassword((int)8, (String[])new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ"}));
        if (Validator.isFileExtension((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public java.io.File createTempFolder() throws IOException {
        java.io.File file = new java.io.File(this.createTempFileName());
        this.mkdirs(file);
        return file;
    }

    public String decodeSafeFileName(String fileName) {
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_2, (String[])_SAFE_FILE_NAME_1);
    }

    public boolean delete(java.io.File file) {
        if (file != null) {
            boolean exists;
            block4: {
                exists = true;
                try {
                    exists = file.exists();
                }
                catch (SecurityException securityException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)securityException, (Throwable)securityException);
                }
            }
            if (exists) {
                return file.delete();
            }
        }
        return false;
    }

    public boolean delete(String file) {
        return this.delete(new java.io.File(file));
    }

    public void deltree(java.io.File directory) {
        if (directory.exists() && directory.isDirectory()) {
            java.io.File[] fileArray = directory.listFiles();
            if (fileArray == null) {
                return;
            }
            for (java.io.File file : fileArray) {
                if (file.isDirectory()) {
                    this.deltree(file);
                    continue;
                }
                file.delete();
            }
            directory.delete();
        }
    }

    public void deltree(String directory) {
        this.deltree(new java.io.File(directory));
    }

    public String encodeSafeFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_1, (String[])_SAFE_FILE_NAME_2);
    }

    public boolean exists(java.io.File file) {
        return file.exists();
    }

    public boolean exists(String fileName) {
        return this.exists(new java.io.File(fileName));
    }

    public String extractText(InputStream inputStream, String fileName) {
        return this.extractText(inputStream, fileName, -1);
    }

    public String extractText(InputStream inputStream, String fileName, int maxStringLength) {
        if (maxStringLength == 0) {
            return "";
        }
        String text = null;
        try {
            String mimeType;
            Tika tika = new Tika(TikaConfigHolder._tikaConfig);
            tika.setMaxStringLength(maxStringLength);
            boolean forkProcess = false;
            TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)inputStream);
            if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains((Object[])PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, (Object)(mimeType = tika.detect((InputStream)tikaInputStream)))) {
                forkProcess = true;
            }
            if (forkProcess) {
                ProcessChannel processChannel = (ProcessChannel)SystemBundleUtil.callService(ProcessExecutor.class, processExecutor -> {
                    try {
                        return processExecutor.execute(PortalClassPathUtil.getPortalProcessConfig(), (ProcessCallable)new ExtractTextProcessCallable(this.getBytes((InputStream)tikaInputStream)));
                    }
                    catch (Exception exception) {
                        return (ProcessChannel)ReflectionUtil.throwException((Throwable)exception);
                    }
                });
                NoticeableFuture future = processChannel.getProcessNoticeableFuture();
                text = (String)future.get();
            } else if (!this._isEmptyTikaInputStream(tikaInputStream)) {
                text = FileImpl._parseToString(tika, tikaInputStream);
            }
        }
        catch (Throwable throwable) {
            Throwable rootCauseThrowable = ExceptionUtils.getRootCause((Throwable)throwable);
            if (rootCauseThrowable instanceof EncryptedDocumentException || rootCauseThrowable instanceof UnsupportedZipFeatureException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to extract text from an encrypted file " + fileName), throwable);
                }
            }
            if (throwable instanceof TikaException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to extract text from " + fileName), throwable);
                }
            }
            _log.error((Object)throwable, throwable);
        }
        if (_log.isInfoEnabled()) {
            if (text == null) {
                _log.info((Object)("Text extraction failed for " + fileName));
            } else {
                _log.info((Object)("Text was extracted for " + fileName));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Extractor returned text:\n\n" + text));
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String getAbsolutePath(java.io.File file) {
        return StringUtil.replace((String)file.getAbsolutePath(), (char)'\\', (char)'/');
    }

    public byte[] getBytes(Class<?> clazz, String fileName) throws IOException {
        return this.getBytes(clazz.getResourceAsStream(fileName));
    }

    public byte[] getBytes(java.io.File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public byte[] getBytes(InputStream inputStream) throws IOException {
        return this.getBytes(inputStream, -1);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize) throws IOException {
        return this.getBytes(inputStream, bufferSize, true);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize, boolean cleanUpStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)bufferSize, (boolean)cleanUpStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return StringUtil.toLowerCase((String)fileName.substring(pos + 1));
        }
        return "";
    }

    public String getMD5Checksum(java.io.File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = DigesterUtil.digestHex((String)"MD5", (InputStream)fileInputStream);
            return string;
        }
    }

    public String getPath(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        if (x == -1 && y == -1) {
            return "/";
        }
        return fullFileName.substring(0, Math.max(x, y));
    }

    public String getShortFileName(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        return fullFileName.substring(Math.max(x, y) + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameContent(java.io.File file, byte[] bytes, int length) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileChannel fileChannel = fileInputStream.getChannel();
            if (fileChannel.size() != (long)length) {
                boolean bl = false;
                return bl;
            }
            byte[] buffer = new byte[1024];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            int bufferIndex = 0;
            int bufferLength = -1;
            while (true) {
                if ((bufferLength = fileChannel.read(byteBuffer)) > 0 && bufferIndex < length) {
                } else {
                    boolean bl;
                    if (bufferIndex != length || bufferLength != -1) {
                        bl = false;
                        return bl;
                    }
                    bl = true;
                    return bl;
                }
                for (int i = 0; i < bufferLength; ++i) {
                    if (buffer[i] == bytes[bufferIndex++]) continue;
                    boolean bl = false;
                    return bl;
                }
                byteBuffer.clear();
            }
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Object)exception, (Throwable)exception);
            return false;
        }
    }

    public boolean isSameContent(java.io.File file, String s) {
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (CharBuffer)CharBuffer.wrap(s));
        return this.isSameContent(file, byteBuffer.array(), byteBuffer.limit());
    }

    public String[] listDirs(java.io.File file) {
        ArrayList<String> dirs = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            dirs.add(fileArray[i].getName());
        }
        return dirs.toArray(new String[0]);
    }

    public String[] listDirs(String fileName) {
        return this.listDirs(new java.io.File(fileName));
    }

    public String[] listFiles(java.io.File file) {
        ArrayList<String> files = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            files.add(fileArray[i].getName());
        }
        return files.toArray(new String[0]);
    }

    public String[] listFiles(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return new String[0];
        }
        return this.listFiles(new java.io.File(fileName));
    }

    public void mkdirs(java.io.File file) throws IOException {
        FileUtils.forceMkdir((java.io.File)file);
    }

    public void mkdirs(String pathName) {
        java.io.File file = new java.io.File(pathName);
        if (file.exists() && file.isDirectory()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Directory " + pathName + " already exists"));
            }
            return;
        }
        try {
            this.mkdirs(file);
        }
        catch (IOException ioException) {
            ReflectionUtil.throwException((Throwable)ioException);
        }
    }

    public boolean move(java.io.File source, java.io.File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        try {
            if (source.isDirectory()) {
                FileUtils.moveDirectory((java.io.File)source, (java.io.File)destination);
            } else {
                FileUtils.moveFile((java.io.File)source, (java.io.File)destination);
            }
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ioException, (Throwable)ioException);
            }
            return false;
        }
        return true;
    }

    public boolean move(String sourceFileName, String destinationFileName) {
        return this.move(new java.io.File(sourceFileName), new java.io.File(destinationFileName));
    }

    public String read(java.io.File file) throws IOException {
        return this.read(file, false);
    }

    public String read(java.io.File file, boolean raw) throws IOException {
        byte[] bytes = this.getBytes(file);
        if (bytes == null) {
            return null;
        }
        String s = new String(bytes, "UTF-8");
        if (raw) {
            return s;
        }
        return StringUtil.replace((String)s, (String)"\r\n", (String)"\n");
    }

    public String read(String fileName) throws IOException {
        return this.read(new java.io.File(fileName));
    }

    public String replaceSeparator(String fileName) {
        return StringUtil.replace((String)fileName, (char)'\\', (char)'/');
    }

    public java.io.File[] sortFiles(java.io.File[] files) {
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        ArrayList<java.io.File> directoryList = new ArrayList<java.io.File>();
        ArrayList<java.io.File> fileList = new ArrayList<java.io.File>();
        for (java.io.File file : files) {
            if (file.isDirectory()) {
                directoryList.add(file);
                continue;
            }
            fileList.add(file);
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new java.io.File[0]);
    }

    public String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = this.getExtension(fileName);
        if (ext.length() > 0) {
            return fileName.substring(0, fileName.length() - ext.length() - 1);
        }
        return fileName;
    }

    public String stripParentheticalSuffix(String fileName) {
        StringBundler sb = new StringBundler(3);
        String fileNameWithoutExtension = this.stripExtension(fileName);
        sb.append(StringUtil.stripParentheticalSuffix((String)fileNameWithoutExtension));
        String extension = this.getExtension(fileName);
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public List<String> toList(Reader reader) {
        ArrayList<String> list;
        block15: {
            list = new ArrayList<String>();
            try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
                String line = null;
                while ((line = unsyncBufferedReader.readLine()) != null) {
                    list.add(line);
                }
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block15;
                _log.debug((Object)ioException, (Throwable)ioException);
            }
        }
        return list;
    }

    public List<String> toList(String fileName) {
        try {
            return this.toList(new FileReader(fileName));
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ioException, (Throwable)ioException);
            }
            return new ArrayList<String>();
        }
    }

    public Properties toProperties(FileInputStream fileInputStream) {
        Properties properties;
        block2: {
            properties = new Properties();
            try {
                properties.load(fileInputStream);
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)ioException, (Throwable)ioException);
            }
        }
        return properties;
    }

    public Properties toProperties(String fileName) {
        try {
            return this.toProperties(new FileInputStream(fileName));
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ioException, (Throwable)ioException);
            }
            return new Properties();
        }
    }

    public void touch(java.io.File file) throws IOException {
        FileUtils.touch((java.io.File)file);
    }

    public void touch(String fileName) throws IOException {
        this.touch(new java.io.File(fileName));
    }

    public void unzip(java.io.File source, java.io.File destination) {
        Path destinationPath = destination.toPath();
        try (FileInputStream inputStream = new FileInputStream(source);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                Path path = destinationPath.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(zipInputStream, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ioException) {
            ReflectionUtil.throwException((Throwable)ioException);
        }
    }

    public void write(java.io.File file, byte[] bytes) throws IOException {
        this.write(file, bytes, 0, bytes.length, false);
    }

    public void write(java.io.File file, byte[] bytes, boolean append) throws IOException {
        this.write(file, bytes, 0, bytes.length, append);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length) throws IOException {
        this.write(file, bytes, offset, bytes.length, false);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length, boolean append) throws IOException {
        this.mkdirsParentFile(file);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, append);){
            fileOutputStream.write(bytes, offset, length);
        }
    }

    public void write(java.io.File file, InputStream inputStream) throws IOException {
        this.mkdirsParentFile(file);
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
    }

    public void write(java.io.File file, String s) throws IOException {
        this.write(file, s, false);
    }

    public void write(java.io.File file, String s, boolean lazy) throws IOException {
        this.write(file, s, lazy, false);
    }

    public void write(java.io.File file, String s, boolean lazy, boolean append) throws IOException {
        String content;
        if (s == null) {
            return;
        }
        this.mkdirsParentFile(file);
        if (lazy && file.exists() && (content = this.read(file)).equals(s)) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");){
            writer.write(s);
        }
    }

    public void write(String fileName, byte[] bytes) throws IOException {
        this.write(new java.io.File(fileName), bytes);
    }

    public void write(String fileName, InputStream inputStream) throws IOException {
        this.write(new java.io.File(fileName), inputStream);
    }

    public void write(String fileName, String s) throws IOException {
        this.write(new java.io.File(fileName), s);
    }

    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(fileName), s, lazy);
    }

    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(fileName), s, lazy, append);
    }

    public void write(String pathName, String fileName, String s) throws IOException {
        this.write(new java.io.File(pathName, fileName), s);
    }

    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy);
    }

    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy, append);
    }

    protected void mkdirsParentFile(java.io.File file) throws IOException {
        block3: {
            java.io.File parentFile = file.getParentFile();
            if (parentFile == null) {
                return;
            }
            try {
                this.mkdirs(parentFile);
            }
            catch (SecurityException securityException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)securityException, (Throwable)securityException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _parseToString(final Tika tika, TikaInputStream tikaInputStream) throws IOException, TikaException {
        UniversalEncodingDetector universalEncodingDetector = new UniversalEncodingDetector();
        Metadata metadata = new Metadata();
        Charset charset = universalEncodingDetector.detect((InputStream)tikaInputStream, metadata);
        String contentEncoding = "";
        if (charset != null) {
            contentEncoding = charset.name();
        }
        if (!contentEncoding.equals("")) {
            metadata.set("Content-Encoding", contentEncoding);
            metadata.set("Content-Type", "text/plain; charset=" + contentEncoding);
        }
        WriteOutContentHandler writeOutContentHandler = new WriteOutContentHandler(tika.getMaxStringLength());
        try {
            Parser parser = tika.getParser();
            ParseContext parseContext = new ParseContext();
            parseContext.set(EmbeddedDocumentExtractor.class, (Object)new ParsingEmbeddedDocumentExtractor(parseContext){

                public void parseEmbedded(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, boolean outputHtml) throws IOException, SAXException {
                    String mimeType = tika.detect(inputStream);
                    if (mimeType.equals("image/png")) {
                        return;
                    }
                    super.parseEmbedded(inputStream, contentHandler, metadata, outputHtml);
                }
            });
            parseContext.set(Parser.class, (Object)parser);
            parser.parse((InputStream)tikaInputStream, (ContentHandler)new BodyContentHandler((ContentHandler)writeOutContentHandler), metadata, parseContext);
        }
        catch (SAXException saxException) {
            if (!writeOutContentHandler.isWriteLimitReached((Throwable)saxException)) {
                throw new TikaException(saxException.getMessage(), (Throwable)saxException);
            }
        }
        finally {
            tikaInputStream.close();
        }
        return writeOutContentHandler.toString();
    }

    private boolean _isEmptyTikaInputStream(TikaInputStream tikaInputStream) throws IOException {
        if (tikaInputStream.hasLength() && tikaInputStream.getLength() > 0L) {
            return false;
        }
        byte[] bytes = new byte[1];
        int count = tikaInputStream.peek(bytes);
        return count <= 0;
    }

    private static class TikaConfigHolder {
        private static final TikaConfig _tikaConfig;

        private TikaConfigHolder() {
        }

        static {
            try {
                _tikaConfig = new TikaConfig();
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }

    private static class ExtractTextProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final byte[] _data;

        public ExtractTextProcessCallable(byte[] data) {
            this._data = data;
        }

        public String call() throws ProcessException {
            if (ArrayUtil.isEmpty((byte[])this._data)) {
                return "";
            }
            Logger logger = Logger.getLogger("org.apache.tika.parser.SQLite3Parser");
            logger.setLevel(Level.SEVERE);
            logger = Logger.getLogger("org.apache.tika.parsers.PDFParser");
            logger.setLevel(Level.SEVERE);
            Tika tika = new Tika(TikaConfigHolder._tikaConfig);
            try {
                UnsyncByteArrayInputStream inputStream = new UnsyncByteArrayInputStream(this._data);
                return FileImpl._parseToString(tika, TikaInputStream.get((InputStream)inputStream));
            }
            catch (Exception exception) {
                throw new ProcessException((Throwable)exception);
            }
        }
    }
}

