/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessLog;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class PortalClassPathUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortalClassPathUtil.class);
    private static ProcessConfig _portalProcessConfig;
    private static final List<String> _processArgs;

    public static ProcessConfig createProcessConfig(Class<?> ... classes) {
        ProcessConfig.Builder builder = new ProcessConfig.Builder();
        builder.setArguments(_processArgs);
        File[] files = PortalClassPathUtil._listClassPathFiles(classes);
        if (files.length == 0) {
            throw new IllegalStateException("Class path files could not be loaded");
        }
        StringBundler sb = new StringBundler(files.length * 2 + 1);
        for (File file : files) {
            sb.append(file.getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        sb.append(_portalProcessConfig.getBootstrapClassPath());
        String classpath = sb.toString();
        builder.setBootstrapClassPath(classpath);
        builder.setProcessLogConsumer(processLog -> {
            if (ProcessLog.Level.DEBUG == processLog.getLevel()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)processLog.getMessage(), processLog.getThrowable());
                }
            } else if (ProcessLog.Level.INFO == processLog.getLevel()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)processLog.getMessage(), processLog.getThrowable());
                }
            } else if (ProcessLog.Level.WARN == processLog.getLevel()) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)processLog.getMessage(), processLog.getThrowable());
                }
            } else {
                _log.error((Object)processLog.getMessage(), processLog.getThrowable());
            }
        });
        builder.setReactClassLoader(PortalClassLoaderUtil.getClassLoader());
        builder.setRuntimeClassPath(classpath);
        return builder.build();
    }

    public static ProcessConfig getPortalProcessConfig() {
        return _portalProcessConfig;
    }

    public static void initializeClassPaths(ServletContext servletContext) {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        if (classLoader == null) {
            Thread currentThread = Thread.currentThread();
            classLoader = currentThread.getContextClassLoader();
        }
        Class<?> shieldedContainerInitializerClass = null;
        try {
            shieldedContainerInitializerClass = classLoader.loadClass("com.liferay.shielded.container.ShieldedContainerInitializer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            _log.error((Object)"Unable to load ShieldedContainerInitializer class", (Throwable)classNotFoundException);
        }
        File[] files = PortalClassPathUtil._listClassPathFiles(ServletException.class, CentralizedThreadLocal.class, shieldedContainerInitializerClass);
        if (files.length == 0) {
            throw new IllegalStateException("Class path files could not be loaded");
        }
        StringBundler runtimeClassPathSB = new StringBundler(files.length * 2 + 3);
        StringBundler bootstrapClassPathSB = new StringBundler(files.length * 2);
        for (File file : files) {
            if (PortalClassPathUtil._isPetraJar(file)) {
                bootstrapClassPathSB.append(file.getAbsolutePath());
                bootstrapClassPathSB.append(File.pathSeparator);
            }
            runtimeClassPathSB.append(file.getAbsolutePath());
            runtimeClassPathSB.append(File.pathSeparator);
        }
        runtimeClassPathSB.setIndex(runtimeClassPathSB.index() - 1);
        if (bootstrapClassPathSB.index() > 0) {
            bootstrapClassPathSB.setIndex(bootstrapClassPathSB.index() - 1);
        }
        if (servletContext != null) {
            runtimeClassPathSB.append(File.pathSeparator);
            runtimeClassPathSB.append(servletContext.getRealPath(""));
            runtimeClassPathSB.append("/WEB-INF/classes");
        }
        ProcessConfig.Builder builder = new ProcessConfig.Builder();
        builder.setArguments(_processArgs);
        builder.setBootstrapClassPath(bootstrapClassPathSB.toString());
        builder.setReactClassLoader(classLoader);
        builder.setRuntimeClassPath(runtimeClassPathSB.toString());
        _portalProcessConfig = builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean _isPetraJar(File file) {
        String filePath = file.getAbsolutePath();
        if (!filePath.contains("petra")) return false;
        try (JarFile jarFile = new JarFile(new File(filePath));){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes.containsKey(new Attributes.Name("Liferay-Releng-App-Title"))) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to resolve bootstrap entry: " + file.getName() + " from bundle"), (Throwable)ioException);
        }
        return false;
    }

    private static File[] _listClassPathFiles(Class<?> clazz) {
        String protocol;
        String className = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        String pathOfClass = StringUtil.replace((String)className, (char)'.', (char)'/');
        pathOfClass = pathOfClass.concat(".class");
        URL url = classLoader.getResource(pathOfClass);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build class path from " + url));
        }
        if ((protocol = url.getProtocol()).equals("bundle") || protocol.equals("bundleresource")) {
            try {
                URLConnection urlConnection = url.openConnection();
                Class<?> urlConnectionClass = urlConnection.getClass();
                Method getLocalURLMethod = urlConnectionClass.getDeclaredMethod("getLocalURL", new Class[0]);
                getLocalURLMethod.setAccessible(true);
                url = (URL)getLocalURLMethod.invoke((Object)urlConnection, new Object[0]);
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to resolve local URL from bundle", (Throwable)exception);
                return null;
            }
        }
        String path = URLCodec.decodeURL((String)url.getPath());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Path " + path));
        }
        path = StringUtil.replace((String)path, (char)'\\', (char)'/');
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Decoded path " + path));
        }
        if (ServerDetector.isWebLogic() && protocol.equals("zip")) {
            path = "file:".concat(path);
        }
        if ((ServerDetector.isJBoss() || ServerDetector.isWildfly()) && (protocol.equals("vfs") || protocol.equals("vfsfile") || protocol.equals("vfszip"))) {
            String jarFilePath;
            File jarFile;
            int pos = path.indexOf(".jar/");
            if (pos != -1 && (jarFile = new File(jarFilePath = path.substring(0, pos + 4))).isFile()) {
                path = jarFilePath + '!' + path.substring(pos + 4);
            }
            path = "file:".concat(path);
        }
        File dir = null;
        int pos = -1;
        if (!path.startsWith("file:") || (pos = path.indexOf(33)) == -1) {
            if (!path.endsWith(pathOfClass)) {
                _log.error((Object)("Class " + className + " is not loaded from a JAR file"));
                return null;
            }
            String classesDirName = path.substring(0, path.length() - pathOfClass.length());
            if (!classesDirName.endsWith("/WEB-INF/classes/")) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Class ", className, " is not loaded from a standard ", "location (/WEB-INF/classes)"}));
                return null;
            }
            String libDirName = classesDirName.substring(0, classesDirName.length() - "classes/".length());
            libDirName = libDirName + "/lib";
            dir = new File(libDirName);
        } else {
            pos = path.lastIndexOf(47, pos);
            dir = new File(path.substring("file:".length(), pos));
        }
        if (!dir.isDirectory()) {
            _log.error((Object)(dir.toString() + " is not a directory"));
            return null;
        }
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String name = file.getName();
                return name.equals("bundleFile") || name.endsWith(".jar");
            }
        });
    }

    private static File[] _listClassPathFiles(Class<?> ... classes) {
        HashSet filesSet = new HashSet();
        for (Class<?> clazz : classes) {
            File[] files = PortalClassPathUtil._listClassPathFiles(clazz);
            if (files == null) continue;
            Collections.addAll(filesSet, files);
        }
        Object[] files = filesSet.toArray(new File[0]);
        Arrays.sort(files);
        return files;
    }

    static {
        _processArgs = Arrays.asList("-Dconfiguration.impl.quiet=true", "-Djava.awt.headless=true", "-Dserver.detector.quiet=true", "-Dsystem.properties.quiet=true");
    }
}

