/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.InvokerPortletResponse;
import com.liferay.portlet.internal.PortletSessionImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;

public class InvokerPortletUtil {
    public static void clearResponse(HttpSession httpSession, long plid, String portletId, String languageId) {
        String sesResponseId = InvokerPortletUtil.encodeResponseKey(plid, portletId, languageId);
        Map<String, InvokerPortletResponse> responses = InvokerPortletUtil.getResponses(httpSession);
        responses.remove(sesResponseId);
    }

    public static void clearResponses(PortletSession session) {
        Map<String, InvokerPortletResponse> responses = InvokerPortletUtil.getResponses(session);
        responses.clear();
    }

    public static String encodeResponseKey(long plid, String portletId, String languageId) {
        return StringBundler.concat((String[])new String[]{StringUtil.toHexString((long)plid), "_", portletId, "_", languageId});
    }

    public static Map<String, InvokerPortletResponse> getResponses(HttpSession httpSession) {
        ConcurrentHashMap responses = (ConcurrentHashMap)httpSession.getAttribute("CACHE_PORTLET_RESPONSES");
        if (responses == null) {
            responses = new ConcurrentHashMap();
            httpSession.setAttribute("CACHE_PORTLET_RESPONSES", responses);
        }
        return responses;
    }

    public static Map<String, InvokerPortletResponse> getResponses(PortletSession portletSession) {
        PortletSessionImpl portletSessionImpl = (PortletSessionImpl)portletSession;
        return InvokerPortletUtil.getResponses(portletSessionImpl.getHttpSession());
    }
}

