/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.expando.kernel.model.CustomAttributesDisplay;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationDeliveryType;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperTracker;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListener;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListenerWrapper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.security.permission.propagator.PermissionPropagator;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.notifications.UserNotificationHandlerImpl;
import com.liferay.portal.util.JavaFieldsParser;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.internal.FriendlyURLMapperTrackerImpl;
import com.liferay.portlet.internal.PortletBagImpl;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialRequestInterpreter;
import com.liferay.social.kernel.model.impl.SocialActivityInterpreterImpl;
import com.liferay.social.kernel.model.impl.SocialRequestInterpreterImpl;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.portlet.Portlet;
import javax.portlet.PreferencesValidator;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PortletBagFactory {
    private static final Log _log = LogFactoryUtil.getLog(PortletBagFactory.class);
    private ClassLoader _classLoader;
    private Configuration _configuration;
    private ServletContext _servletContext;
    private Boolean _warFile;

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        return this.create(portlet, false);
    }

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet, boolean destroyPrevious) throws Exception {
        this._validate();
        Portlet portletInstance = this._getPortletInstance(portlet);
        return this.create(portlet, portletInstance, destroyPrevious);
    }

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet, Portlet portletInstance, boolean destroyPrevious) throws Exception {
        this._validate();
        Dictionary properties = MapUtil.singletonDictionary((Object)"javax.portlet.name", (Object)portlet.getPortletName());
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        ArrayList serviceRegistrations = new ArrayList();
        this._registerConfigurationActions(bundleContext, portlet, properties, serviceRegistrations);
        this._registerIndexers(bundleContext, portlet, properties, serviceRegistrations);
        this._registerOpenSearches(bundleContext, portlet, properties, serviceRegistrations);
        this._registerSchedulerEventMessageListeners(bundleContext, portlet, properties, serviceRegistrations);
        FriendlyURLMapperTracker friendlyURLMapperTracker = this._registerFriendlyURLMappers(portlet);
        this._registerURLEncoders(bundleContext, portlet, properties, serviceRegistrations);
        this._registerPortletDataHandlers(bundleContext, portlet, properties, serviceRegistrations);
        this._registerStagedModelDataHandler(bundleContext, portlet, properties, serviceRegistrations);
        this._registerTemplateHandlers(bundleContext, portlet, properties, serviceRegistrations);
        this._registerPortletLayoutListeners(bundleContext, portlet, properties, serviceRegistrations);
        this._registerPollerProcessors(bundleContext, portlet, properties, serviceRegistrations);
        this._registerPOPMessageListeners(bundleContext, portlet, properties, serviceRegistrations);
        this._registerSocialActivityInterpreterInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerSocialRequestInterpreterInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerUserNotificationDefinitionInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerUserNotificationHandlerInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerWebDAVStorageInstances(bundleContext, portlet);
        this._registerXmlRpcMethodInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerControlPanelEntryInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerAssetRendererFactoryInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerCustomAttributesDisplayInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerPermissionPropagators(bundleContext, portlet, properties, serviceRegistrations);
        this._registerTrashHandlerInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerWorkflowHandlerInstances(bundleContext, portlet, properties, serviceRegistrations);
        this._registerPreferencesValidatorInstances(bundleContext, portlet, properties, serviceRegistrations);
        PortletBagImpl portletBag = new PortletBagImpl(portlet.getPortletName(), this._servletContext, portletInstance, portlet.getResourceBundle(), friendlyURLMapperTracker, serviceRegistrations);
        PortletBagPool.put((String)portlet.getRootPortletId(), (PortletBag)portletBag);
        try {
            PortletInstanceFactoryUtil.create((com.liferay.portal.kernel.model.Portlet)portlet, (ServletContext)this._servletContext, (boolean)destroyPrevious);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return portletBag;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }

    private String _getContent(String fileName) throws Exception {
        String queryString = HttpUtil.getQueryString((String)fileName);
        if (Validator.isNull((String)queryString)) {
            return StringUtil.read((ClassLoader)this._classLoader, (String)fileName);
        }
        int pos = fileName.indexOf("?");
        String xml = StringUtil.read((ClassLoader)this._classLoader, (String)fileName.substring(0, pos));
        Map parameterMap = HttpUtil.getParameterMap((String)queryString);
        if (parameterMap == null) {
            return xml;
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values.length == 0) continue;
            String value = values[0];
            xml = StringUtil.replace((String)xml, (String)("@" + (String)entry.getKey() + "@"), (String)value);
        }
        return xml;
    }

    private String _getPluginPropertyValue(String propertyKey) throws Exception {
        if (this._configuration == null) {
            this._configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)this._classLoader, (String)"portlet");
        }
        return this._configuration.get(propertyKey);
    }

    private Portlet _getPortletInstance(com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        Class<?> portletClass = null;
        try {
            portletClass = this._classLoader.loadClass(portlet.getPortletClass());
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
            PortletLocalServiceUtil.destroyPortlet((com.liferay.portal.kernel.model.Portlet)portlet);
            return null;
        }
        return (Portlet)portletClass.newInstance();
    }

    private <T> T _newInstance(Class<? extends T> interfaceClass, String implClassName) throws Exception {
        if (this._warFile.booleanValue()) {
            return (T)ProxyFactory.newInstance((ClassLoader)this._classLoader, (Class[])new Class[]{interfaceClass}, (String)implClassName);
        }
        Class<?> clazz = this._classLoader.loadClass(implClassName);
        return (T)clazz.newInstance();
    }

    private void _registerAssetRendererFactoryInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String assetRendererFactoryClass : portlet.getAssetRendererFactoryClasses()) {
            String assetRendererEnabledPropertyKey = "asset.renderer.enabled." + assetRendererFactoryClass;
            String assetRendererEnabledPropertyValue = null;
            assetRendererEnabledPropertyValue = this._warFile != false ? this._getPluginPropertyValue(assetRendererEnabledPropertyKey) : PropsUtil.get((String)assetRendererEnabledPropertyKey);
            boolean assetRendererEnabledValue = GetterUtil.getBoolean((String)assetRendererEnabledPropertyValue, (boolean)true);
            if (!assetRendererEnabledValue) continue;
            AssetRendererFactory assetRendererFactory = this._newInstance(AssetRendererFactory.class, assetRendererFactoryClass);
            assetRendererFactory.setClassName(assetRendererFactory.getClassName());
            assetRendererFactory.setPortletId(portlet.getPortletId());
            ServiceRegistration serviceRegistration = bundleContext.registerService(AssetRendererFactory.class, (Object)assetRendererFactory, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerConfigurationActions(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getConfigurationActionClass())) {
            ConfigurationAction configurationAction = this._newInstance(ConfigurationAction.class, portlet.getConfigurationActionClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(ConfigurationAction.class, (Object)configurationAction, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerControlPanelEntryInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getControlPanelEntryClass())) {
            ControlPanelEntry controlPanelEntryInstance = this._newInstance(ControlPanelEntry.class, portlet.getControlPanelEntryClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(ControlPanelEntry.class, (Object)controlPanelEntryInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerCustomAttributesDisplayInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String customAttributesDisplayClass : portlet.getCustomAttributesDisplayClasses()) {
            CustomAttributesDisplay customAttributesDisplayInstance = this._newInstance(CustomAttributesDisplay.class, customAttributesDisplayClass);
            customAttributesDisplayInstance.setClassNameId(PortalUtil.getClassNameId((String)customAttributesDisplayInstance.getClassName()));
            customAttributesDisplayInstance.setPortletId(portlet.getPortletId());
            ServiceRegistration serviceRegistration = bundleContext.registerService(CustomAttributesDisplay.class, (Object)customAttributesDisplayInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private FriendlyURLMapperTracker _registerFriendlyURLMappers(com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        FriendlyURLMapperTrackerImpl friendlyURLMapperTracker = new FriendlyURLMapperTrackerImpl(portlet);
        if (Validator.isNotNull((String)portlet.getFriendlyURLMapperClass())) {
            FriendlyURLMapper friendlyURLMapper = this._newInstance(FriendlyURLMapper.class, portlet.getFriendlyURLMapperClass());
            friendlyURLMapperTracker.register(friendlyURLMapper);
        }
        return friendlyURLMapperTracker;
    }

    private void _registerIndexers(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String indexerClass : portlet.getIndexerClasses()) {
            Indexer indexerInstance = this._newInstance(Indexer.class, indexerClass);
            ServiceRegistration serviceRegistration = bundleContext.registerService(Indexer.class, (Object)indexerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerOpenSearches(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getOpenSearchClass())) {
            OpenSearch openSearch = this._newInstance(OpenSearch.class, portlet.getOpenSearchClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(OpenSearch.class, (Object)openSearch, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPermissionPropagators(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPermissionPropagatorClass())) {
            PermissionPropagator permissionPropagatorInstance = this._newInstance(PermissionPropagator.class, portlet.getPermissionPropagatorClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(PermissionPropagator.class, (Object)permissionPropagatorInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPollerProcessors(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPollerProcessorClass())) {
            PollerProcessor pollerProcessorInstance = this._newInstance(PollerProcessor.class, portlet.getPollerProcessorClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(PollerProcessor.class, (Object)pollerProcessorInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPOPMessageListeners(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPopMessageListenerClass())) {
            com.liferay.portal.kernel.pop.MessageListener popMessageListenerInstance = this._newInstance(com.liferay.portal.kernel.pop.MessageListener.class, portlet.getPopMessageListenerClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(com.liferay.portal.kernel.pop.MessageListener.class, (Object)popMessageListenerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPortletDataHandlers(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPortletDataHandlerClass())) {
            PortletDataHandler portletDataHandlerInstance = this._newInstance(PortletDataHandler.class, portlet.getPortletDataHandlerClass());
            portletDataHandlerInstance.setPortletId(portlet.getPortletId());
            ServiceRegistration serviceRegistration = bundleContext.registerService(PortletDataHandler.class, (Object)portletDataHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPortletLayoutListeners(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPortletLayoutListenerClass())) {
            PortletLayoutListener portletLayoutListener = this._newInstance(PortletLayoutListener.class, portlet.getPortletLayoutListenerClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(PortletLayoutListener.class, (Object)portletLayoutListener, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPreferencesValidatorInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        PreferencesValidator preferencesValidatorInstance;
        block4: {
            if (Validator.isNull((String)portlet.getPreferencesValidator())) {
                return;
            }
            preferencesValidatorInstance = this._newInstance(PreferencesValidator.class, portlet.getPreferencesValidator());
            try {
                if (PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                    preferencesValidatorInstance.validate(PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences()));
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Portlet with the name " + portlet.getPortletId() + " does not have valid default preferences"), (Throwable)exception);
            }
        }
        ServiceRegistration serviceRegistration = bundleContext.registerService(PreferencesValidator.class, (Object)preferencesValidatorInstance, properties);
        serviceRegistrations.add(serviceRegistration);
    }

    private void _registerSchedulerEventMessageListeners(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (SchedulerEntry schedulerEntry : portlet.getSchedulerEntries()) {
            SchedulerEventMessageListenerWrapper schedulerEventMessageListenerWrapper = new SchedulerEventMessageListenerWrapper();
            MessageListener messageListener = (MessageListener)InstanceFactory.newInstance((ClassLoader)this._classLoader, (String)schedulerEntry.getEventListenerClass());
            schedulerEventMessageListenerWrapper.setMessageListener(messageListener);
            schedulerEventMessageListenerWrapper.setSchedulerEntry(schedulerEntry);
            ServiceRegistration serviceRegistration = bundleContext.registerService(SchedulerEventMessageListener.class, (Object)schedulerEventMessageListenerWrapper, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerSocialActivityInterpreterInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String socialActivityInterpreterClass : portlet.getSocialActivityInterpreterClasses()) {
            SocialActivityInterpreter socialActivityInterpreterInstance = this._newInstance(SocialActivityInterpreter.class, socialActivityInterpreterClass);
            socialActivityInterpreterInstance = new SocialActivityInterpreterImpl(portlet.getPortletId(), socialActivityInterpreterInstance);
            ServiceRegistration serviceRegistration = bundleContext.registerService(SocialActivityInterpreter.class, (Object)socialActivityInterpreterInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerSocialRequestInterpreterInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getSocialRequestInterpreterClass())) {
            SocialRequestInterpreter socialRequestInterpreterInstance = this._newInstance(SocialRequestInterpreter.class, portlet.getSocialRequestInterpreterClass());
            socialRequestInterpreterInstance = new SocialRequestInterpreterImpl(portlet.getPortletId(), socialRequestInterpreterInstance);
            ServiceRegistration serviceRegistration = bundleContext.registerService(SocialRequestInterpreter.class, (Object)socialRequestInterpreterInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerStagedModelDataHandler(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String stagedModelDataHandlerClass : portlet.getStagedModelDataHandlerClasses()) {
            StagedModelDataHandler stagedModelDataHandler = this._newInstance(StagedModelDataHandler.class, stagedModelDataHandlerClass);
            ServiceRegistration serviceRegistration = bundleContext.registerService(StagedModelDataHandler.class, (Object)stagedModelDataHandler, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerTemplateHandlers(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getTemplateHandlerClass())) {
            TemplateHandler templateHandler = this._newInstance(TemplateHandler.class, portlet.getTemplateHandlerClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(TemplateHandler.class, (Object)templateHandler, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerTrashHandlerInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String trashHandlerClass : portlet.getTrashHandlerClasses()) {
            TrashHandler trashHandlerInstance = this._newInstance(TrashHandler.class, trashHandlerClass);
            ServiceRegistration serviceRegistration = bundleContext.registerService(TrashHandler.class, (Object)trashHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerURLEncoders(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getURLEncoderClass())) {
            URLEncoder urlEncoder = this._newInstance(URLEncoder.class, portlet.getURLEncoderClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(URLEncoder.class, (Object)urlEncoder, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerUserNotificationDefinitionInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNull((String)portlet.getUserNotificationDefinitions())) {
            return;
        }
        String xml = this._getContent(portlet.getUserNotificationDefinitions());
        xml = JavaFieldsParser.parse(this._classLoader, xml);
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        for (Element definitionElement : rootElement.elements("definition")) {
            String modelName = definitionElement.elementText("model-name");
            long classNameId = 0L;
            if (Validator.isNotNull((String)modelName)) {
                classNameId = PortalUtil.getClassNameId((String)modelName);
            }
            int notificationType = GetterUtil.getInteger((String)definitionElement.elementText("notification-type"));
            String description = GetterUtil.getString((String)definitionElement.elementText("description"));
            UserNotificationDefinition userNotificationDefinition = new UserNotificationDefinition(portlet.getPortletId(), classNameId, notificationType, description);
            for (Element deliveryTypeElement : definitionElement.elements("delivery-type")) {
                String name = deliveryTypeElement.elementText("name");
                int type = GetterUtil.getInteger((String)deliveryTypeElement.elementText("type"));
                boolean defaultValue = GetterUtil.getBoolean((String)deliveryTypeElement.elementText("default"));
                boolean modifiable = GetterUtil.getBoolean((String)deliveryTypeElement.elementText("modifiable"));
                userNotificationDefinition.addUserNotificationDeliveryType(new UserNotificationDeliveryType(name, type, defaultValue, modifiable));
            }
            ServiceRegistration serviceRegistration = bundleContext.registerService(UserNotificationDefinition.class, (Object)userNotificationDefinition, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerUserNotificationHandlerInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String userNotificationHandlerClass : portlet.getUserNotificationHandlerClasses()) {
            UserNotificationHandler userNotificationHandlerInstance = this._newInstance(UserNotificationHandler.class, userNotificationHandlerClass);
            userNotificationHandlerInstance = new UserNotificationHandlerImpl(userNotificationHandlerInstance);
            ServiceRegistration serviceRegistration = bundleContext.registerService(UserNotificationHandler.class, (Object)userNotificationHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerWebDAVStorageInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        if (Validator.isNotNull((String)portlet.getWebDAVStorageClass())) {
            WebDAVStorage webDAVStorageInstance = this._newInstance(WebDAVStorage.class, portlet.getWebDAVStorageClass());
            bundleContext.registerService(WebDAVStorage.class, (Object)webDAVStorageInstance, (Dictionary)HashMapDictionaryBuilder.put((Object)"javax.portlet.name", (Object)portlet.getPortletId()).put((Object)"webdav.storage.token", (Object)portlet.getWebDAVStorageToken()).build());
        }
    }

    private void _registerWorkflowHandlerInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String workflowHandlerClass : portlet.getWorkflowHandlerClasses()) {
            WorkflowHandler workflowHandlerInstance = this._newInstance(WorkflowHandler.class, workflowHandlerClass);
            ServiceRegistration serviceRegistration = bundleContext.registerService(WorkflowHandler.class, (Object)workflowHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerXmlRpcMethodInstances(BundleContext bundleContext, com.liferay.portal.kernel.model.Portlet portlet, Dictionary<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getXmlRpcMethodClass())) {
            Method xmlRpcMethodInstance = this._newInstance(Method.class, portlet.getXmlRpcMethodClass());
            ServiceRegistration serviceRegistration = bundleContext.registerService(Method.class, (Object)xmlRpcMethodInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _validate() {
        if (this._classLoader == null) {
            throw new IllegalStateException("Class loader is null");
        }
        if (this._servletContext == null) {
            throw new IllegalStateException("Servlet context is null");
        }
        if (this._warFile == null) {
            throw new IllegalStateException("WAR file is null");
        }
    }
}

