/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.PDFProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.image.GhostscriptUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.event.FileVersionPreviewEventListener;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.util.LiferayPDFBoxConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.time.StopWatch;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;

public class PDFProcessorImpl
extends DLPreviewableProcessor
implements PDFProcessor {
    private static final Log _log;
    private static volatile FileVersionPreviewEventListener _fileVersionPreviewEventListener;
    private static final ProcessConfig _pdfProcessConfig;
    private static volatile ProcessExecutor _processExecutor;
    private final List<Long> _fileVersionIds = new Vector<Long>();
    private boolean _ghostscriptInitialized;

    public void afterPropertiesSet() {
        FileUtil.mkdirs((String)DECRYPT_TMP_PATH);
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    public void destroy() {
        FileUtil.deltree((String)TMP_PATH);
    }

    public void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateImages(sourceFileVersion, destinationFileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, index, "png");
    }

    public int getPreviewFileCount(FileVersion fileVersion) {
        try {
            return this.doGetPreviewFileCount(fileVersion);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return 0;
        }
    }

    public long getPreviewFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, index);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public String getType() {
        return "PDFProcessor";
    }

    public boolean hasImages(FileVersion fileVersion) {
        boolean hasImages = false;
        try {
            hasImages = this._hasImages(fileVersion);
            if (!hasImages && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return hasImages;
    }

    public boolean isDocumentSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isDocumentSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        if (mimeType.equals("application/pdf") || mimeType.equals("application/x-pdf")) {
            return true;
        }
        if (DocumentConversionUtil.isEnabled()) {
            Set extensions = MimeTypesUtil.getExtensions((String)mimeType);
            for (String extension : extensions) {
                Object[] targetExtensions = DocumentConversionUtil.getConversions((String)(extension = extension.substring(1)));
                if (Arrays.binarySearch(targetExtensions, "pdf") < 0) continue;
                return true;
            }
        }
        return false;
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void copyPreviews(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (!PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) {
            return;
        }
        try {
            if (this.hasPreview(sourceFileVersion) && !this.hasPreview(destinationFileVersion)) {
                int count = this.getPreviewFileCount(sourceFileVersion);
                for (int i = 0; i < count; ++i) {
                    String previewFilePath = this.getPreviewFilePath(destinationFileVersion, i + 1);
                    InputStream inputStream = this.doGetPreviewAsStream(sourceFileVersion, i + 1, "png");
                    this.addFileToStore(destinationFileVersion.getCompanyId(), "document_preview/", previewFilePath, inputStream);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "pdf");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this._hasImages(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            int previewFileCount = this.getPreviewFileCount(fileVersion);
            fileEntryElement.addAttribute("bin-path-pdf-preview-count", String.valueOf(previewFileCount));
            for (int i = 0; i < previewFileCount; ++i) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "pdf", "png", i);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return "png";
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "png";
    }

    protected boolean hasPreview(FileVersion fileVersion) throws Exception {
        return this.hasPreview(fileVersion, null);
    }

    protected boolean hasPreview(FileVersion fileVersion, String type) throws Exception {
        return DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)this.getPreviewFilePath(fileVersion, 1));
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        int previewFileCount = GetterUtil.getInteger((String)fileEntryElement.attributeValue("bin-path-pdf-preview-count"));
        for (int i = 0; i < previewFileCount; ++i) {
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf", "png", i);
        }
    }

    private void _addDimensions(List<String> arguments, File file) throws Exception {
        Map<String, Integer> scaledDimensions = this._getScaledDimensions(file);
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH != 0 && PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0) {
            arguments.add("-dDEVICEWIDTH=" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH);
            arguments.add("-dDEVICEHEIGHT=" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT);
        } else if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH != 0 && PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT == 0) {
            arguments.add("-dDEVICEWIDTH=" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH);
            arguments.add("-dDEVICEHEIGHT=" + scaledDimensions.get("height"));
        } else if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH == 0 && PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0) {
            arguments.add("-dDEVICEWIDTH=" + scaledDimensions.get("width"));
            arguments.add("-dDEVICEHEIGHT=" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT);
        }
    }

    private void _generateImages(FileVersion fileVersion, File file) throws Exception {
        if (GhostscriptUtil.isEnabled()) {
            this._generateImagesGS(fileVersion, file);
        } else {
            this._generateImagesPB(fileVersion, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block36: {
            try {
                if (sourceFileVersion != null) {
                    this.copy(sourceFileVersion, destinationFileVersion);
                    return;
                }
                if (this._hasImages(destinationFileVersion)) {
                    return;
                }
                String extension = destinationFileVersion.getExtension();
                if (extension.equals("pdf")) {
                    try (InputStream inputStream = destinationFileVersion.getContentStream(false);){
                        this._generateImages(destinationFileVersion, inputStream);
                        break block36;
                    }
                }
                if (!DocumentConversionUtil.isEnabled()) break block36;
                try (InputStream inputStream = destinationFileVersion.getContentStream(false);){
                    File file;
                    String tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
                    if (Objects.equals(destinationFileVersion.getVersion(), "PWC") || destinationFileVersion.isPending()) {
                        file = new File(DocumentConversionUtil.getFilePath((String)tempFileId, (String)"pdf"));
                        FileUtil.delete((File)file);
                    }
                    file = DocumentConversionUtil.convert((String)tempFileId, (InputStream)inputStream, (String)extension, (String)"pdf");
                    this._generateImages(destinationFileVersion, file);
                }
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)noSuchFileEntryException, (Throwable)noSuchFileEntryException);
                }
            }
            finally {
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            }
        }
    }

    private void _generateImages(FileVersion fileVersion, InputStream inputStream) throws Exception {
        if (GhostscriptUtil.isEnabled()) {
            this._generateImagesGS(fileVersion, inputStream);
        } else {
            this._generateImagesPB(fileVersion, inputStream);
        }
    }

    private void _generateImagesGS(FileVersion fileVersion, File file) throws Exception {
        StopWatch stopWatch;
        if (this._isGeneratePreview(fileVersion)) {
            stopWatch = new StopWatch();
            stopWatch.start();
            this._generateImagesGS(fileVersion, file, false);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Ghostscript generated ", this.getPreviewFileCount(fileVersion), " preview pages for ", fileVersion.getTitle(), " in ", stopWatch.getTime(), " ms"}));
            }
        }
        if (this._isGenerateThumbnail(fileVersion)) {
            stopWatch = new StopWatch();
            stopWatch.start();
            this._generateImagesGS(fileVersion, file, true);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Ghostscript generated a thumbnail for ", fileVersion.getTitle(), " in ", stopWatch.getTime(), " ms"}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesGS(FileVersion fileVersion, File file, boolean thumbnail) throws Exception {
        if (!this._ghostscriptInitialized) {
            GhostscriptUtil.reset();
            this._ghostscriptInitialized = true;
        }
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-sDEVICE=png16m");
        if (thumbnail) {
            arguments.add("-sOutputFile=" + this.getThumbnailTempFilePath(tempFileId));
            arguments.add("-dFirstPage=1");
            arguments.add("-dLastPage=1");
        } else {
            arguments.add("-sOutputFile=" + this.getPreviewTempFilePath(tempFileId, -1));
        }
        arguments.add("-dPDFFitPage");
        arguments.add("-dTextAlphaBits=4");
        arguments.add("-dGraphicsAlphaBits=4");
        arguments.add("-r" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI);
        this._addDimensions(arguments, file);
        arguments.add(file.getPath());
        Future future = GhostscriptUtil.execute(arguments);
        String processIdentity = String.valueOf(fileVersion.getFileVersionId());
        long ghostscriptTimeout = PropsValues.DL_FILE_ENTRY_PREVIEW_GENERATION_TIMEOUT_GHOSTSCRIPT;
        if (_log.isDebugEnabled()) {
            if (thumbnail) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Waiting for ", ghostscriptTimeout, " seconds to generate thumbnail for ", file.getPath()}));
            } else {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Waiting for ", ghostscriptTimeout, " seconds to generate preview for ", file.getPath()}));
            }
        }
        try {
            future.get(ghostscriptTimeout, TimeUnit.SECONDS);
            this.futures.put(processIdentity, future);
        }
        catch (TimeoutException timeoutException) {
            String errorMessage = "Timeout when generating preview for " + file.getPath();
            if (thumbnail) {
                errorMessage = "Timeout when generating thumbanil for " + file.getPath();
            }
            if (future.cancel(true)) {
                errorMessage = errorMessage + " resulted in a canceled timeout for " + future;
            }
            _fileVersionPreviewEventListener.onFailure(fileVersion);
            _log.error((Object)errorMessage);
            throw timeoutException;
        }
        catch (Exception exception) {
            _fileVersionPreviewEventListener.onFailure(fileVersion);
            _log.error((Object)exception, (Throwable)exception);
            throw exception;
        }
        if (thumbnail) {
            File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
            try {
                this.storeThumbnailImages(fileVersion, thumbnailTempFile);
            }
            finally {
                FileUtil.delete((File)thumbnailTempFile);
            }
        } else {
            int total = this.getPreviewTempFileCount(fileVersion);
            for (int i = 0; i < total; ++i) {
                File previewTempFile = this.getPreviewTempFile(tempFileId, i + 2);
                try {
                    this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, i + 1), previewTempFile);
                    _fileVersionPreviewEventListener.onSuccess(fileVersion);
                    continue;
                }
                finally {
                    FileUtil.delete((File)previewTempFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesGS(FileVersion fileVersion, InputStream inputStream) throws Exception {
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            this._generateImagesGS(fileVersion, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesPB(FileVersion fileVersion, File file) throws Exception {
        boolean generateThumbnail;
        boolean generatePreview;
        StopWatch stopWatch;
        File thumbnailFile;
        ProcessChannel previewFiles;
        File decryptedFile;
        block36: {
            int previewFilesCount;
            String tempFileId;
            block34: {
                tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
                decryptedFile = null;
                previewFiles = null;
                thumbnailFile = null;
                stopWatch = new StopWatch();
                generatePreview = this._isGeneratePreview(fileVersion);
                generateThumbnail = this._isGenerateThumbnail(fileVersion);
                decryptedFile = this.getDecryptedTempFile(tempFileId);
                previewFilesCount = this._getPreviewFilesCount(file, decryptedFile);
                if (previewFilesCount != 0) break block34;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to decrypt PDF document for file version " + fileVersion.getFileVersionId()));
                }
                _fileVersionPreviewEventListener.onFailure(fileVersion);
                FileUtil.delete((File)decryptedFile);
                FileUtil.delete((File)thumbnailFile);
                for (File previewFile : previewFiles) {
                    FileUtil.delete((File)previewFile);
                }
                return;
            }
            try {
                block35: {
                    thumbnailFile = this.getThumbnailTempFile(tempFileId);
                    previewFiles = new File[previewFilesCount];
                    for (int i = 0; i < previewFilesCount; ++i) {
                        previewFiles[i] = this.getPreviewTempFile(tempFileId, i);
                    }
                    stopWatch.start();
                    try {
                        if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
                            LiferayPDFBoxProcessCallable processCallable = new LiferayPDFBoxProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), HashMapBuilder.putAll((Map)Log4JUtil.getCustomLogSettings()).put((Object)PropsUtil.class.getName(), (Object)"WARN").build(), decryptedFile, thumbnailFile, (File[])previewFiles, this.getThumbnailType(fileVersion), this.getPreviewType(fileVersion), PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH, generatePreview, generateThumbnail);
                            ProcessChannel processChannel = _processExecutor.execute(_pdfProcessConfig, (ProcessCallable)processCallable);
                            NoticeableFuture future = processChannel.getProcessNoticeableFuture();
                            String processIdentity = String.valueOf(fileVersion.getFileVersionId());
                            long pdfBoxTimeout = PropsValues.DL_FILE_ENTRY_PREVIEW_GENERATION_TIMEOUT_PDFBOX;
                            if (_log.isDebugEnabled()) {
                                if (generateThumbnail && generatePreview) {
                                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Waiting for ", pdfBoxTimeout, " seconds to generate thumbnail and ", "preview for ", decryptedFile.getPath()}));
                                } else {
                                    if (generateThumbnail) {
                                        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Waiting for ", pdfBoxTimeout, " seconds to generate thumbnail for ", decryptedFile.getPath()}));
                                    }
                                    if (generatePreview) {
                                        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Waiting for ", pdfBoxTimeout, " seconds to generate preview for ", decryptedFile.getPath()}));
                                    }
                                }
                            }
                            try {
                                future.get(pdfBoxTimeout, TimeUnit.SECONDS);
                                this.futures.put(processIdentity, future);
                                break block35;
                            }
                            catch (TimeoutException timeoutException) {
                                String message = null;
                                if (generateThumbnail && generatePreview) {
                                    message = StringBundler.concat((String[])new String[]{"Timeout when generating thumbnail and ", "preview for ", decryptedFile.getPath()});
                                } else {
                                    if (generateThumbnail) {
                                        message = "Timeout when generating thumbnail for " + decryptedFile.getPath();
                                    }
                                    if (generatePreview) {
                                        message = "Timeout when generating preview for " + decryptedFile.getPath();
                                    }
                                }
                                if (future.cancel(true)) {
                                    message = message + " resulted in a canceled timeout for " + future;
                                }
                                _fileVersionPreviewEventListener.onFailure(fileVersion);
                                if (_log.isWarnEnabled()) {
                                    _log.warn((Object)message);
                                }
                                throw timeoutException;
                            }
                        }
                        LiferayPDFBoxConverter liferayConverter = new LiferayPDFBoxConverter(decryptedFile, thumbnailFile, (File[])previewFiles, this.getPreviewType(fileVersion), this.getThumbnailType(fileVersion), PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH, generatePreview, generateThumbnail);
                        liferayConverter.generateImagesPB();
                    }
                    catch (TimeoutException timeoutException) {
                        throw timeoutException;
                    }
                    catch (Exception exception) {
                        _fileVersionPreviewEventListener.onFailure(fileVersion);
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to process ", fileVersion.getFileVersionId(), " ", fileVersion.getTitle()}));
                        }
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)exception, (Throwable)exception);
                        }
                        throw exception;
                    }
                }
                if (generateThumbnail) {
                    this.storeThumbnailImages(fileVersion, thumbnailFile);
                }
                if (!generatePreview) break block36;
                int index = 0;
                for (ProcessChannel previewFile : previewFiles) {
                    this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, index + 1), (File)previewFile);
                    _fileVersionPreviewEventListener.onSuccess(fileVersion);
                    ++index;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete((File)decryptedFile);
                FileUtil.delete(thumbnailFile);
                for (File previewFile : previewFiles) {
                    FileUtil.delete((File)previewFile);
                }
                throw throwable;
            }
        }
        FileUtil.delete((File)decryptedFile);
        FileUtil.delete((File)thumbnailFile);
        for (ProcessChannel previewFile : previewFiles) {
            FileUtil.delete((File)previewFile);
        }
        if (!_log.isInfoEnabled()) {
            return;
        }
        long fileVersionId = fileVersion.getFileVersionId();
        int previewFileCount = this.getPreviewFileCount(fileVersion);
        long time = stopWatch.getTime();
        if (generateThumbnail && generatePreview) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"PDFBox generated a thumbnail and ", previewFileCount, " preview pages for ", fileVersionId, " in ", time, " ms"}));
        } else {
            if (generateThumbnail) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"PDFBox generated a thumbnail for ", fileVersionId, " in ", time, " ms"}));
            }
            if (generatePreview) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"PDFBox generated ", previewFileCount, " preview pages for ", fileVersionId, " in ", time, " ms"}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesPB(FileVersion fileVersion, InputStream inputStream) throws Exception {
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            this._generateImagesPB(fileVersion, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _getPreviewFilesCount(File encryptedFile, File decryptedFile) {
        String[] decryptPasswords;
        String[] stringArray = decryptPasswords = (String[])ArrayUtil.append((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_GENERATION_DECRYPT_PASSWORDS_PDFBOX, (Object)"");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String decryptPassword = stringArray[n2];
            try (PDDocument pdDocument = PDDocument.load((File)encryptedFile, (String)decryptPassword);){
                pdDocument.setAllSecurityToBeRemoved(true);
                pdDocument.save(decryptedFile);
                int n3 = pdDocument.getNumberOfPages();
                return n3;
            }
            catch (IOException ioException) {
                if (!(ioException instanceof InvalidPasswordException)) {
                    _log.error((Object)ioException, (Throwable)ioException);
                }
                ++n2;
            }
        }
        return 0;
    }

    private Map<String, Integer> _getScaledDimensions(File file) throws Exception {
        try (PDDocument pdDocument = PDDocument.load((File)file);){
            PDDocumentCatalog pdDocumentCatalog = pdDocument.getDocumentCatalog();
            PDPageTree pages = pdDocumentCatalog.getPages();
            PDPage pdPage = pages.get(0);
            PDRectangle pdRectangle = pdPage.getMediaBox();
            float height = pdRectangle.getHeight();
            float width = pdRectangle.getWidth();
            HashMap hashMap = HashMapBuilder.put((Object)"height", () -> {
                double widthFactor = (double)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH / (double)width;
                return (int)Math.round(widthFactor * (double)height);
            }).put((Object)"width", () -> {
                double heightFactor = (double)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT / (double)height;
                return (int)Math.round(heightFactor * (double)width);
            }).build();
            return hashMap;
        }
    }

    private boolean _hasImages(FileVersion fileVersion) throws Exception {
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !this.hasPreview(fileVersion)) {
            return false;
        }
        return this.hasThumbnails(fileVersion);
    }

    private boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
        return PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !this.hasPreview(fileVersion);
    }

    private boolean _isGenerateThumbnail(FileVersion fileVersion) {
        return PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !this.hasThumbnail(fileVersion, 0);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId())) {
            return;
        }
        boolean generateImages = false;
        String extension = destinationFileVersion.getExtension();
        if (extension.equals("pdf")) {
            generateImages = true;
        } else if (DocumentConversionUtil.isEnabled()) {
            String[] conversions;
            for (String conversion : conversions = DocumentConversionUtil.getConversions((String)extension)) {
                if (!conversion.equals("pdf")) continue;
                generateImages = true;
                break;
            }
        }
        if (generateImages) {
            this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
            this.sendGenerationMessage("liferay/document_library_pdf_processor", sourceFileVersion, destinationFileVersion);
        }
    }

    static {
        String jvmOptions;
        _log = LogFactoryUtil.getLog(PDFProcessorImpl.class);
        _fileVersionPreviewEventListener = (FileVersionPreviewEventListener)ServiceProxyFactory.newServiceTrackedInstance(FileVersionPreviewEventListener.class, PDFProcessorImpl.class, (String)"_fileVersionPreviewEventListener", (boolean)false, (boolean)false);
        _processExecutor = (ProcessExecutor)ServiceProxyFactory.newServiceTrackedInstance(ProcessExecutor.class, PDFProcessorImpl.class, (String)"_processExecutor", (boolean)true);
        ProcessConfig pdfProcessConfig = PortalClassPathUtil.getPortalProcessConfig();
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED && !(jvmOptions = StringUtil.trim((String)PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_JVM_OPTIONS)).isEmpty()) {
            ProcessConfig.Builder pdfProcessBuilder = new ProcessConfig.Builder(pdfProcessConfig);
            Collections.addAll(pdfProcessBuilder.getArguments(), StringUtil.split((String)jvmOptions));
            pdfProcessConfig = pdfProcessBuilder.build();
        }
        _pdfProcessConfig = pdfProcessConfig;
    }

    private static class LiferayPDFBoxProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> _customLogSettings;
        private final int _dpi;
        private final String _extension;
        private final boolean _generatePreview;
        private final boolean _generateThumbnail;
        private final int _height;
        private final File _inputFile;
        private final String _liferayHome;
        private final File[] _previewFiles;
        private final String _serverId;
        private final String _thumbnailExtension;
        private final File _thumbnailFile;
        private final int _width;

        public LiferayPDFBoxProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, File inputFile, File thumbnailFile, File[] previewFiles, String extension, String thumbnailExtension, int dpi, int height, int width, boolean generatePreview, boolean generateThumbnail) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputFile = inputFile;
            this._thumbnailFile = thumbnailFile;
            this._previewFiles = previewFiles;
            this._extension = extension;
            this._thumbnailExtension = thumbnailExtension;
            this._dpi = dpi;
            this._height = height;
            this._width = width;
            this._generatePreview = generatePreview;
            this._generateThumbnail = generateThumbnail;
        }

        public String call() throws ProcessException {
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties((Properties)systemProperties);
            Class<?> clazz = this.getClass();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)clazz.getClassLoader(), (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayPDFBoxConverter liferayConverter = new LiferayPDFBoxConverter(this._inputFile, this._thumbnailFile, this._previewFiles, this._extension, this._thumbnailExtension, this._dpi, this._height, this._width, this._generatePreview, this._generateThumbnail);
                liferayConverter.generateImagesPB();
            }
            catch (Exception exception) {
                throw new ProcessException((Throwable)exception);
            }
            return "";
        }
    }
}

