/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.easyconf;

import com.germinus.easyconf.AggregatedProperties;
import com.germinus.easyconf.ConfigurationException;
import com.germinus.easyconf.ConfigurationNotFoundException;
import com.germinus.easyconf.DatasourceURL;
import com.germinus.easyconf.FileConfigurationChangedReloadingStrategy;
import com.germinus.easyconf.JndiURL;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class ClassLoaderAggregateProperties
extends AggregatedProperties {
    private static final Log _log = LogFactoryUtil.getLog(ClassLoaderAggregateProperties.class);
    private static final Field _commentField;
    private static final Field _layoutDataField;
    private final CompositeConfiguration _baseCompositeConfiguration = new CompositeConfiguration();
    private final ClassLoader _classLoader;
    private final String _companyId;
    private final String _componentName;
    private final CompositeConfiguration _globalCompositeConfiguration = new CompositeConfiguration();
    private final List<String> _loadedSources = new ArrayList<String>();
    private final Configuration _prefixedSystemConfiguration;
    private final SystemConfiguration _systemConfiguration = new SystemConfiguration();

    public ClassLoaderAggregateProperties(ClassLoader classLoader, String companyId, String componentName) {
        super(companyId, componentName);
        this._classLoader = classLoader;
        this._companyId = companyId;
        this._componentName = componentName;
        this._prefixedSystemConfiguration = new SubsetConfiguration((Configuration)this._systemConfiguration, this._getPrefix(), null);
    }

    public void addBaseFileName(String fileName) {
        URL url = this._classLoader.getResource(fileName);
        Configuration configuration = this._addPropertiesSource(fileName, url, this._baseCompositeConfiguration);
        if (configuration == null) {
            throw new ConfigurationNotFoundException(this._componentName, "The base properties file was not found");
        }
        if (configuration.isEmpty() && _log.isDebugEnabled()) {
            _log.debug((Object)("Empty configuration " + fileName));
        }
    }

    public void addGlobalFileName(String fileName) {
        URL url = this._classLoader.getResource(fileName);
        this._addPropertiesSource(fileName, url, this._globalCompositeConfiguration);
    }

    public CompositeConfiguration getBaseConfiguration() {
        return this._baseCompositeConfiguration;
    }

    public String getComponentName() {
        return this._componentName;
    }

    public Object getProperty(String key) {
        Object value = null;
        if (value == null) {
            value = System.getProperty(this._getPrefix().concat(key));
        }
        if (value == null) {
            value = this._globalCompositeConfiguration.getProperty(this._getPrefix().concat(key));
        }
        if (value == null) {
            value = this._globalCompositeConfiguration.getProperty(key);
        }
        if (value == null) {
            value = this._baseCompositeConfiguration.getProperty(key);
        }
        if (value == null) {
            value = super.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        if (value == null && key.equals("easyconf:companyId")) {
            value = this._companyId;
        }
        if (value == null && key.equals("easyconf:componentName")) {
            value = this._componentName;
        }
        return value;
    }

    public List<String> loadedSources() {
        return this._loadedSources;
    }

    private Configuration _addDatasourceProperties(String datasourcePath) {
        DatasourceURL datasourceURL = new DatasourceURL(datasourcePath, this._companyId, this._componentName, "easyconf_properties");
        return datasourceURL.getConfiguration();
    }

    private Configuration _addFileProperties(String fileName, CompositeConfiguration loadedCompositeConfiguration) throws ConfigurationException {
        try {
            Long delay;
            PropertiesConfiguration newFileConfiguration = new PropertiesConfiguration(fileName){

                public String getEncoding() {
                    return "UTF-8";
                }
            };
            URL url = newFileConfiguration.getURL();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding file " + url));
            }
            if ((delay = this._getReloadDelay(loadedCompositeConfiguration, (FileConfiguration)newFileConfiguration)) != null) {
                FileConfigurationChangedReloadingStrategy fileChangedReloadingStrategy = new FileConfigurationChangedReloadingStrategy();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"File ", String.valueOf(url), " will be reloaded every ", String.valueOf(delay), " seconds"}));
                }
                long milliseconds = delay * 1000L;
                fileChangedReloadingStrategy.setRefreshDelay(milliseconds);
                newFileConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
            }
            this._addIncludedPropertiesSources((Configuration)newFileConfiguration, loadedCompositeConfiguration);
            return newFileConfiguration;
        }
        catch (org.apache.commons.configuration.ConfigurationException ce) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Configuration source " + fileName + " ignored"));
            }
            return null;
        }
    }

    private void _addIncludedPropertiesSources(Configuration newConfiguration, CompositeConfiguration loadedCompositeConfiguration) {
        CompositeConfiguration tempCompositeConfiguration = new CompositeConfiguration();
        tempCompositeConfiguration.addConfiguration(this._prefixedSystemConfiguration);
        tempCompositeConfiguration.addConfiguration(newConfiguration);
        tempCompositeConfiguration.addConfiguration((Configuration)this._systemConfiguration);
        tempCompositeConfiguration.addProperty("easyconf:companyId", (Object)this._companyId);
        tempCompositeConfiguration.addProperty("easyconf:componentName", (Object)this._componentName);
        Object[] fileNames = tempCompositeConfiguration.getStringArray("include-and-override");
        ArrayUtil.reverse((Object[])fileNames);
        for (Object fileName : fileNames) {
            URL url = null;
            try {
                url = this._classLoader.getResource((String)fileName);
            }
            catch (RuntimeException re) {
                if (((String)fileName).startsWith("file:/")) {
                    throw re;
                }
                fileName = "file:/".concat((String)fileName);
                url = this._classLoader.getResource((String)fileName);
            }
            this._addPropertiesSource((String)fileName, url, loadedCompositeConfiguration);
        }
    }

    private Configuration _addJNDIProperties(String sourcePath) {
        JndiURL jndiURL = new JndiURL(sourcePath, this._companyId, this._componentName);
        return jndiURL.getConfiguration();
    }

    private Configuration _addPropertiesSource(String sourceName, URL url, CompositeConfiguration loadedCompositeConfiguration) {
        try {
            Configuration newConfiguration = null;
            newConfiguration = DatasourceURL.isDatasource((String)sourceName) ? this._addDatasourceProperties(sourceName) : (JndiURL.isJndi((String)sourceName) ? this._addJNDIProperties(sourceName) : (url != null ? this._addURLProperties(url, loadedCompositeConfiguration) : this._addFileProperties(sourceName, loadedCompositeConfiguration)));
            if (newConfiguration == null) {
                return newConfiguration;
            }
            loadedCompositeConfiguration.addConfiguration(newConfiguration);
            super.addConfiguration(newConfiguration);
            if (newConfiguration instanceof AbstractFileConfiguration) {
                AbstractFileConfiguration abstractFileConfiguration = (AbstractFileConfiguration)newConfiguration;
                URL abstractFileConfigurationURL = abstractFileConfiguration.getURL();
                this._loadedSources.add(abstractFileConfigurationURL.toString());
            } else {
                this._loadedSources.add(sourceName);
            }
            return newConfiguration;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Configuration source ", sourceName, " ignored: ", e.getMessage()}));
            }
            return null;
        }
    }

    private Configuration _addURLProperties(URL url, CompositeConfiguration loadedCompositeConfiguration) throws ConfigurationException {
        try {
            Long delay;
            PropertiesConfiguration propertiesConfiguration;
            block9: {
                propertiesConfiguration = new PropertiesConfiguration(url){

                    public String getEncoding() {
                        return "UTF-8";
                    }
                };
                PropertiesConfigurationLayout propertiesConfigurationLayout = propertiesConfiguration.getLayout();
                try {
                    Map layoutData = (Map)_layoutDataField.get(propertiesConfigurationLayout);
                    for (Object propertyLayoutData : layoutData.values()) {
                        _commentField.set(propertyLayoutData, null);
                    }
                }
                catch (ReflectiveOperationException roe) {
                    if (!_log.isWarnEnabled()) break block9;
                    _log.warn((Object)("Unable to clear out comments from " + propertiesConfiguration), (Throwable)roe);
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding resource " + url));
            }
            if ((delay = this._getReloadDelay(loadedCompositeConfiguration, (FileConfiguration)propertiesConfiguration)) != null) {
                FileConfigurationChangedReloadingStrategy fileChangedReloadingStrategy = new FileConfigurationChangedReloadingStrategy();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Resource ", String.valueOf(url), " will be reloaded every ", String.valueOf(delay), " seconds"}));
                }
                long milliseconds = delay * 1000L;
                fileChangedReloadingStrategy.setRefreshDelay(milliseconds);
                propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
            }
            this._addIncludedPropertiesSources((Configuration)propertiesConfiguration, loadedCompositeConfiguration);
            return propertiesConfiguration;
        }
        catch (org.apache.commons.configuration.ConfigurationException ce) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Configuration source " + url + " ignored"));
            }
            return null;
        }
    }

    private String _getPrefix() {
        return this._componentName.concat(":");
    }

    private Long _getReloadDelay(CompositeConfiguration loadedCompositeConfiguration, FileConfiguration newFileConfiguration) {
        Long delay = newFileConfiguration.getLong("easyconf:reload-delay", null);
        if (delay == null) {
            delay = loadedCompositeConfiguration.getLong("easyconf:reload-delay", null);
        }
        return delay;
    }

    static {
        try {
            ClassLoader classLoader = PropertiesConfigurationLayout.class.getClassLoader();
            Class<?> propertyLayoutDataClass = classLoader.loadClass(PropertiesConfigurationLayout.class.getName() + "$PropertyLayoutData");
            _commentField = ReflectionUtil.getDeclaredField(propertyLayoutDataClass, (String)"comment");
            _layoutDataField = ReflectionUtil.getDeclaredField(PropertiesConfigurationLayout.class, (String)"layoutData");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

