/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.license.sigar;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarLoader;

public class SigarNativeLoader {
    private static final Log _log = LogFactoryUtil.getLog((String)SigarNativeLoader.class.getName());

    public static synchronized void load() throws Exception {
        if (SigarNativeLoader._isNativeLibraryLoaded()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Sigar native library is already loaded");
            }
            return;
        }
        File targetDirectory = SigarNativeLoader._getTargetDirectory();
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        SigarLoader sigarLoader = new SigarLoader(Sigar.class);
        String libraryName = sigarLoader.getLibraryName();
        InputStream inputStream = SigarNativeLoader.class.getResourceAsStream("/com/liferay/portal/license/sigar/dependencies/" + libraryName);
        File targetFile = new File(targetDirectory, libraryName);
        targetFile = targetFile.getAbsoluteFile();
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        SigarNativeLoader._copy(inputStream, outputStream);
        inputStream.close();
        ((OutputStream)outputStream).close();
        String libraryPath = targetFile.getAbsolutePath();
        System.load(libraryPath);
        System.setProperty("org.hyperic.sigar.path", "-");
        sigarLoader.load();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sigar native library " + libraryPath + " is loaded"));
        }
    }

    public static void unload() throws Exception {
        Field nativeLibrariesField = ClassLoader.class.getDeclaredField("nativeLibraries");
        nativeLibrariesField.setAccessible(true);
        Vector nativeLibraries = (Vector)nativeLibrariesField.get(SigarNativeLoader.class.getClassLoader());
        SigarLoader sigarLoader = new SigarLoader(Sigar.class);
        String libraryName = sigarLoader.getLibraryName();
        for (Object nativeLibrary : nativeLibraries) {
            Class<?> nativeLibraryClass = nativeLibrary.getClass();
            Field nameField = nativeLibraryClass.getDeclaredField("name");
            nameField.setAccessible(true);
            File file = new File((String)nameField.get(nativeLibrary));
            String name = file.getName();
            if (!name.contains(libraryName)) continue;
            Method finalizeMethod = nativeLibraryClass.getDeclaredMethod("finalize", new Class[0]);
            finalizeMethod.setAccessible(true);
            finalizeMethod.invoke(nativeLibrary, new Object[0]);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Sigar native library " + libraryName + " has been unloaded"));
        }
        FileUtil.deltree((File)SigarNativeLoader._getTargetDirectory());
    }

    private static void _copy(InputStream inputStream, OutputStream outputStream) throws Exception {
        int count;
        int size = 65536;
        byte[] data = new byte[size];
        while ((count = inputStream.read(data, 0, size)) != -1) {
            outputStream.write(data, 0, count);
        }
    }

    private static File _getTargetDirectory() {
        StringBundler sb = new StringBundler(5);
        sb.append(PropsUtil.get((String)"liferay.home"));
        sb.append(File.separator);
        sb.append("data");
        sb.append(File.separator);
        sb.append("sigar");
        return new File(sb.toString());
    }

    private static synchronized boolean _isNativeLibraryLoaded() {
        try {
            Field loadedLibraryNamesField = ClassLoader.class.getDeclaredField("loadedLibraryNames");
            loadedLibraryNamesField.setAccessible(true);
            Vector libraryNames = (Vector)loadedLibraryNamesField.get(SigarNativeLoader.class.getClassLoader());
            SigarLoader sigarLoader = new SigarLoader(Sigar.class);
            for (String libraryName : libraryNames) {
                if (!libraryName.contains(sigarLoader.getLibraryName())) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            try {
                Sigar sigar = new Sigar();
                sigar.getPid();
                sigar.close();
                return true;
            }
            catch (Throwable t1) {
                return false;
            }
        }
    }
}

