/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.service.base.ListTypeLocalServiceBaseImpl;
import java.util.List;

public class ListTypeLocalServiceImpl
extends ListTypeLocalServiceBaseImpl {
    public ListType addListType(String name, String type) {
        ListType listType = this.listTypePersistence.fetchByN_T(name, type);
        if (listType != null) {
            return listType;
        }
        long listTypeId = this.counterLocalService.increment(ListType.class.getName());
        listType = this.listTypePersistence.create(listTypeId);
        listType.setName(name);
        listType.setType(type);
        this.listTypePersistence.update((BaseModel)listType);
        return listType;
    }

    @Override
    public ListType getListType(long listTypeId) throws PortalException {
        return this.listTypePersistence.findByPrimaryKey(listTypeId);
    }

    public ListType getListType(String name, String type) {
        return this.listTypePersistence.fetchByN_T(name, type);
    }

    public List<ListType> getListTypes(String type) {
        return this.listTypePersistence.findByType(type);
    }

    public void validate(long listTypeId, long classNameId, String type) throws PortalException {
        ClassName className = this.classNameLocalService.getClassName(classNameId);
        this.validate(listTypeId, className.getValue() + type);
    }

    public void validate(long listTypeId, String type) throws PortalException {
        ListType listType = this.listTypePersistence.fetchByPrimaryKey(listTypeId);
        String listTypeType = listType.getType();
        if (listType == null || !listTypeType.equals(type)) {
            NoSuchListTypeException nslte = new NoSuchListTypeException();
            nslte.setType(type);
            throw nslte;
        }
    }
}

