/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.spring.aop.AdvisedSupport;
import com.liferay.portal.kernel.spring.aop.AopProxy;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AdvisedSupportProxy;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import com.liferay.portal.spring.aop.MethodInterceptorsBag;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManager;
import com.liferay.portal.spring.aop.ServiceBeanMethodInvocation;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;

public class ServiceBeanAopProxy
implements AdvisedSupportProxy,
AopProxy,
InvocationHandler {
    private final AdvisedSupport _advisedSupport;
    private final List<MethodInterceptor> _classLevelMethodInterceptors;
    private final List<MethodInterceptor> _fullMethodInterceptors;
    private final ServiceBeanAopCacheManager _serviceBeanAopCacheManager;

    public static AdvisedSupport getAdvisedSupport(Object proxy) throws Exception {
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)proxy);
        if (invocationHandler instanceof AdvisedSupportProxy) {
            AdvisedSupportProxy advisableSupportProxy = (AdvisedSupportProxy)((Object)invocationHandler);
            return advisableSupportProxy.getAdvisedSupport();
        }
        return null;
    }

    public ServiceBeanAopProxy(AdvisedSupport advisedSupport, MethodInterceptor methodInterceptor, ServiceBeanAopCacheManager serviceBeanAopCacheManager) {
        this._advisedSupport = advisedSupport;
        ArrayList<MethodInterceptor> classLevelMethodInterceptors = new ArrayList<MethodInterceptor>();
        ArrayList<MethodInterceptor> fullMethodInterceptors = new ArrayList<MethodInterceptor>();
        while (true) {
            if (!(methodInterceptor instanceof ChainableMethodAdvice)) break;
            ChainableMethodAdvice chainableMethodAdvice = (ChainableMethodAdvice)methodInterceptor;
            chainableMethodAdvice.setServiceBeanAopCacheManager(serviceBeanAopCacheManager);
            if (methodInterceptor instanceof AnnotationChainableMethodAdvice) {
                AnnotationChainableMethodAdvice annotationChainableMethodAdvice = (AnnotationChainableMethodAdvice)methodInterceptor;
                Class<Annotation> annotationClass = annotationChainableMethodAdvice.getAnnotationClass();
                Target target = annotationClass.getAnnotation(Target.class);
                if (target == null) {
                    classLevelMethodInterceptors.add(methodInterceptor);
                } else {
                    for (ElementType elementType : target.value()) {
                        if (elementType != ElementType.TYPE) continue;
                        classLevelMethodInterceptors.add(methodInterceptor);
                        break;
                    }
                }
            } else {
                classLevelMethodInterceptors.add(methodInterceptor);
            }
            fullMethodInterceptors.add(methodInterceptor);
            methodInterceptor = chainableMethodAdvice.nextMethodInterceptor;
        }
        classLevelMethodInterceptors.add(methodInterceptor);
        fullMethodInterceptors.add(methodInterceptor);
        classLevelMethodInterceptors.trimToSize();
        this._classLevelMethodInterceptors = classLevelMethodInterceptors;
        this._fullMethodInterceptors = fullMethodInterceptors;
        this._serviceBeanAopCacheManager = serviceBeanAopCacheManager;
    }

    @Override
    public AdvisedSupport getAdvisedSupport() {
        return this._advisedSupport;
    }

    public Object getProxy(ClassLoader classLoader) {
        return ProxyUtil.newProxyInstance((ClassLoader)classLoader, (Class[])this._advisedSupport.getProxiedInterfaces(), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = new ServiceBeanMethodInvocation(this._advisedSupport.getTarget(), method, arguments);
        this._setMethodInterceptors(serviceBeanMethodInvocation);
        return serviceBeanMethodInvocation.proceed();
    }

    private void _setMethodInterceptors(ServiceBeanMethodInvocation serviceBeanMethodInvocation) {
        MethodInterceptorsBag methodInterceptorsBag = this._serviceBeanAopCacheManager.getMethodInterceptorsBag(serviceBeanMethodInvocation);
        if (methodInterceptorsBag == null) {
            ArrayList<MethodInterceptor> methodInterceptors = new ArrayList<MethodInterceptor>(this._fullMethodInterceptors);
            methodInterceptorsBag = new MethodInterceptorsBag(this._classLevelMethodInterceptors, methodInterceptors);
            this._serviceBeanAopCacheManager.putMethodInterceptorsBag(serviceBeanMethodInvocation, methodInterceptorsBag);
        }
        serviceBeanMethodInvocation.setMethodInterceptors(methodInterceptorsBag.getMergedMethodInterceptors());
    }

    @Deprecated
    public static interface PACL {
        public InvocationHandler getInvocationHandler(InvocationHandler var1, AdvisedSupport var2);
    }
}

