/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.content.ContentUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;

public class RobotsUtil {
    public static String getDefaultRobots() {
        int portalServerPort = PortalUtil.getPortalServerPort((boolean)false);
        return RobotsUtil.getDefaultRobots(null, false, portalServerPort);
    }

    public static String getDefaultRobots(String virtualHost, boolean secure, int port) {
        if (Validator.isNotNull((String)virtualHost)) {
            String content = ContentUtil.get((ClassLoader)RobotsUtil.class.getClassLoader(), (String)PropsValues.ROBOTS_TXT_WITH_SITEMAP);
            content = StringUtil.replace((String)content, (String)"[$HOST$]", (String)virtualHost);
            content = StringUtil.replace((String)content, (String)"[$PORT$]", (String)String.valueOf(port));
            content = secure ? StringUtil.replace((String)content, (String)"[$PROTOCOL$]", (String)"https") : StringUtil.replace((String)content, (String)"[$PROTOCOL$]", (String)"http");
            return content;
        }
        return ContentUtil.get((ClassLoader)RobotsUtil.class.getClassLoader(), (String)PropsValues.ROBOTS_TXT_WITHOUT_SITEMAP);
    }

    public static String getRobots(LayoutSet layoutSet, boolean secure) throws PortalException {
        int portalServerPort = PortalUtil.getPortalServerPort((boolean)secure);
        if (layoutSet == null) {
            return RobotsUtil.getDefaultRobots(null, secure, portalServerPort);
        }
        return GetterUtil.get((String)layoutSet.getSettingsProperty(layoutSet.isPrivateLayout() + "-robots.txt"), (String)RobotsUtil.getDefaultRobots(PortalUtil.getVirtualHostname((LayoutSet)layoutSet), secure, portalServerPort));
    }
}

