/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.util.AdminUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UpdateLanguageAction
extends Action {
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        if (LanguageUtil.isAvailableLocale((long)themeDisplay.getSiteGroupId(), (Locale)locale)) {
            boolean persistState = ParamUtil.getBoolean((HttpServletRequest)request, (String)"persistState", (boolean)true);
            if (themeDisplay.isSignedIn() && persistState) {
                User user = themeDisplay.getUser();
                Contact contact = user.getContact();
                AdminUtil.updateUser(request, user.getUserId(), user.getScreenName(), user.getEmailAddress(), user.getFacebookId(), user.getOpenId(), languageId, user.getTimeZoneId(), user.getGreeting(), user.getComments(), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn());
            }
            HttpSession session = request.getSession();
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
            LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
        }
        String redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
        String layoutURL = "";
        String queryString = "";
        int pos = redirect.indexOf("/-/");
        if (pos == -1) {
            pos = redirect.indexOf("?");
        }
        if (pos != -1) {
            layoutURL = redirect.substring(0, pos);
            queryString = redirect.substring(pos);
        } else {
            layoutURL = redirect;
        }
        Layout layout = themeDisplay.getLayout();
        if (this.isGroupFriendlyURL(layout.getGroup(), layout, layoutURL, locale)) {
            if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0) {
                redirect = layoutURL;
                if (themeDisplay.isI18n()) {
                    String i18nPath = themeDisplay.getI18nPath();
                    redirect = redirect.substring(i18nPath.length());
                }
            } else {
                redirect = PortalUtil.getGroupFriendlyURL((LayoutSet)layout.getLayoutSet(), (ThemeDisplay)themeDisplay, (Locale)locale);
            }
        } else {
            redirect = PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0 ? PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay, (Locale)locale) : PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay, (Locale)locale);
        }
        if (Validator.isNotNull((String)queryString)) {
            redirect = redirect + queryString;
        }
        response.sendRedirect(redirect);
        return null;
    }

    protected boolean isGroupFriendlyURL(Group group, Layout layout, String layoutURL, Locale locale) {
        if (Validator.isNull((String)layoutURL)) {
            return true;
        }
        int pos = layoutURL.lastIndexOf(47);
        String layoutURLLanguageId = layoutURL.substring(pos + 1);
        Locale layoutURLLocale = LocaleUtil.fromLanguageId((String)layoutURLLanguageId, (boolean)true, (boolean)false);
        if (layoutURLLocale != null) {
            return true;
        }
        return PortalUtil.isGroupFriendlyURL((String)layoutURL, (String)group.getFriendlyURL(), (String)layout.getFriendlyURL(locale));
    }
}

