/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.apache.bridges.struts;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portlet.LiferayPortletUtil;
import com.liferay.portlet.PortletServletRequest;
import com.liferay.portlet.PortletServletResponse;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LiferayRequestDispatcher
implements RequestDispatcher {
    private final String _path;
    private final RequestDispatcher _requestDispatcher;

    public LiferayRequestDispatcher(RequestDispatcher requestDispatcher, String path) {
        this._requestDispatcher = requestDispatcher;
        this._path = path;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        PortletRequest portletRequest = (PortletRequest)servletRequest.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            this.invoke(servletRequest, servletResponse, false);
        } else {
            this._requestDispatcher.forward(servletRequest, servletResponse);
        }
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        PortletRequest portletRequest = (PortletRequest)servletRequest.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            this.invoke(servletRequest, servletResponse, true);
        } else {
            this._requestDispatcher.include(servletRequest, servletResponse);
        }
    }

    public void invoke(ServletRequest servletRequest, ServletResponse servletResponse, boolean include) throws IOException, ServletException {
        String pathInfo = null;
        String queryString = null;
        String requestURI = null;
        String servletPath = null;
        PortletRequest portletRequest = (PortletRequest)servletRequest.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)servletRequest.getAttribute("javax.portlet.response");
        if (this._path != null) {
            String pathNoQueryString = this._path;
            int pos = this._path.indexOf(63);
            if (pos != -1) {
                pathNoQueryString = this._path.substring(0, pos);
                queryString = this._path.substring(pos + 1);
                servletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)((HttpServletRequest)servletRequest), (String)queryString);
            }
            Set<String> servletURLPatterns = this.getServletURLPatterns(servletRequest, portletRequest, portletResponse);
            for (String urlPattern : servletURLPatterns) {
                if (!urlPattern.endsWith("/*") || !pathNoQueryString.startsWith(urlPattern = urlPattern.substring(0, (pos = urlPattern.indexOf("/*")) + 1))) continue;
                pathInfo = pathNoQueryString.substring(urlPattern.length());
                servletPath = urlPattern;
                break;
            }
            if (pathInfo == null && servletPath == null) {
                pathInfo = "";
                servletPath = pathNoQueryString;
            }
            requestURI = portletRequest.getContextPath() + pathNoQueryString;
        }
        HttpServletRequest portletServletRequest = this.getPortletServletRequest(servletRequest, portletRequest, pathInfo, queryString, requestURI, servletPath, include);
        HttpServletResponse portletServletResponse = this.getPortletServletResponse(servletResponse, portletRequest, portletResponse, include);
        if (include) {
            this._requestDispatcher.include((ServletRequest)portletServletRequest, (ServletResponse)portletServletResponse);
        } else {
            this._requestDispatcher.forward((ServletRequest)portletServletRequest, (ServletResponse)portletServletResponse);
        }
    }

    protected HttpServletRequest getPortletServletRequest(ServletRequest servletRequest, PortletRequest portletRequest, String pathInfo, String queryString, String requestURI, String servletPath, boolean include) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        boolean named = false;
        LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
        return new PortletServletRequest(request, (PortletRequest)liferayPortletRequest, pathInfo, queryString, requestURI, servletPath, named, include);
    }

    protected HttpServletResponse getPortletServletResponse(ServletResponse servletResponse, PortletRequest portletRequest, PortletResponse portletResponse, boolean include) throws IOException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        LiferayPortletResponse liferayPortletResponse = LiferayPortletUtil.getLiferayPortletResponse(portletResponse);
        PortletServletResponse httpServletResponse = new PortletServletResponse(response, (PortletResponse)liferayPortletResponse, include);
        PrintWriter printWriter = servletResponse.getWriter();
        if (printWriter != null) {
            httpServletResponse = new PipingServletResponse((HttpServletResponse)httpServletResponse, printWriter);
        }
        return httpServletResponse;
    }

    protected Set<String> getServletURLPatterns(ServletRequest servletRequest, PortletRequest portletRequest, PortletResponse portletResponse) {
        LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
        Portlet portlet = liferayPortletRequest.getPortlet();
        PortletApp portletApp = portlet.getPortletApp();
        return portletApp.getServletURLPatterns();
    }
}

