/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.poller.PollerRequestHandlerUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PollerServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(PollerServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String content = this.getContent(request);
            if (content == null) {
                PortalUtil.sendError((int)404, (Exception)new NoSuchLayoutException(), (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                response.setContentType("text/plain; charset=UTF-8");
                ServletResponseUtil.write((HttpServletResponse)response, (byte[])content.getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage());
            PortalUtil.sendError((int)500, (Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getContent(HttpServletRequest request) throws Exception {
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        if (userId == 0L) {
            return "";
        }
        String pollerRequestString = ParamUtil.getString((HttpServletRequest)request, (String)"pollerRequest");
        PollerHeader pollerHeader = PollerRequestHandlerUtil.getPollerHeader(pollerRequestString);
        if (pollerHeader == null) {
            return "";
        }
        if (userId != pollerHeader.getUserId()) {
            return "";
        }
        SynchronousPollerChannelListener synchronousPollerChannelListener = new SynchronousPollerChannelListener();
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        ChannelHubManagerUtil.getChannel((long)companyId, (long)userId, (boolean)true);
        ChannelHubManagerUtil.registerChannelListener((long)companyId, (long)userId, (ChannelListener)synchronousPollerChannelListener);
        try {
            JSONObject pollerResponseHeaderJSONObject = PollerRequestHandlerUtil.processRequest(request, pollerRequestString);
            if (pollerResponseHeaderJSONObject == null) {
                String string = "";
                return string;
            }
            String string = synchronousPollerChannelListener.getNotificationEvents(companyId, userId, pollerResponseHeaderJSONObject, PropsValues.POLLER_REQUEST_TIMEOUT);
            return string;
        }
        finally {
            ChannelHubManagerUtil.unregisterChannelListener((long)companyId, (long)userId, (ChannelListener)synchronousPollerChannelListener);
        }
    }

    private static class SynchronousPollerChannelListener
    implements ChannelListener {
        private final CountDownLatch _countDownLatch = new CountDownLatch(1);

        private SynchronousPollerChannelListener() {
        }

        public void channelListenerRemoved(long channelId) {
            this._countDownLatch.countDown();
        }

        public String getNotificationEvents(long companyId, long userId, JSONObject pollerResponseHeaderJSONObject, long timeout) throws ChannelException {
            try {
                this._countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List notificationEvents = ChannelHubManagerUtil.fetchNotificationEvents((long)companyId, (long)userId, (boolean)true);
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            jsonArray.put(pollerResponseHeaderJSONObject);
            for (NotificationEvent notificationEvent : notificationEvents) {
                jsonArray.put(notificationEvent.toJSONObject());
            }
            return jsonArray.toString();
        }

        public void notificationEventsAvailable(long channelId) {
            this._countDownLatch.countDown();
        }
    }
}

