/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.repository.capabilities.util.DLFileEntryServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFolderServiceAdapter;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class LiferayBulkOperationCapability
implements BulkOperationCapability {
    private static final Map<Class<? extends BulkOperationCapability.Field<?>>, String> _fieldNames = new HashMap<Class<? extends BulkOperationCapability.Field<?>>, String>(){
        {
            this.put(BulkOperationCapability.Field.CreateDate.class, "createDate");
        }
    };
    private final DLFileEntryServiceAdapter _dlFileEntryServiceAdapter;
    private final DLFolderServiceAdapter _dlFolderServiceAdapter;
    private final DocumentRepository _documentRepository;

    public LiferayBulkOperationCapability(DocumentRepository documentRepository, DLFileEntryServiceAdapter dlFileEntryServiceAdapter, DLFolderServiceAdapter dlFolderServiceAdapter) {
        this._documentRepository = documentRepository;
        this._dlFileEntryServiceAdapter = dlFileEntryServiceAdapter;
        this._dlFolderServiceAdapter = dlFolderServiceAdapter;
    }

    public void execute(BulkOperationCapability.Filter<?> filter, RepositoryModelOperation repositoryModelOperation) throws PortalException {
        this.executeOnAllFileEntries(filter, repositoryModelOperation);
        this.executeOnAllFolders(filter, repositoryModelOperation);
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        this.execute(null, repositoryModelOperation);
    }

    protected void executeOnAllFileEntries(BulkOperationCapability.Filter<?> filter, RepositoryModelOperation repositoryModelOperation) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryServiceAdapter.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod((ActionableDynamicQuery.AddCriteriaMethod)new RepositoryModelAddCriteriaMethod(filter));
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new FileEntryPerformActionMethod(repositoryModelOperation));
        actionableDynamicQuery.performActions();
    }

    protected void executeOnAllFolders(BulkOperationCapability.Filter<?> filter, RepositoryModelOperation repositoryModelOperation) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFolderServiceAdapter.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod((ActionableDynamicQuery.AddCriteriaMethod)new RepositoryModelAddCriteriaMethod(filter));
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new FolderPerformActionMethod(repositoryModelOperation));
        actionableDynamicQuery.performActions();
    }

    private class RepositoryModelAddCriteriaMethod
    implements ActionableDynamicQuery.AddCriteriaMethod {
        private final BulkOperationCapability.Filter<?> _filter;

        public RepositoryModelAddCriteriaMethod(BulkOperationCapability.Filter<?> filter) {
            this._filter = filter;
        }

        public void addCriteria(DynamicQuery dynamicQuery) {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"repositoryId", (Object)LiferayBulkOperationCapability.this._documentRepository.getRepositoryId()));
            if (this._filter != null) {
                this.addFilterCriteria(dynamicQuery);
            }
        }

        protected void addFilterCriteria(DynamicQuery dynamicQuery) {
            Class field = this._filter.getField();
            String fieldName = (String)_fieldNames.get(field);
            if (fieldName == null) {
                throw new UnsupportedOperationException("Unsupported field " + field.getName());
            }
            BulkOperationCapability.Operator operator = this._filter.getOperator();
            Object value = this._filter.getValue();
            if (operator == BulkOperationCapability.Operator.EQ) {
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)fieldName, (Object)value));
            } else if (operator == BulkOperationCapability.Operator.LE) {
                dynamicQuery.add(RestrictionsFactoryUtil.le((String)fieldName, (Object)value));
            } else if (operator == BulkOperationCapability.Operator.LT) {
                dynamicQuery.add(RestrictionsFactoryUtil.lt((String)fieldName, (Object)value));
            } else if (operator == BulkOperationCapability.Operator.GE) {
                dynamicQuery.add(RestrictionsFactoryUtil.ge((String)fieldName, (Object)value));
            } else if (operator == BulkOperationCapability.Operator.GT) {
                dynamicQuery.add(RestrictionsFactoryUtil.gt((String)fieldName, (Object)value));
            }
        }
    }

    private static class FolderPerformActionMethod
    implements ActionableDynamicQuery.PerformActionMethod<DLFolder> {
        private final RepositoryModelOperation _repositoryModelOperation;

        public FolderPerformActionMethod(RepositoryModelOperation repositoryModelOperation) {
            this._repositoryModelOperation = repositoryModelOperation;
        }

        public void performAction(DLFolder dlFolder) throws PortalException {
            if (dlFolder.isMountPoint()) {
                return;
            }
            LiferayFolder folder = new LiferayFolder(dlFolder);
            folder.execute(this._repositoryModelOperation);
        }
    }

    private static class FileEntryPerformActionMethod
    implements ActionableDynamicQuery.PerformActionMethod<DLFileEntry> {
        private RepositoryModelOperation _repositoryModelOperation;

        public FileEntryPerformActionMethod(RepositoryModelOperation repositoryModelOperation) {
            this._repositoryModelOperation = repositoryModelOperation;
        }

        public void performAction(DLFileEntry dlFileEntry) throws PortalException {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            fileEntry.execute(this._repositoryModelOperation);
        }
    }
}

