/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.ResourceActionsException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentType;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import com.liferay.util.JS;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.RequestUtils;

public class ResourceActionsImpl
implements ResourceActions {
    @BeanReference(type=PortletLocalService.class)
    protected PortletLocalService portletLocalService;
    @BeanReference(type=ResourceActionLocalService.class)
    protected ResourceActionLocalService resourceActionLocalService;
    @BeanReference(type=RoleLocalService.class)
    protected RoleLocalService roleLocalService;
    private static final String _ACTION_NAME_PREFIX = "action.";
    private static final String _COMPOSITE_MODEL_NAME_SEPARATOR = "-";
    private static final String _MODEL_RESOURCE_NAME_PREFIX = "model.resource.";
    private static final Log _log = LogFactoryUtil.getLog(ResourceActionsImpl.class);
    private final Map<String, ModelResourceActionsBag> _modelResourceActionsBags = new HashMap<String, ModelResourceActionsBag>();
    private final Set<String> _organizationModelResources = new HashSet<String>();
    private final Set<String> _portalModelResources = new HashSet<String>();
    private final Map<String, PortletResourceActionsBag> _portletResourceActionsBags = new HashMap<String, PortletResourceActionsBag>();
    private final ServiceTrackerList<ResourceBundleLoader> _resourceBundleLoaders;
    private final Set<String> _rootModelResources = new HashSet<String>();

    public ResourceActionsImpl() {
        this._resourceBundleLoaders = ServiceTrackerCollections.openList(ResourceBundleLoader.class);
    }

    public void afterPropertiesSet() {
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            for (String config : PropsValues.RESOURCE_ACTIONS_CONFIGS) {
                this.read((String)null, classLoader, config);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void check(Portlet portlet) {
        String portletName = portlet.getPortletId();
        this._check(portletName, this._getPortletResourceActions(portletName, portlet));
    }

    public void check(String portletName) {
        this._check(portletName, this.getPortletResourceActions(portletName));
    }

    public void checkAction(String name, String actionId) throws NoSuchResourceActionException {
        List<String> resourceActions = this.getResourceActions(name);
        if (!resourceActions.contains(actionId)) {
            throw new NoSuchResourceActionException(name.concat("#").concat(actionId));
        }
    }

    public void destroy() {
        this._resourceBundleLoaders.close();
    }

    public String getAction(HttpServletRequest request, String action) {
        String key = this.getActionNamePrefix() + action;
        String value = LanguageUtil.get((HttpServletRequest)request, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this._getResourceBundlesString(request, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getAction(Locale locale, String action) {
        String key = this.getActionNamePrefix() + action;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this._getResourceBundlesString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getActionNamePrefix() {
        return _ACTION_NAME_PREFIX;
    }

    @Deprecated
    public List<String> getActionsNames(HttpServletRequest request, List<String> actions) {
        LinkedHashSet<String> actionNames = new LinkedHashSet<String>();
        for (String action : actions) {
            actionNames.add(this.getAction(request, action));
        }
        return new ArrayList<String>(actionNames);
    }

    @Deprecated
    public List<String> getActionsNames(HttpServletRequest request, String name, long actionIds) {
        try {
            List resourceActions = this.resourceActionLocalService.getResourceActions(name);
            ArrayList<String> actions = new ArrayList<String>();
            for (ResourceAction resourceAction : resourceActions) {
                long bitwiseValue = resourceAction.getBitwiseValue();
                if ((actionIds & bitwiseValue) != bitwiseValue) continue;
                actions.add(resourceAction.getActionId());
            }
            return this.getActionsNames(request, actions);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String getCompositeModelName(String ... classNames) {
        if (ArrayUtil.isEmpty((Object[])classNames)) {
            return "";
        }
        Arrays.sort(classNames);
        StringBundler sb = new StringBundler(classNames.length * 2);
        for (String className : classNames) {
            sb.append(className);
            sb.append(this.getCompositeModelNameSeparator());
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public String getCompositeModelNameSeparator() {
        return _COMPOSITE_MODEL_NAME_SEPARATOR;
    }

    public List<String> getModelNames() {
        return ListUtil.fromMapKeys(this._modelResourceActionsBags);
    }

    public List<String> getModelPortletResources(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getPortletResources());
    }

    public String getModelResource(HttpServletRequest request, String name) {
        String key = this.getModelResourceNamePrefix() + name;
        String value = LanguageUtil.get((HttpServletRequest)request, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this._getResourceBundlesString(request, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getModelResource(Locale locale, String name) {
        String key = this.getModelResourceNamePrefix() + name;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null) {
            value = this._getResourceBundlesString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public List<String> getModelResourceActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getModelActions());
    }

    public List<String> getModelResourceGroupDefaultActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getGroupDefaultActions());
    }

    public List<String> getModelResourceGuestDefaultActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getGuestDefaultActions());
    }

    public List<String> getModelResourceGuestUnsupportedActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getGuestUnsupportedActions());
    }

    public String getModelResourceNamePrefix() {
        return _MODEL_RESOURCE_NAME_PREFIX;
    }

    public List<String> getModelResourceOwnerDefaultActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getOwnerDefaultActions());
    }

    public Double getModelResourceWeight(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        Map<String, Double> modelResourceWeights = modelResourceActionsBag.getResourceWeights();
        return modelResourceWeights.get(name);
    }

    public String[] getOrganizationModelResources() {
        return this._organizationModelResources.toArray(new String[this._organizationModelResources.size()]);
    }

    public String[] getPortalModelResources() {
        return this._portalModelResources.toArray(new String[this._portalModelResources.size()]);
    }

    public String getPortletBaseResource(String portletName) {
        List<String> modelNames = this.getPortletModelResources(portletName);
        for (String modelName : modelNames) {
            if (modelName.contains(".model.")) continue;
            return modelName;
        }
        return null;
    }

    public List<String> getPortletModelResources(String portletName) {
        PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(portletName = PortletIdCodec.decodePortletName((String)portletName));
        Set<String> resources = portletResourceActionsBag.getModelResources();
        if (resources == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(resources);
    }

    public List<String> getPortletNames() {
        return ListUtil.fromMapKeys(this._portletResourceActionsBags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPortletResourceActions(Portlet portlet) {
        LinkedHashSet<String> actions = new LinkedHashSet<String>(this.getPortletResourceActions(portlet.getPortletId()));
        ResourceActionsImpl resourceActionsImpl = this;
        synchronized (resourceActionsImpl) {
            this._checkPortletActions(portlet, actions);
        }
        return new ArrayList<String>(actions);
    }

    public List<String> getPortletResourceActions(String name) {
        name = PortletIdCodec.decodePortletName((String)name);
        Portlet portlet = this.portletLocalService.getPortletById(name);
        return this._getPortletResourceActions(name, portlet);
    }

    public List<String> getPortletResourceGroupDefaultActions(String name) {
        name = PortletIdCodec.decodePortletName((String)name);
        PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(name);
        return new ArrayList<String>(portletResourceActionsBag.getGroupDefaultActions());
    }

    public List<String> getPortletResourceGuestDefaultActions(String name) {
        name = PortletIdCodec.decodePortletName((String)name);
        PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(name);
        return new ArrayList<String>(portletResourceActionsBag.getGuestDefaultActions());
    }

    public List<String> getPortletResourceGuestUnsupportedActions(String name) {
        PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(name = PortletIdCodec.decodePortletName((String)name));
        Set<String> actions = portletResourceActionsBag.getGuestUnsupportedActions();
        if (actions.contains("CONFIGURATION") && actions.contains("PERMISSIONS")) {
            return new ArrayList<String>(actions);
        }
        actions.add("CONFIGURATION");
        actions.add("PERMISSIONS");
        return new ArrayList<String>(actions);
    }

    public List<String> getPortletResourceLayoutManagerActions(String name) {
        PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(name = PortletIdCodec.decodePortletName((String)name));
        Set<String> actions = portletResourceActionsBag.getLayoutManagerActions();
        if (actions.isEmpty()) {
            actions = new LinkedHashSet<String>();
            actions.add("CONFIGURATION");
            actions.add("PREFERENCES");
            actions.add("VIEW");
        }
        return new ArrayList<String>(actions);
    }

    public String getPortletRootModelResource(String portletName) {
        portletName = PortletIdCodec.decodePortletName((String)portletName);
        PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(portletName);
        return portletResourceActionsBag.getRootModelResource();
    }

    public List<String> getResourceActions(String name) {
        if (name.indexOf(46) != -1) {
            return this.getModelResourceActions(name);
        }
        return this.getPortletResourceActions(name);
    }

    public List<String> getResourceActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? this.getPortletResourceActions(portletResource) : this.getModelResourceActions(modelResource);
        return actions;
    }

    public List<String> getResourceGroupDefaultActions(String name) {
        if (name.contains(".")) {
            return this.getModelResourceGroupDefaultActions(name);
        }
        return this.getPortletResourceGroupDefaultActions(name);
    }

    public List<String> getResourceGuestUnsupportedActions(String portletResource, String modelResource) {
        if (Validator.isNull((String)modelResource)) {
            return this.getPortletResourceGuestUnsupportedActions(portletResource);
        }
        if (Validator.isNull((String)portletResource)) {
            return this.getModelResourceGuestUnsupportedActions(modelResource);
        }
        if (this._modelResourceActionsBags.containsKey(modelResource)) {
            return this.getModelResourceGuestUnsupportedActions(modelResource);
        }
        if (this._portletResourceActionsBags.containsKey(portletResource)) {
            return this.getPortletResourceGuestUnsupportedActions(portletResource);
        }
        return Collections.emptyList();
    }

    public List<Role> getRoles(long companyId, Group group, String modelResource, int[] roleTypes) {
        if (roleTypes == null) {
            roleTypes = this._getRoleTypes(group, modelResource);
        }
        return this.roleLocalService.getRoles(companyId, roleTypes);
    }

    public String[] getRootModelResources() {
        return this._rootModelResources.toArray(new String[this._rootModelResources.size()]);
    }

    public boolean hasModelResourceActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        Set<String> modelActions = modelResourceActionsBag.getModelActions();
        return modelActions != null && !modelActions.isEmpty();
    }

    public boolean isOrganizationModelResource(String modelResource) {
        return this._organizationModelResources.contains(modelResource);
    }

    public boolean isPortalModelResource(String modelResource) {
        return this._portalModelResources.contains(modelResource);
    }

    public boolean isRootModelResource(String modelResource) {
        return this._rootModelResources.contains(modelResource);
    }

    public void read(String servletContextName, ClassLoader classLoader, String source) throws Exception {
        this._read(servletContextName, classLoader, source, null);
    }

    public void read(String servletContextName, ClassLoader classLoader, String ... sources) throws Exception {
        for (String source : sources) {
            this.read(servletContextName, classLoader, source);
        }
    }

    @Deprecated
    public void read(String servletContextName, InputStream inputStream) throws Exception {
        Document document = UnsecureSAXReaderUtil.read((InputStream)inputStream, (boolean)true);
        this._read(servletContextName, document, null);
    }

    public void readAndCheck(String servletContextName, ClassLoader classLoader, String ... sources) throws Exception {
        HashSet<String> portletNames = new HashSet<String>();
        for (String source : sources) {
            this._read(servletContextName, classLoader, source, portletNames);
        }
        for (String portletName : portletNames) {
            this.check(portletName);
        }
    }

    public void removePortletResource(String portletName) {
        PortletResourceActionsBag portletResourceActionsBag = this._portletResourceActionsBags.remove(portletName);
        if (portletResourceActionsBag != null) {
            Set<String> modelResources = portletResourceActionsBag.getModelResources();
            for (String modelResource : modelResources) {
                ModelResourceActionsBag modelResourceActionsBag = this._modelResourceActionsBags.get(modelResource);
                Set<String> portletResources = modelResourceActionsBag.getPortletResources();
                portletResources.remove(portletName);
                if (!portletResources.isEmpty()) continue;
                this._modelResourceActionsBags.remove(modelResource);
            }
        }
    }

    private void _check(String portletName, List<String> portletResourceActions) {
        ResourceActionLocalServiceUtil.checkResourceActions((String)portletName, portletResourceActions);
        for (String modelName : this.getPortletModelResources(portletName)) {
            ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, this.getModelResourceActions(modelName));
        }
    }

    private void _checkGuestUnsupportedActions(Set<String> guestUnsupportedActions, Set<String> guestDefaultActions) {
        Iterator<String> itr = guestDefaultActions.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (!guestUnsupportedActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    private void _checkModelActions(Set<String> actions) {
        if (!actions.contains("PERMISSIONS")) {
            actions.add("PERMISSIONS");
        }
    }

    private void _checkPortletActions(Portlet portlet, Set<String> actions) {
        this._checkPortletLayoutManagerActions(actions);
        if (portlet != null && portlet.getControlPanelEntryCategory() != null && !actions.contains("ACCESS_IN_CONTROL_PANEL")) {
            actions.add("ACCESS_IN_CONTROL_PANEL");
        }
    }

    private void _checkPortletActions(String name, Set<String> actions) {
        Portlet portlet = this.portletLocalService.getPortletById(name);
        this._checkPortletActions(portlet, actions);
    }

    private void _checkPortletGroupDefaultActions(Set<String> actions) {
        if (actions.isEmpty()) {
            actions.add("VIEW");
        }
    }

    private void _checkPortletGuestDefaultActions(Set<String> actions) {
        if (actions.isEmpty()) {
            actions.add("VIEW");
        }
    }

    private void _checkPortletLayoutManagerActions(Set<String> actions) {
        if (!actions.contains("ACCESS_IN_CONTROL_PANEL") && !actions.contains("ADD_TO_PAGE")) {
            actions.add("ADD_TO_PAGE");
        }
        if (!actions.contains("CONFIGURATION")) {
            actions.add("CONFIGURATION");
        }
        if (!actions.contains("PERMISSIONS")) {
            actions.add("PERMISSIONS");
        }
        if (!actions.contains("PREFERENCES")) {
            actions.add("PREFERENCES");
        }
        if (!actions.contains("VIEW")) {
            actions.add("VIEW");
        }
    }

    private String _getCompositeModelName(Element compositeModelNameElement) {
        StringBundler sb = new StringBundler();
        ArrayList elements = new ArrayList(compositeModelNameElement.elements("model-name"));
        Collections.sort(elements, new Comparator<Element>(){

            @Override
            public int compare(Element element1, Element element2) {
                String textTrim1 = GetterUtil.getString((String)element1.getTextTrim());
                String textTrim2 = GetterUtil.getString((String)element2.getTextTrim());
                return textTrim1.compareTo(textTrim2);
            }
        });
        Iterator itr = elements.iterator();
        while (itr.hasNext()) {
            Element modelNameElement = (Element)itr.next();
            sb.append(modelNameElement.getTextTrim());
            if (!itr.hasNext()) continue;
            sb.append(_COMPOSITE_MODEL_NAME_SEPARATOR);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelResourceActionsBag _getModelResourceActionsBag(String modelName) {
        ModelResourceActionsBag modelResourceActionsBag = this._modelResourceActionsBags.get(modelName);
        if (modelResourceActionsBag != null) {
            return modelResourceActionsBag;
        }
        Map<String, ModelResourceActionsBag> map = this._modelResourceActionsBags;
        synchronized (map) {
            modelResourceActionsBag = this._modelResourceActionsBags.get(modelName);
            if (modelResourceActionsBag != null) {
                return modelResourceActionsBag;
            }
            modelResourceActionsBag = new ModelResourceActionsBag();
            this._modelResourceActionsBags.put(modelName, modelResourceActionsBag);
        }
        return modelResourceActionsBag;
    }

    private Element _getPermissionsChildElement(Element parentElement, String childElementName) {
        Element permissionsElement = parentElement.element("permissions");
        if (permissionsElement != null) {
            return permissionsElement.element(childElementName);
        }
        return parentElement.element(childElementName);
    }

    private Set<String> _getPortletMimeTypeActions(String name, Portlet portlet) {
        LinkedHashSet<String> actions = new LinkedHashSet<String>();
        if (portlet != null) {
            Map portletModes = portlet.getPortletModes();
            Set mimeTypePortletModes = (Set)portletModes.get("text/html");
            if (mimeTypePortletModes != null) {
                for (String actionId : mimeTypePortletModes) {
                    if (StringUtil.equalsIgnoreCase((String)actionId, (String)"edit")) {
                        actions.add("PREFERENCES");
                        continue;
                    }
                    if (StringUtil.equalsIgnoreCase((String)actionId, (String)"edit_guest")) {
                        actions.add("GUEST_PREFERENCES");
                        continue;
                    }
                    actions.add(StringUtil.toUpperCase((String)actionId));
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unable to obtain resource actions for unknown portlet " + name));
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _getPortletResourceActions(String name, Portlet portlet) {
        PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(name);
        Set<String> portletActions = portletResourceActionsBag.getPortletActions();
        if (!portletActions.isEmpty()) {
            return new ArrayList<String>(portletActions);
        }
        ResourceActionsImpl resourceActionsImpl = this;
        synchronized (resourceActionsImpl) {
            portletActions = this._getPortletMimeTypeActions(name, portlet);
            if (!name.equals("90")) {
                this._checkPortletActions(portlet, portletActions);
            }
            Set<String> groupDefaultActions = portletResourceActionsBag.getGroupDefaultActions();
            this._checkPortletGroupDefaultActions(groupDefaultActions);
            Set<String> guestDefaultActions = portletResourceActionsBag.getGuestDefaultActions();
            this._checkPortletGuestDefaultActions(guestDefaultActions);
            Set<String> layoutManagerActions = portletResourceActionsBag.getLayoutManagerActions();
            this._checkPortletLayoutManagerActions(layoutManagerActions);
        }
        return new ArrayList<String>(portletActions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortletResourceActionsBag _getPortletResourceActionsBag(String portletName) {
        PortletResourceActionsBag portletResourceActionsBag = this._portletResourceActionsBags.get(portletName);
        if (portletResourceActionsBag != null) {
            return portletResourceActionsBag;
        }
        Map<String, PortletResourceActionsBag> map = this._portletResourceActionsBags;
        synchronized (map) {
            portletResourceActionsBag = this._portletResourceActionsBags.get(portletName);
            if (portletResourceActionsBag != null) {
                return portletResourceActionsBag;
            }
            portletResourceActionsBag = new PortletResourceActionsBag();
            this._portletResourceActionsBags.put(portletName, portletResourceActionsBag);
        }
        return portletResourceActionsBag;
    }

    private String _getResourceBundlesString(HttpServletRequest request, String key) {
        Locale locale = RequestUtils.getUserLocale((HttpServletRequest)request, null);
        return this._getResourceBundlesString(locale, key);
    }

    private String _getResourceBundlesString(Locale locale, String key) {
        if (locale == null || key == null) {
            return null;
        }
        for (ResourceBundleLoader resourceBundleLoader : this._resourceBundleLoaders) {
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
            if (resourceBundle == null || !resourceBundle.containsKey(key)) continue;
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
        }
        return null;
    }

    private int[] _getRoleTypes(Group group, String modelResource) {
        int[] types = RoleConstants.TYPES_REGULAR_AND_SITE;
        if (this.isPortalModelResource(modelResource)) {
            types = modelResource.equals(Organization.class.getName()) || modelResource.equals(User.class.getName()) ? RoleConstants.TYPES_ORGANIZATION_AND_REGULAR : RoleConstants.TYPES_REGULAR;
        } else if (group != null) {
            if (group.isLayout()) {
                try {
                    group = GroupServiceUtil.getGroup((long)group.getParentGroupId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (group.isOrganization()) {
                types = RoleConstants.TYPES_ORGANIZATION_AND_REGULAR_AND_SITE;
            } else if (group.isCompany() || group.isUser() || group.isUserGroup()) {
                types = RoleConstants.TYPES_REGULAR;
            }
        }
        return types;
    }

    private void _read(String servletContextName, ClassLoader classLoader, String source, Set<String> portletNames) throws Exception {
        Document document;
        DocumentType documentType;
        String publicId;
        InputStream inputStream = classLoader.getResourceAsStream(source);
        if (inputStream == null) {
            if (_log.isInfoEnabled() && !source.endsWith("-ext.xml") && !source.startsWith("META-INF/")) {
                _log.info((Object)("Cannot load " + source));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        if ((publicId = GetterUtil.getString((String)(documentType = (document = UnsecureSAXReaderUtil.read((InputStream)inputStream, (boolean)true)).getDocumentType()).getPublicId())).equals("-//Liferay//DTD Resource Action Mapping 6.0.0//EN") && _log.isWarnEnabled()) {
            _log.warn((Object)("Please update " + source + " to use the 6.1.0 format"));
        }
        Element rootElement = document.getRootElement();
        for (Element resourceElement : rootElement.elements("resource")) {
            String file = StringUtil.trim((String)resourceElement.attributeValue("file"));
            this._read(servletContextName, classLoader, file, portletNames);
            String extFileName = StringUtil.replace((String)file, (String)".xml", (String)"-ext.xml");
            this._read(servletContextName, classLoader, extFileName, portletNames);
        }
        this._read(servletContextName, document, portletNames);
        if (source.endsWith(".xml") && !source.endsWith("-ext.xml")) {
            String extFileName = StringUtil.replace((String)source, (String)".xml", (String)"-ext.xml");
            this._read(servletContextName, classLoader, extFileName, portletNames);
        }
    }

    private void _read(String servletContextName, Document document, Set<String> portletNames) throws Exception {
        Element rootElement = document.getRootElement();
        if (PropsValues.RESOURCE_ACTIONS_READ_PORTLET_RESOURCES) {
            for (Element portletResourceElement : rootElement.elements("portlet-resource")) {
                String portletName = this._readPortletResource(servletContextName, portletResourceElement);
                if (portletNames == null) continue;
                portletNames.add(portletName);
            }
        }
        for (Element modelResourceElement : rootElement.elements("model-resource")) {
            String modelName = this._readModelResource(servletContextName, modelResourceElement);
            if (portletNames == null) continue;
            ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(modelName);
            portletNames.addAll(modelResourceActionsBag.getPortletResources());
        }
    }

    private List<String> _readActionKeys(Element parentElement) {
        ArrayList<String> actions = new ArrayList<String>();
        for (Element actionKeyElement : parentElement.elements("action-key")) {
            String actionKey = actionKeyElement.getTextTrim();
            if (Validator.isNull((String)actionKey)) continue;
            actions.add(actionKey);
        }
        return actions;
    }

    private void _readGroupDefaultActions(Element parentElement, Set<String> groupDefaultActions) {
        Element groupDefaultsElement = this._getPermissionsChildElement(parentElement, "site-member-defaults");
        if (groupDefaultsElement == null) {
            groupDefaultsElement = this._getPermissionsChildElement(parentElement, "community-defaults");
            if (_log.isWarnEnabled() && groupDefaultsElement != null) {
                _log.warn((Object)"The community-defaults element is deprecated. Use the site-member-defaults element instead.");
            }
        }
        if (groupDefaultsElement == null) {
            return;
        }
        groupDefaultActions.clear();
        groupDefaultActions.addAll(this._readActionKeys(groupDefaultsElement));
    }

    private void _readGuestDefaultActions(Element parentElement, Set<String> guestDefaultActions) {
        Element guestDefaultsElement = this._getPermissionsChildElement(parentElement, "guest-defaults");
        if (guestDefaultsElement == null) {
            return;
        }
        guestDefaultActions.clear();
        guestDefaultActions.addAll(this._readActionKeys(guestDefaultsElement));
    }

    private void _readGuestUnsupportedActions(Element parentElement, Set<String> guestUnsupportedActions, Set<String> guestDefaultActions) {
        Element guestUnsupportedElement = this._getPermissionsChildElement(parentElement, "guest-unsupported");
        if (guestUnsupportedElement == null) {
            return;
        }
        guestUnsupportedActions.clear();
        guestUnsupportedActions.addAll(this._readActionKeys(guestUnsupportedElement));
        this._checkGuestUnsupportedActions(guestUnsupportedActions, guestDefaultActions);
    }

    private void _readLayoutManagerActions(Element parentElement, Set<String> layoutManagerActions, Set<String> supportsActions) {
        Element layoutManagerElement = this._getPermissionsChildElement(parentElement, "layout-manager");
        if (layoutManagerElement == null) {
            layoutManagerActions.addAll(supportsActions);
            return;
        }
        layoutManagerActions.clear();
        layoutManagerActions.addAll(this._readActionKeys(layoutManagerElement));
    }

    private String _readModelResource(String servletContextName, Element modelResourceElement) throws Exception {
        String name = modelResourceElement.elementTextTrim("model-name");
        if (Validator.isNull((String)name)) {
            name = this._getCompositeModelName(modelResourceElement.element("composite-model-name"));
        }
        if (GetterUtil.getBoolean((String)modelResourceElement.attributeValue("organization"))) {
            this._organizationModelResources.add(name);
        }
        if (GetterUtil.getBoolean((String)modelResourceElement.attributeValue("portal"))) {
            this._portalModelResources.add(name);
        }
        ModelResourceActionsBag modelResourceActionsBag = this._getModelResourceActionsBag(name);
        Element portletRefElement = modelResourceElement.element("portlet-ref");
        for (Element portletNameElement : portletRefElement.elements("portlet-name")) {
            String portletName = portletNameElement.getTextTrim();
            if (servletContextName != null) {
                portletName = portletName.concat("_WAR_").concat(servletContextName);
            }
            portletName = JS.getSafeName((String)portletName);
            PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(portletName);
            Set<String> modelResources = portletResourceActionsBag.getModelResources();
            modelResources.add(name);
            Set<String> portletResources = modelResourceActionsBag.getPortletResources();
            portletResources.add(portletName);
            boolean root = GetterUtil.getBoolean((String)modelResourceElement.elementText("root"));
            if (!root) continue;
            this._rootModelResources.add(name);
            portletResourceActionsBag.setPortletRootModelResource(name);
        }
        double weight = GetterUtil.getDouble((String)modelResourceElement.elementTextTrim("weight"), (double)100.0);
        Map<String, Double> modelResourceWeights = modelResourceActionsBag.getResourceWeights();
        modelResourceWeights.put(name, weight);
        Set<String> modelResourceActions = modelResourceActionsBag.getModelActions();
        this._readSupportsActions(modelResourceElement, modelResourceActions);
        this._checkModelActions(modelResourceActions);
        if (modelResourceActions.size() > 64) {
            throw new ResourceActionsException("There are more than 64 actions for resource " + name);
        }
        Set<String> groupDefaultActions = modelResourceActionsBag.getGroupDefaultActions();
        this._readGroupDefaultActions(modelResourceElement, groupDefaultActions);
        Set<String> guestDefaultActions = modelResourceActionsBag.getGuestDefaultActions();
        this._readGuestDefaultActions(modelResourceElement, guestDefaultActions);
        Set<String> guestUnsupportedActions = modelResourceActionsBag.getGuestUnsupportedActions();
        this._readGuestUnsupportedActions(modelResourceElement, guestUnsupportedActions, guestDefaultActions);
        Set<String> ownerDefaultActions = modelResourceActionsBag.getOwnerDefaultActions();
        this._readOwnerDefaultActions(modelResourceElement, ownerDefaultActions);
        return name;
    }

    private void _readOwnerDefaultActions(Element parentElement, Set<String> ownerDefaultActions) {
        Element ownerDefaultsElement = this._getPermissionsChildElement(parentElement, "owner-defaults");
        if (ownerDefaultsElement == null) {
            return;
        }
        ownerDefaultActions.addAll(this._readActionKeys(ownerDefaultsElement));
    }

    private String _readPortletResource(String servletContextName, Element portletResourceElement) throws Exception {
        String name = portletResourceElement.elementTextTrim("portlet-name");
        if (servletContextName != null) {
            name = name.concat("_WAR_").concat(servletContextName);
        }
        name = JS.getSafeName((String)name);
        PortletResourceActionsBag portletResourceActionsBag = this._getPortletResourceActionsBag(name);
        Set<String> portletActions = portletResourceActionsBag.getPortletActions();
        this._readSupportsActions(portletResourceElement, portletActions);
        Portlet portlet = this.portletLocalService.getPortletById(name);
        portletActions.addAll(this._getPortletMimeTypeActions(name, portlet));
        if (!name.equals("90")) {
            this._checkPortletActions(name, portletActions);
        }
        if (portletActions.size() > 64) {
            throw new ResourceActionsException("There are more than 64 actions for resource " + name);
        }
        Set<String> groupDefaultActions = portletResourceActionsBag.getGroupDefaultActions();
        this._readGroupDefaultActions(portletResourceElement, groupDefaultActions);
        Set<String> guestDefaultActions = portletResourceActionsBag.getGuestDefaultActions();
        this._readGuestDefaultActions(portletResourceElement, guestDefaultActions);
        Set<String> guestUnsupportedActions = portletResourceActionsBag.getGuestUnsupportedActions();
        this._readGuestUnsupportedActions(portletResourceElement, guestUnsupportedActions, guestDefaultActions);
        Set<String> layoutManagerActions = portletResourceActionsBag.getLayoutManagerActions();
        this._readLayoutManagerActions(portletResourceElement, layoutManagerActions, portletActions);
        return name;
    }

    private Set<String> _readSupportsActions(Element parentElement, Set<String> supportsActions) {
        Element supportsElement = this._getPermissionsChildElement(parentElement, "supports");
        supportsActions.addAll(this._readActionKeys(supportsElement));
        return supportsActions;
    }

    private static class PortletResourceActionsBag {
        private final Set<String> _groupDefaultActions = new HashSet<String>();
        private final Set<String> _guestDefaultActions = new HashSet<String>();
        private final Set<String> _guestUnsupportedActions = new HashSet<String>();
        private final Set<String> _layoutManagerActions = new HashSet<String>();
        private final Set<String> _modelResources = new HashSet<String>();
        private final Set<String> _portletResourceActions = new HashSet<String>();
        private String _portletRootModelResource;

        private PortletResourceActionsBag() {
        }

        public Set<String> getGroupDefaultActions() {
            return this._groupDefaultActions;
        }

        public Set<String> getGuestDefaultActions() {
            return this._guestDefaultActions;
        }

        public Set<String> getGuestUnsupportedActions() {
            return this._guestUnsupportedActions;
        }

        public Set<String> getLayoutManagerActions() {
            return this._layoutManagerActions;
        }

        public Set<String> getModelResources() {
            return this._modelResources;
        }

        public Set<String> getPortletActions() {
            return this._portletResourceActions;
        }

        public String getRootModelResource() {
            return this._portletRootModelResource;
        }

        public void setPortletRootModelResource(String portletRootModelResource) {
            this._portletRootModelResource = portletRootModelResource;
        }
    }

    private static class ModelResourceActionsBag {
        private final Set<String> _groupDefaultActions = new HashSet<String>();
        private final Set<String> _guestDefaultActions = new HashSet<String>();
        private final Set<String> _guestUnsupportedActions = new HashSet<String>();
        private final Set<String> _modelActions = new HashSet<String>();
        private final Set<String> _ownerDefaultActions = new HashSet<String>();
        private final Set<String> _portletResources = new HashSet<String>();
        private final Map<String, Double> _resourceWeights = new HashMap<String, Double>();

        private ModelResourceActionsBag() {
        }

        public Set<String> getGroupDefaultActions() {
            return this._groupDefaultActions;
        }

        public Set<String> getGuestDefaultActions() {
            return this._guestDefaultActions;
        }

        public Set<String> getGuestUnsupportedActions() {
            return this._guestUnsupportedActions;
        }

        public Set<String> getModelActions() {
            return this._modelActions;
        }

        public Set<String> getOwnerDefaultActions() {
            return this._ownerDefaultActions;
        }

        public Set<String> getPortletResources() {
            return this._portletResources;
        }

        public Map<String, Double> getResourceWeights() {
            return this._resourceWeights;
        }
    }
}

