/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.xml;

import com.liferay.portal.security.xml.StripDoctypeFilter;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class StripDoctypeXMLReader
implements XMLReader {
    private static final String _FEATURES_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private boolean _disallowDoctypeDecl;
    private final XMLReader _xmlReader;

    public StripDoctypeXMLReader(XMLReader xmlReader) {
        this._xmlReader = xmlReader;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this._xmlReader.getContentHandler();
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this._xmlReader.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this._xmlReader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._xmlReader.getErrorHandler();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._xmlReader.getFeature(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._xmlReader.getProperty(name);
    }

    public XMLReader getXmlReader() {
        return this._xmlReader;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this._disallowDoctypeDecl) {
            Reader reader;
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                final StripDoctypeFilter stripDoctypeFilter = new StripDoctypeFilter(inputStream);
                inputSource.setByteStream(new FilterInputStream(inputStream){

                    @Override
                    public int read() throws IOException {
                        return stripDoctypeFilter.read();
                    }

                    @Override
                    public int read(byte[] bytes, int offset, int length) throws IOException {
                        return stripDoctypeFilter.read(bytes, offset, length);
                    }
                });
            }
            if ((reader = inputSource.getCharacterStream()) != null) {
                final StripDoctypeFilter stripDoctypeFilter = new StripDoctypeFilter(reader);
                inputSource.setCharacterStream(new FilterReader(reader){

                    @Override
                    public int read() throws IOException {
                        return stripDoctypeFilter.read();
                    }

                    @Override
                    public int read(char[] chars, int offset, int length) throws IOException {
                        return stripDoctypeFilter.read(chars, offset, length);
                    }
                });
            }
        }
        this._xmlReader.parse(inputSource);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this._xmlReader.parse(systemId);
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this._xmlReader.setContentHandler(contentHandler);
    }

    @Override
    public void setDTDHandler(DTDHandler dtdHandler) {
        this._xmlReader.setDTDHandler(dtdHandler);
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this._xmlReader.setEntityResolver(entityResolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this._xmlReader.setErrorHandler(errorHandler);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (_FEATURES_DISALLOW_DOCTYPE_DECL.equals(name)) {
            this._disallowDoctypeDecl = value;
        }
        this._xmlReader.setFeature(name, value);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._xmlReader.setProperty(name, value);
    }
}

