/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermission;
import com.liferay.portal.kernel.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portal.kernel.model.Layout"})
public class LayoutPermissionImpl
implements BaseModelPermissionChecker,
LayoutPermission {
    public void check(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layout, checkViewableGroup, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layout.getLayoutId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layout, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layout.getLayoutId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, groupId, privateLayout, layoutId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layoutId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long plid, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        this.check(permissionChecker, layout, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, primaryKey, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        CacheKey cacheKey;
        Map permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(cacheKey = new CacheKey(layout.getPlid(), layout.getMvccVersion(), checkViewableGroup, actionId));
        if (contains == null) {
            contains = this._contains(permissionChecker, layout, checkViewableGroup, actionId);
            permissionChecksMap.put(cacheKey, contains);
        }
        return contains;
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        return this.contains(permissionChecker, layout, false, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        return this.contains(permissionChecker, layout, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        return this.contains(permissionChecker, layout, actionId);
    }

    public boolean containsWithoutViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkLayoutUpdateable, String actionId) throws PortalException {
        if (layout.isTypeControlPanel()) {
            return false;
        }
        if (checkLayoutUpdateable && !actionId.equals("CUSTOMIZE") && !actionId.equals("VIEW") && layout instanceof VirtualLayout) {
            return false;
        }
        if (actionId.equals("CUSTOMIZE") && layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getWrappedModel();
        }
        if (actionId.equals("ADD_LAYOUT")) {
            if (!SitesUtil.isLayoutSortable((Layout)layout)) {
                return false;
            }
            LayoutType layoutType = layout.getLayoutType();
            if (!layoutType.isParentable()) {
                return false;
            }
        }
        if (actionId.equals("DELETE") && !SitesUtil.isLayoutDeleteable((Layout)layout)) {
            return false;
        }
        Group group = layout.getGroup();
        if (checkLayoutUpdateable && !group.isLayoutSetPrototype() && this.isAttemptToModifyLockedLayout(layout, actionId)) {
            return false;
        }
        if (actionId.equals("ADD_LAYOUT") && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ADD_LAYOUT")) {
            return true;
        }
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && !actionId.equals("VIEW")) {
            long layoutGroupId = layout.getGroupId();
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                layoutGroupId = virtualLayout.getSourceGroupId();
            }
            long parentLayoutId = layout.getParentLayoutId();
            while (parentLayoutId != 0L) {
                Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)layoutGroupId, (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
                if (this.contains(permissionChecker, parentLayout, actionId)) {
                    return true;
                }
                parentLayoutId = parentLayout.getParentLayoutId();
            }
        }
        if (permissionChecker.hasPermission(group, Layout.class.getName(), layout.getPlid(), actionId)) {
            return true;
        }
        if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"MANAGE_LAYOUTS")) {
            return true;
        }
        User user = permissionChecker.getUser();
        if (!user.isDefaultUser() && !group.isUser()) {
            ResourcePermission resourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)layout.getCompanyId(), (String)Layout.class.getName(), (int)4, (String)String.valueOf(layout.getPlid()), (long)permissionChecker.getOwnerRoleId());
            if (permissionChecker.hasOwnerPermission(layout.getCompanyId(), Layout.class.getName(), String.valueOf(layout.getPlid()), resourcePermission.getOwnerId(), actionId)) {
                return true;
            }
        }
        return false;
    }

    public boolean containsWithoutViewableGroup(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        return this.containsWithoutViewableGroup(permissionChecker, layout, true, actionId);
    }

    protected boolean containsWithViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        if (actionId.equals("VIEW") && checkViewableGroup) {
            return this.isViewableGroup(permissionChecker, layout, checkViewableGroup);
        }
        return this.containsWithoutViewableGroup(permissionChecker, layout, actionId);
    }

    protected boolean isAttemptToModifyLockedLayout(Layout layout, String actionId) {
        return ("CUSTOMIZE".equals(actionId) || "UPDATE".equals(actionId)) && !SitesUtil.isLayoutUpdateable((Layout)layout);
    }

    protected boolean isViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkResourcePermission) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)layout.getGroupId());
        if (group.isControlPanel() && layout.isTypeControlPanel()) {
            return permissionChecker.isSignedIn();
        }
        if (!GroupLocalServiceUtil.isLiveGroupActive((Group)group)) {
            return false;
        }
        if (group.isUser()) {
            long groupUserId = group.getClassPK();
            if (groupUserId == permissionChecker.getUserId()) {
                return true;
            }
            User groupUser = UserLocalServiceUtil.getUserById((long)groupUserId);
            if (!groupUser.isActive()) {
                return false;
            }
            if (layout.isPrivateLayout()) {
                return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"MANAGE_LAYOUTS") || UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupUserId, (long[])groupUser.getOrganizationIds(), (String)"UPDATE");
            }
        }
        if (group.isStagingGroup()) {
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW_STAGING");
        }
        if (group.isSite()) {
            if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"MANAGE_LAYOUTS") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"UPDATE")) {
                return true;
            }
            if (layout.isPrivateLayout() && !permissionChecker.isGroupMember(group.getGroupId())) {
                return false;
            }
        }
        if (group.isCompany()) {
            return false;
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"VIEW");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"VIEW");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            if (OrganizationLocalServiceUtil.hasUserOrganization((long)permissionChecker.getUserId(), (long)organizationId, (boolean)false, (boolean)false)) {
                return true;
            }
            if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"UPDATE")) {
                return true;
            }
            if (!PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) {
                List userOrgs = OrganizationLocalServiceUtil.getUserOrganizations((long)permissionChecker.getUserId());
                for (Organization organization : userOrgs) {
                    for (Organization ancestorOrganization : organization.getAncestors()) {
                        if (organizationId != ancestorOrganization.getOrganizationId()) continue;
                        return true;
                    }
                }
            }
        } else if (group.isUserGroup() && UserGroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE")) {
            return true;
        }
        if (this.containsWithoutViewableGroup(permissionChecker, layout, "VIEW")) {
            return true;
        }
        List layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
        for (Layout curLayout : layouts) {
            if (!this.containsWithoutViewableGroup(permissionChecker, curLayout, "VIEW") || curLayout.isHidden()) continue;
            return true;
        }
        return false;
    }

    private boolean _contains(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        LayoutTypeController layoutTypeController;
        if (actionId.equals("VIEW") && !(layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType())).isCheckLayoutViewPermission()) {
            return true;
        }
        if (actionId.equals("CUSTOMIZE") && layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getWrappedModel();
        }
        if (this.isAttemptToModifyLockedLayout(layout, actionId)) {
            return false;
        }
        Group group = layout.getGroup();
        if (group.hasLocalOrRemoteStagingGroup()) {
            Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (Group)group, (String)Layout.class.getName(), (long)layout.getGroupId(), null, (String)actionId);
            if (hasPermission != null) {
                return hasPermission;
            }
        } else if (!checkViewableGroup && group.isUserGroup() && actionId.equals("VIEW")) {
            if (permissionChecker.isGroupAdmin(group.getGroupId())) {
                return true;
            }
            try {
                UserBag userBag = permissionChecker.getUserBag();
                if (userBag == null) {
                    return UserGroupLocalServiceUtil.hasUserUserGroup((long)permissionChecker.getUserId(), (long)group.getClassPK());
                }
                return Arrays.binarySearch(userBag.getUserUserGroupsIds(), group.getClassPK()) >= 0;
            }
            catch (PortalException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PortalException((Throwable)e);
            }
        }
        return this.containsWithViewableGroup(permissionChecker, layout, checkViewableGroup, actionId);
    }

    private static class CacheKey {
        private final String _actionId;
        private final boolean _checkViewableGroup;
        private final long _mvccVersion;
        private final long _plid;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)obj;
            return this._plid == cacheKey._plid && this._mvccVersion == cacheKey._mvccVersion && this._checkViewableGroup == cacheKey._checkViewableGroup && Objects.equals(this._actionId, cacheKey._actionId);
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (long)this._plid);
            hash = HashUtil.hash((int)hash, (long)this._mvccVersion);
            hash = HashUtil.hash((int)hash, (boolean)this._checkViewableGroup);
            return HashUtil.hash((int)hash, (Object)this._actionId);
        }

        private CacheKey(long plid, long mvccVersion, boolean checkViewableGroup, String actionId) {
            this._plid = plid;
            this._mvccVersion = mvccVersion;
            this._checkViewableGroup = checkViewableGroup;
            this._actionId = actionId;
        }
    }
}

