/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.minifier.MinifierThreadLocal;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ResourceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.minifier.MinifierUtil;
import com.liferay.portal.servlet.filters.IgnoreModuleRequestFilter;
import com.liferay.portal.servlet.filters.aggregate.ServletPaths;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.servlet.filters.util.CacheFileNameGenerator;
import com.liferay.portal.util.AggregateUtil;
import com.liferay.portal.util.JavaScriptBundleUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AggregateFilter
extends IgnoreModuleRequestFilter {
    private static final String _BASE_URL = "@base_url@";
    private static final String _CSS_COMMENT_BEGIN = "/*";
    private static final String _CSS_COMMENT_END = "*/";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final String _CSS_MEDIA_QUERY = "@media";
    private static final String _JAVASCRIPT_EXTENSION = ".js";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = "aggregate";
    private static final Log _log = LogFactoryUtil.getLog(AggregateFilter.class);
    private static final Pattern _pattern = Pattern.compile("^(\\.ie|\\.js\\.ie)([^}]*)}", 8);
    private static volatile PortalExecutorManager _portalExecutorManager = (PortalExecutorManager)ServiceProxyFactory.newServiceTrackedInstance(PortalExecutorManager.class, AggregateFilter.class, (String)"_portalExecutorManager", (boolean)true);
    private final Map<String, NoticeableFuture<String>> _noticeableFutures = new ConcurrentHashMap<String, NoticeableFuture<String>>();
    private ServletContext _servletContext;
    private File _tempDir;

    public static String aggregateCss(ServletPaths servletPaths, String content) throws IOException {
        StringBundler sb = new StringBundler();
        int pos = 0;
        while (true) {
            int commentX = content.indexOf(_CSS_COMMENT_BEGIN, pos);
            int commentY = content.indexOf(_CSS_COMMENT_END, commentX + _CSS_COMMENT_BEGIN.length());
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            if (commentX != -1 && commentY != -1 && commentX < importX && commentY > importX) {
                sb.append(content.substring(pos, commentY += _CSS_COMMENT_END.length()));
                pos = commentY;
                continue;
            }
            sb.append(content.substring(pos, importX));
            String mediaQuery = "";
            int mediaQueryImportX = content.indexOf(41, importX + _CSS_IMPORT_BEGIN.length());
            int mediaQueryImportY = content.indexOf(59, importX + _CSS_IMPORT_BEGIN.length());
            String importFileName = null;
            if (importY != mediaQueryImportX) {
                mediaQuery = content.substring(mediaQueryImportX + 1, mediaQueryImportY);
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), mediaQueryImportX);
            } else {
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            }
            String importContent = null;
            if (Validator.isUrl((String)importFileName)) {
                ServletPaths downServletPaths = servletPaths.down(importFileName);
                importContent = downServletPaths.getContent();
            } else {
                ServletPaths importFileServletPaths;
                int queryPos = importFileName.indexOf(63);
                if (queryPos != -1) {
                    importFileName = importFileName.substring(0, queryPos);
                }
                if ((importContent = (importFileServletPaths = servletPaths.down(importFileName)).getContent()) == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("File " + importFileServletPaths.getResourcePath() + " does not exist"));
                    }
                    importContent = "";
                }
                String importDirName = "";
                int slashPos = importFileName.lastIndexOf(47);
                if (slashPos != -1) {
                    importDirName = importFileName.substring(0, slashPos + 1);
                }
                ServletPaths importDirServletPaths = servletPaths.down(importDirName);
                importContent = AggregateFilter.aggregateCss(importDirServletPaths, importContent);
                String baseURL = _BASE_URL.concat(importDirServletPaths.getResourcePath());
                if (!baseURL.endsWith("/")) {
                    baseURL = baseURL + "/";
                }
                importContent = AggregateUtil.updateRelativeURLs(importContent, baseURL);
            }
            if (Validator.isNotNull((String)mediaQuery)) {
                sb.append(_CSS_MEDIA_QUERY);
                sb.append(' ');
                sb.append(mediaQuery);
                sb.append('{');
                sb.append(importContent);
                sb.append('}');
                pos = mediaQueryImportY + 1;
                continue;
            }
            sb.append(importContent);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        return sb.toString();
    }

    public static String aggregateJavaScript(ServletPaths servletPaths, String[] fileNames) {
        StringBundler sb = new StringBundler(fileNames.length * 2);
        for (String fileName : fileNames) {
            ServletPaths fileServletPaths = servletPaths.down(fileName);
            String content = fileServletPaths.getContent();
            if (Validator.isNull((String)content)) continue;
            sb.append(content);
            sb.append("\n");
        }
        return AggregateFilter.getJavaScriptContent(StringUtil.merge((Object[])fileNames, (String)"+"), sb.toString());
    }

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        this._tempDir = new File(tempDir, _TEMP_DIR);
        this._tempDir.mkdirs();
    }

    protected static String getJavaScriptContent(String resourceName, String content) {
        return MinifierUtil.minifyJavaScript(resourceName, content);
    }

    protected Object getBundleContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String bundleId = ParamUtil.getString((HttpServletRequest)request, (String)"bundleId", (String)ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId"));
        if (Validator.isNull((String)minifierType) || Validator.isNull((String)bundleId) || !ArrayUtil.contains((Object[])PropsValues.JAVASCRIPT_BUNDLE_IDS, (Object)bundleId)) {
            return null;
        }
        String bundleDirName = PropsUtil.get("javascript.bundle.dir", new Filter(bundleId));
        ServletContext jsServletContext = PortalWebResourcesUtil.getServletContext((String)"js");
        URL bundleDirURL = jsServletContext.getResource(bundleDirName);
        if (bundleDirURL == null) {
            return null;
        }
        String cacheFileName = bundleId;
        String[] fileNames = JavaScriptBundleUtil.getFileNames(bundleId);
        File cacheFile = new File(this._tempDir, cacheFileName);
        if (cacheFile.exists()) {
            long lastModified = PortalWebResourcesUtil.getLastModified((String)"js");
            long fileLastModifiedTime = -1L;
            try (FileReader reader = new FileReader(cacheFile);
                 UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)reader);){
                String line = unsyncBufferedReader.readLine();
                if (line != null && line.startsWith("//")) {
                    fileLastModifiedTime = GetterUtil.getLong((String)line.substring(2), (long)-1L);
                }
            }
            if (lastModified == fileLastModifiedTime) {
                response.setContentType("text/javascript");
                return cacheFile;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Aggregating JavaScript bundle " + bundleId));
        }
        String content = null;
        content = fileNames.length == 0 ? "" : AggregateFilter.aggregateJavaScript(new ServletPaths(jsServletContext, bundleDirName), fileNames);
        content = StringBundler.concat((Object[])new Object[]{"//", PortalWebResourcesUtil.getLastModified((String)"js"), "\n", content});
        response.setContentType("text/javascript");
        FileUtil.write((File)cacheFile, (String)content);
        return content;
    }

    protected String getCacheFileName(HttpServletRequest request) {
        return CacheFileNameGenerator.getCacheFileName(request, AggregateFilter.class.getName());
    }

    protected Object getContent(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        URL resourceURL;
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String minifierBundleId = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId");
        String minifierBundleDirName = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleDir");
        if (Validator.isNull((String)minifierType) || Validator.isNotNull((String)minifierBundleId) || Validator.isNotNull((String)minifierBundleDirName)) {
            return null;
        }
        String resourcePath = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (!contextPath.equals("/")) {
            resourcePath = resourcePath.substring(contextPath.length());
        }
        if ((resourceURL = ResourceUtil.getResourceURL((String)resourcePath, (String)request.getRequestURI(), (ServletContext)this._servletContext)) == null) {
            return null;
        }
        String cacheCommonFileName = this.getCacheFileName(request);
        File cacheContentTypeFile = new File(this._tempDir, cacheCommonFileName + "_E_CTYPE");
        File cacheDataFile = new File(this._tempDir, cacheCommonFileName + "_E_DATA");
        if (cacheDataFile.exists() && !this._isLegacyIe(request)) {
            long fileLastModifiedTime = -1L;
            try (FileReader reader = new FileReader(cacheDataFile);
                 UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)reader);){
                String line = unsyncBufferedReader.readLine();
                if (line != null && line.startsWith(_CSS_COMMENT_BEGIN) && line.endsWith(_CSS_COMMENT_END)) {
                    fileLastModifiedTime = GetterUtil.getLong((String)line.substring(2, line.length() - 2), (long)-1L);
                }
            }
            if (URLUtil.getLastModifiedTime((URL)resourceURL) == fileLastModifiedTime) {
                if (cacheContentTypeFile.exists()) {
                    String contentType = FileUtil.read((File)cacheContentTypeFile);
                    response.setContentType(contentType);
                } else if (resourcePath.endsWith(_CSS_EXTENSION)) {
                    response.setContentType("text/css");
                } else if (resourcePath.endsWith(_JAVASCRIPT_EXTENSION)) {
                    response.setContentType("text/javascript");
                }
                return cacheDataFile;
            }
        }
        try (Closeable closeable = MinifierThreadLocal.disable();){
            Object bufferCacheServletResponse;
            String content = null;
            if (resourcePath.endsWith(_CSS_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying CSS " + resourcePath));
                }
                content = this.getCssContent(request, response, resourcePath);
                response.setContentType("text/css");
                if (!this._isLegacyIe(request)) {
                    FileUtil.write((File)cacheContentTypeFile, (String)"text/css");
                }
            } else if (resourcePath.endsWith(_JAVASCRIPT_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying JavaScript " + resourcePath));
                }
                content = this.getJavaScriptContent(request, response, resourcePath, resourceURL);
                response.setContentType("text/javascript");
                FileUtil.write((File)cacheContentTypeFile, (String)"text/javascript");
            } else if (resourcePath.endsWith(_JSP_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying JSP " + resourcePath));
                }
                bufferCacheServletResponse = new BufferCacheServletResponse(response);
                this.processFilter(AggregateFilter.class.getName(), request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
                content = bufferCacheServletResponse.getString();
                if (minifierType.equals("css")) {
                    content = this.getCssContent(request, response, resourcePath, content);
                } else if (minifierType.equals("js")) {
                    content = AggregateFilter.getJavaScriptContent(resourcePath, content);
                }
                FileUtil.write((File)cacheContentTypeFile, (String)bufferCacheServletResponse.getContentType());
            } else {
                bufferCacheServletResponse = null;
                return bufferCacheServletResponse;
            }
            content = StringBundler.concat((Object[])new Object[]{_CSS_COMMENT_BEGIN, URLUtil.getLastModifiedTime((URL)resourceURL), _CSS_COMMENT_END, "\n", content});
            FileUtil.write((File)cacheDataFile, (String)content);
            if (!PropsValues.MINIFIER_ENABLED) {
                bufferCacheServletResponse = content;
                return bufferCacheServletResponse;
            }
            String finalContent = content;
            String finalResourcePath = resourcePath;
            NoticeableFuture noticeableFuture = this._noticeableFutures.computeIfAbsent(cacheCommonFileName, key -> {
                NoticeableExecutorService noticeableExecutorService = _portalExecutorManager.getPortalExecutor(AggregateFilter.class.getName());
                return noticeableExecutorService.submit(() -> {
                    String minifiedContent = null;
                    minifiedContent = minifierType.equals("css") ? MinifierUtil.minifyCss(finalContent) : MinifierUtil.minifyJavaScript(finalResourcePath, finalContent);
                    minifiedContent = StringBundler.concat((Object[])new Object[]{_CSS_COMMENT_BEGIN, URLUtil.getLastModifiedTime((URL)resourceURL), _CSS_COMMENT_END, "\n", minifiedContent});
                    File tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (String)minifiedContent);
                    FileUtil.move((File)tempFile, (File)cacheDataFile);
                    return minifiedContent;
                });
            });
            noticeableFuture.addFutureListener(future -> this._noticeableFutures.remove(cacheCommonFileName));
            String string = content;
            return string;
        }
    }

    protected String getCssContent(HttpServletRequest request, HttpServletResponse response, ServletContext cssServletContext, String resourcePath, String content) {
        try {
            content = DynamicCSSUtil.replaceToken(cssServletContext, request, content);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to replace tokens in CSS " + resourcePath), (Throwable)e);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)content);
            }
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        }
        String browserId = ParamUtil.getString((HttpServletRequest)request, (String)"browserId");
        if (!browserId.equals("ie")) {
            Matcher matcher = _pattern.matcher(content);
            content = matcher.replaceAll("");
        }
        return MinifierUtil.minifyCss(content);
    }

    protected String getCssContent(HttpServletRequest request, HttpServletResponse response, String resourcePath) throws IOException, ServletException {
        String resourcePathRoot = null;
        String requestURI = request.getRequestURI();
        ServletContext cssServletContext = ResourceUtil.getPathServletContext((String)resourcePath, (String)requestURI, (ServletContext)this._servletContext);
        if (PortalWebResourcesUtil.hasContextPath((String)requestURI)) {
            resourcePathRoot = PortalWebResourcesUtil.stripContextPath((ServletContext)cssServletContext, (String)resourcePath);
            if ((resourcePathRoot = ServletPaths.getParentPath(resourcePathRoot)).equals("")) {
                resourcePathRoot = "/";
            }
        } else {
            resourcePathRoot = ServletPaths.getParentPath(resourcePath);
        }
        String content = this._readResource(request, response, resourcePath);
        if (this._isLegacyIe(request)) {
            return this.getCssContent(request, response, cssServletContext, resourcePath, content);
        }
        content = AggregateFilter.aggregateCss(new ServletPaths(cssServletContext, resourcePathRoot), content);
        return this.getCssContent(request, response, cssServletContext, resourcePath, content);
    }

    protected String getCssContent(HttpServletRequest request, HttpServletResponse response, String resourcePath, String content) {
        try {
            String requestURI = request.getRequestURI();
            ServletContext cssServletContext = ResourceUtil.getPathServletContext((String)resourcePath, (String)requestURI, (ServletContext)this._servletContext);
            return this.getCssContent(request, response, cssServletContext, resourcePath, content);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to detect servlet context " + resourcePath), (Throwable)e);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)content);
            }
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            return content;
        }
    }

    protected String getJavaScriptContent(HttpServletRequest request, HttpServletResponse response, String resourcePath, URL resourceURL) throws IOException, ServletException {
        String content = this._readResource(request, response, resourcePath);
        return AggregateFilter.getJavaScriptContent(resourceURL.toString(), content);
    }

    @Override
    protected boolean isModuleRequest(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (PortalWebResourcesUtil.hasContextPath((String)requestURI)) {
            return false;
        }
        return super.isModuleRequest(request);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Object minifiedContent = this.getContent(request, response, filterChain);
        if (minifiedContent == null) {
            minifiedContent = this.getBundleContent(request, response);
        }
        if (minifiedContent == null) {
            this.processFilter(AggregateFilter.class.getName(), request, response, filterChain);
        } else if (minifiedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)response, (File)((File)minifiedContent));
        } else if (minifiedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)response, (String)((String)minifiedContent));
        }
    }

    private boolean _isLegacyIe(HttpServletRequest request) {
        return BrowserSnifferUtil.isIe((HttpServletRequest)request) && BrowserSnifferUtil.getMajorVersion((HttpServletRequest)request) < 10.0f;
    }

    private String _readResource(HttpServletRequest request, HttpServletResponse response, String resourcePath) throws IOException, ServletException {
        URL url = this._servletContext.getResource(resourcePath);
        if (url == null) {
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(resourcePath);
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
            requestDispatcher.include((ServletRequest)request, (ServletResponse)bufferCacheServletResponse);
            return bufferCacheServletResponse.getString();
        }
        URLConnection urlConnection = url.openConnection();
        return StringUtil.read((InputStream)urlConnection.getInputStream());
    }
}

