/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.i18n;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class I18nFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = I18nFilter.class.getName() + "#SKIP_FILTER";
    private static final Log _log = LogFactoryUtil.getLog(I18nFilter.class);
    private static Set<String> _languageIds;

    public static Set<String> getLanguageIds() {
        return _languageIds;
    }

    public static void setLanguageIds(Set<String> languageIds) {
        _languageIds = new HashSet<String>();
        for (String languageId : languageIds) {
            languageId = languageId.substring(1);
            _languageIds.add(languageId);
        }
        _languageIds = Collections.unmodifiableSet(_languageIds);
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return !this.isAlreadyFiltered(request) && !this.isForwardedByI18nServlet(request) && !this.isWidget(request);
    }

    protected String getDefaultLanguageId(HttpServletRequest request) {
        String defaultLanguageId = this.getSiteDefaultLanguageId(request);
        if (Validator.isNull((String)defaultLanguageId)) {
            defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        }
        return defaultLanguageId;
    }

    protected String getFriendlyURL(HttpServletRequest request) {
        String[] pathInfoElements;
        String friendlyURL = "";
        String pathInfo = request.getPathInfo();
        if (Validator.isNotNull((String)pathInfo) && (pathInfoElements = pathInfo.split("/")) != null && pathInfoElements.length > 1) {
            friendlyURL = "/" + pathInfoElements[1];
        }
        return friendlyURL;
    }

    protected String getRedirect(HttpServletRequest request) throws Exception {
        String queryString;
        Group group;
        long companyId;
        Group friendlyURLGroup;
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0) {
            return null;
        }
        String method = request.getMethod();
        if (method.equals("POST")) {
            return null;
        }
        String contextPath = PortalUtil.getPathContext();
        String requestURI = request.getRequestURI();
        if (Validator.isNotNull((String)contextPath) && requestURI.contains(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        requestURI = StringUtil.replace((String)requestURI, (String)"//", (String)"/");
        String i18nLanguageId = this.prependI18nLanguageId(request, PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE);
        if (i18nLanguageId == null) {
            return null;
        }
        Locale locale = LocaleUtil.fromLanguageId((String)i18nLanguageId);
        if (!LanguageUtil.isAvailableLocale((Locale)locale)) {
            return null;
        }
        String i18nPathLanguageId = PortalUtil.getI18nPathLanguageId((Locale)locale, (String)i18nLanguageId);
        String i18nPath = "/".concat(i18nPathLanguageId);
        if (requestURI.contains(i18nPath.concat("/"))) {
            return null;
        }
        String redirect = contextPath + i18nPath + requestURI;
        int[] groupFriendlyURLIndex = PortalUtil.getGroupFriendlyURLIndex((String)requestURI);
        String groupFriendlyURL = "";
        int friendlyURLStart = 0;
        int friendlyURLEnd = 0;
        if (groupFriendlyURLIndex != null) {
            friendlyURLStart = groupFriendlyURLIndex[0];
            friendlyURLEnd = groupFriendlyURLIndex[1];
            groupFriendlyURL = requestURI.substring(friendlyURLStart, friendlyURLEnd);
        }
        if ((friendlyURLGroup = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)(companyId = PortalUtil.getCompanyId((HttpServletRequest)request)), (String)groupFriendlyURL)) != null && !LanguageUtil.isAvailableLocale((long)friendlyURLGroup.getGroupId(), (String)i18nLanguageId)) {
            return null;
        }
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null && !layoutSet.isPrivateLayout() && requestURI.startsWith(PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING) && groupFriendlyURL.equals((group = layoutSet.getGroup()).getFriendlyURL())) {
            redirect = contextPath + i18nPath + requestURI.substring(friendlyURLEnd);
        }
        if (Validator.isNull((String)(queryString = request.getQueryString()))) {
            queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
        }
        if (Validator.isNotNull((String)queryString)) {
            redirect = redirect + "?" + queryString;
        }
        return redirect;
    }

    protected String getRequestedLanguageId(HttpServletRequest request, String userLanguageId) {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        String requestedLanguageId = null;
        if (locale != null) {
            requestedLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        }
        if (Validator.isNull(requestedLanguageId)) {
            requestedLanguageId = userLanguageId;
        }
        if (Validator.isNull((String)requestedLanguageId)) {
            requestedLanguageId = CookieKeys.getCookie((HttpServletRequest)request, (String)"GUEST_LANGUAGE_ID", (boolean)false);
        }
        return requestedLanguageId;
    }

    protected String getSiteDefaultLanguageId(HttpServletRequest request) {
        String friendlyURL = this.getFriendlyURL(request);
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        try {
            Group group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)friendlyURL);
            Locale siteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)group.getGroupId());
            return LocaleUtil.toLanguageId((Locale)siteDefaultLocale);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                pe.printStackTrace();
            }
            return "";
        }
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isForwardedByI18nServlet(HttpServletRequest request) {
        return request.getAttribute("I18N_LANGUAGE_ID") != null || request.getAttribute("I18N_PATH") != null;
    }

    protected boolean isWidget(HttpServletRequest request) {
        return request.getAttribute("WIDGET") != null;
    }

    protected String prependI18nLanguageId(HttpServletRequest request, int prependFriendlyUrlStyle) {
        User user = (User)request.getAttribute("USER");
        String userLanguageId = null;
        if (user != null) {
            userLanguageId = user.getLanguageId();
        }
        String requestedLanguageId = this.getRequestedLanguageId(request, userLanguageId);
        String defaultLanguageId = this.getDefaultLanguageId(request);
        if (Validator.isNull((String)requestedLanguageId)) {
            requestedLanguageId = defaultLanguageId;
        }
        if (prependFriendlyUrlStyle == 1) {
            return this.prependIfRequestedLocaleDiffersFromDefaultLocale(defaultLanguageId, requestedLanguageId);
        }
        if (prependFriendlyUrlStyle == 2) {
            return requestedLanguageId;
        }
        if (prependFriendlyUrlStyle == 3) {
            if (user != null) {
                if (userLanguageId.equals(requestedLanguageId)) {
                    return null;
                }
                return requestedLanguageId;
            }
            return this.prependIfRequestedLocaleDiffersFromDefaultLocale(defaultLanguageId, requestedLanguageId);
        }
        return null;
    }

    protected String prependIfRequestedLocaleDiffersFromDefaultLocale(String defaultLanguageId, String guestLanguageId) {
        if (defaultLanguageId.equals(guestLanguageId)) {
            return null;
        }
        return guestLanguageId;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        String redirect = this.getRedirect(request);
        if (redirect == null) {
            this.processFilter(I18nFilter.class.getName(), request, response, filterChain);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect " + redirect));
        }
        response.sendRedirect(redirect);
    }
}

