/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeLoader {
    private static final Log _log = LogFactoryUtil.getLog(ThemeLoader.class);
    private final File _fileStorage;
    private final Map<String, Long> _lastModifiedMap = new HashMap<String, Long>();
    private final boolean _loadFromServletContext;
    private final ServletContext _servletContext;
    private final String _servletContextName;
    private final String _themesPath;

    public File getFileStorage() {
        return this._fileStorage;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public String getThemesPath() {
        return this._themesPath;
    }

    public synchronized void loadThemes() {
        File[] files;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Loading themes in " + this._fileStorage));
        }
        if ((files = this._fileStorage.listFiles()) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("There are no directories to process for " + this._fileStorage));
            }
            return;
        }
        for (File directory : files) {
            File liferayLookAndFeelXML;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Process directory " + directory));
            }
            if ((liferayLookAndFeelXML = new File(directory + "/liferay-look-and-feel.xml")).exists()) {
                String lastModifiedKey = liferayLookAndFeelXML.toString();
                Long prevLastModified = this._lastModifiedMap.get(lastModifiedKey);
                long lastModified = liferayLookAndFeelXML.lastModified();
                if (prevLastModified == null || prevLastModified < lastModified) {
                    this.registerTheme(liferayLookAndFeelXML);
                    this._lastModifiedMap.put(lastModifiedKey, lastModified);
                    continue;
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not refresh " + liferayLookAndFeelXML + " because it is has not been modified"));
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)(liferayLookAndFeelXML + " does not exist"));
        }
    }

    protected ThemeLoader(String servletContextName, ServletContext servletContext, String[] xmls) {
        this._servletContextName = servletContextName;
        this._servletContext = servletContext;
        boolean loadFromServletContext = true;
        File fileStorage = null;
        String themesPath = null;
        try {
            Document doc = UnsecureSAXReaderUtil.read((String)xmls[0], (boolean)true);
            Element root = doc.getRootElement();
            themesPath = GetterUtil.getString((String)root.elementText("themes-path"), (String)"/themes");
            String fileStorageValue = PropsValues.THEME_LOADER_STORAGE_PATH;
            fileStorageValue = GetterUtil.getString((String)root.elementText("file-storage"), (String)fileStorageValue);
            if (Validator.isNotNull((String)fileStorageValue)) {
                fileStorage = new File(fileStorageValue);
                loadFromServletContext = false;
            } else {
                fileStorage = new File(servletContext.getRealPath(themesPath));
                loadFromServletContext = true;
            }
            if (!fileStorage.exists()) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("File storage " + fileStorage + " does not exist"));
                }
                if (!fileStorage.mkdirs()) {
                    _log.error((Object)("Unable to create theme loader file storage at " + fileStorage));
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._loadFromServletContext = loadFromServletContext;
        this._fileStorage = fileStorage;
        this._themesPath = themesPath;
        this.loadThemes();
    }

    protected void destroy() {
    }

    protected void registerTheme(File liferayLookAndFeelXML) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering " + liferayLookAndFeelXML));
        }
        try {
            String content = FileUtil.read((File)liferayLookAndFeelXML);
            ThemeLocalServiceUtil.init((String)this._servletContextName, (ServletContext)this._servletContext, (String)this._themesPath, (boolean)this._loadFromServletContext, (String[])new String[]{content}, null);
        }
        catch (Exception e) {
            _log.error((Object)("Error registering theme " + liferayLookAndFeelXML.toString()), (Throwable)e);
        }
    }
}

