/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.deploy.BaseDeployer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThemeDeployer
extends BaseDeployer {
    private static final Log _log = LogFactoryUtil.getLog(ThemeDeployer.class);

    public static void main(String[] args) {
        block9: {
            ToolDependencies.wireDeployers();
            ArrayList<String> wars = new ArrayList<String>();
            ArrayList<String> jars = new ArrayList<String>();
            for (String arg : args) {
                if (arg.endsWith(".war")) {
                    wars.add(arg);
                    continue;
                }
                if (!arg.endsWith(".jar")) continue;
                jars.add(arg);
            }
            try {
                ThemeDeployer themeDeployer = new ThemeDeployer(wars, jars);
                Throwable throwable = null;
                if (themeDeployer != null) {
                    if (throwable != null) {
                        try {
                            themeDeployer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        themeDeployer.close();
                    }
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
    }

    public ThemeDeployer() {
    }

    public ThemeDeployer(List<String> wars, List<String> jars) {
        super(wars, jars);
    }

    @Override
    public void checkArguments() {
        super.checkArguments();
        if (Validator.isNull((String)this.themeTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.theme.taglib.dtd is not set");
        }
        if (Validator.isNull((String)this.utilTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.util.taglib.dtd is not set");
        }
    }

    @Override
    public String getExtraFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        StringBundler sb = new StringBundler(3);
        String extraFiltersContent = super.getExtraFiltersContent(webXmlVersion, srcFile);
        sb.append(extraFiltersContent);
        sb.append(this.getIgnoreFiltersContent(srcFile));
        sb.append(this.getSpeedFiltersContent(srcFile));
        return sb.toString();
    }

    @Override
    public String getPluginType() {
        return "theme";
    }

    @Override
    public Map<String, String> processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        Map<String, String> filterMap = super.processPluginPackageProperties(srcFile, displayName, pluginPackage);
        if (filterMap == null) {
            return null;
        }
        String moduleArtifactId = filterMap.get("module_artifact_id");
        int pos = moduleArtifactId.indexOf("-theme");
        String themeId = moduleArtifactId.substring(0, pos);
        filterMap.put("theme_id", themeId);
        String themeName = filterMap.get("plugin_name");
        filterMap.put("theme_name", StringUtil.stripCDATA((String)themeName));
        String liferayVersions = filterMap.get("liferay_versions");
        filterMap.put("theme_versions", StringUtil.replace((String)liferayVersions, (String)"liferay-version", (String)"version"));
        this.copyDependencyXml("liferay-look-and-feel.xml", srcFile + "/WEB-INF", filterMap, true);
        return filterMap;
    }
}

