/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.StagnantRowException;
import com.liferay.portal.kernel.upgrade.util.ValueMapper;
import com.liferay.portal.upgrade.util.PKUpgradeColumnImpl;

public class LazyPKUpgradeColumnImpl
extends PKUpgradeColumnImpl {
    private static final Log _log = LogFactoryUtil.getLog(LazyPKUpgradeColumnImpl.class);

    public LazyPKUpgradeColumnImpl(String name) {
        super(name, true);
    }

    public LazyPKUpgradeColumnImpl(String name, Integer oldColumnType) {
        super(name, oldColumnType, true);
    }

    @Override
    public Object getNewValue(Object oldValue) throws Exception {
        ValueMapper valueMapper = this.getValueMapper();
        Long newValue = null;
        try {
            newValue = (Long)valueMapper.getNewValue(oldValue);
        }
        catch (StagnantRowException sre) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sre, (Throwable)sre);
            }
            newValue = this.increment();
            valueMapper.mapValue(oldValue, (Object)newValue);
        }
        return newValue;
    }
}

