/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;

public class UpgradeLayout
extends UpgradeProcess {
    protected void deleteLinkedOrphanedLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(3);
            sb.append("delete from Layout where layoutPrototypeUuid != '' ");
            sb.append("and layoutPrototypeUuid not in (select uuid_ from ");
            sb.append("LayoutPrototype) and layoutPrototypeLinkEnabled = TRUE");
            this.runSQL(sb.toString());
        }
    }

    protected void deleteOrphanedFriendlyURL() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("delete from LayoutFriendlyURL where plid not in (select plid from Layout)");
        }
    }

    protected void doUpgrade() throws Exception {
        this.deleteLinkedOrphanedLayouts();
        this.deleteOrphanedFriendlyURL();
        this.updateLayoutPrototypeLinkEnabled();
        this.updateUnlinkedOrphanedLayouts();
    }

    protected void updateLayoutPrototypeLinkEnabled() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update Layout set layoutPrototypeLinkEnabled = [$FALSE$] where type_ = 'link_to_layout' and layoutPrototypeLinkEnabled = [$TRUE$]");
        }
    }

    protected void updateUnlinkedOrphanedLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("update Layout set layoutPrototypeUuid = null where ");
            sb.append("layoutPrototypeUuid != '' and layoutPrototypeUuid not ");
            sb.append("in (select uuid_ from LayoutPrototype) and ");
            sb.append("layoutPrototypeLinkEnabled = FALSE");
            this.runSQL(sb.toString());
        }
    }
}

