/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.expando.kernel.model.CustomAttributesDisplay;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationDeliveryType;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperTracker;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListener;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListenerWrapper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.security.permission.PermissionPropagator;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.notifications.UserNotificationHandlerImpl;
import com.liferay.portal.util.JavaFieldsParser;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.internal.FriendlyURLMapperTrackerImpl;
import com.liferay.portlet.internal.PortletBagImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialRequestInterpreter;
import com.liferay.social.kernel.model.impl.SocialActivityInterpreterImpl;
import com.liferay.social.kernel.model.impl.SocialRequestInterpreterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.Portlet;
import javax.portlet.PreferencesValidator;
import javax.servlet.ServletContext;

public class PortletBagFactory {
    private static final Log _log = LogFactoryUtil.getLog(PortletBagFactory.class);
    private ClassLoader _classLoader;
    private Configuration _configuration;
    private ServletContext _servletContext;
    private Boolean _warFile;

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        return this.create(portlet, false);
    }

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet, boolean destroyPrevious) throws Exception {
        this._validate();
        Portlet portletInstance = this._getPortletInstance(portlet);
        return this.create(portlet, portletInstance, destroyPrevious);
    }

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet, Portlet portletInstance, boolean destroyPrevious) throws Exception {
        this._validate();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.portlet.name", portlet.getPortletId());
        Registry registry = RegistryUtil.getRegistry();
        ArrayList serviceRegistrations = new ArrayList();
        this._registerConfigurationActions(registry, portlet, properties, serviceRegistrations);
        this._registerIndexers(registry, portlet, properties, serviceRegistrations);
        this._registerOpenSearches(registry, portlet, properties, serviceRegistrations);
        this._registerSchedulerEventMessageListeners(registry, portlet, properties, serviceRegistrations);
        FriendlyURLMapperTracker friendlyURLMapperTracker = this._registerFriendlyURLMappers(portlet);
        this._registerURLEncoders(registry, portlet, properties, serviceRegistrations);
        this._registerPortletDataHandlers(registry, portlet, properties, serviceRegistrations);
        this._registerStagedModelDataHandler(registry, portlet, properties, serviceRegistrations);
        this._registerTemplateHandlers(registry, portlet, properties, serviceRegistrations);
        this._registerPortletLayoutListeners(registry, portlet, properties, serviceRegistrations);
        this._registerPollerProcessors(registry, portlet, properties, serviceRegistrations);
        this._registerPOPMessageListeners(registry, portlet, properties, serviceRegistrations);
        this._registerSocialActivityInterpreterInstances(registry, portlet, properties, serviceRegistrations);
        this._registerSocialRequestInterpreterInstances(registry, portlet, properties, serviceRegistrations);
        this._registerUserNotificationDefinitionInstances(registry, portlet, properties, serviceRegistrations);
        this._registerUserNotificationHandlerInstances(registry, portlet, properties, serviceRegistrations);
        this._registerWebDAVStorageInstances(registry, portlet);
        this._registerXmlRpcMethodInstances(registry, portlet, properties, serviceRegistrations);
        this._registerControlPanelEntryInstances(registry, portlet, properties, serviceRegistrations);
        this._registerAssetRendererFactoryInstances(registry, portlet, properties, serviceRegistrations);
        this._registerAtomCollectionAdapterInstances(registry, portlet, properties, serviceRegistrations);
        this._registerCustomAttributesDisplayInstances(registry, portlet, properties, serviceRegistrations);
        this._registerPermissionPropagators(registry, portlet, properties, serviceRegistrations);
        this._registerTrashHandlerInstances(registry, portlet, properties, serviceRegistrations);
        this._registerWorkflowHandlerInstances(registry, portlet, properties, serviceRegistrations);
        this._registerPreferencesValidatorInstances(registry, portlet, properties, serviceRegistrations);
        PortletBagImpl portletBag = new PortletBagImpl(portlet.getPortletId(), this._servletContext, portletInstance, portlet.getResourceBundle(), friendlyURLMapperTracker, serviceRegistrations);
        PortletBagPool.put((String)portlet.getRootPortletId(), (PortletBag)portletBag);
        try {
            PortletInstanceFactoryUtil.create((com.liferay.portal.kernel.model.Portlet)portlet, (ServletContext)this._servletContext, (boolean)destroyPrevious);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return portletBag;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }

    private String _getContent(String fileName) throws Exception {
        String queryString = HttpUtil.getQueryString((String)fileName);
        if (Validator.isNull((String)queryString)) {
            return StringUtil.read((ClassLoader)this._classLoader, (String)fileName);
        }
        int pos = fileName.indexOf("?");
        String xml = StringUtil.read((ClassLoader)this._classLoader, (String)fileName.substring(0, pos));
        Map parameterMap = HttpUtil.getParameterMap((String)queryString);
        if (parameterMap == null) {
            return xml;
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values.length == 0) continue;
            String value = values[0];
            xml = StringUtil.replace((String)xml, (String)("@" + (String)entry.getKey() + "@"), (String)value);
        }
        return xml;
    }

    private String _getPluginPropertyValue(String propertyKey) throws Exception {
        if (this._configuration == null) {
            this._configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)this._classLoader, (String)"portlet");
        }
        return this._configuration.get(propertyKey);
    }

    private Portlet _getPortletInstance(com.liferay.portal.kernel.model.Portlet portlet) throws IllegalAccessException, InstantiationException {
        Class<?> portletClass = null;
        try {
            portletClass = this._classLoader.loadClass(portlet.getPortletClass());
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
            PortletLocalServiceUtil.destroyPortlet((com.liferay.portal.kernel.model.Portlet)portlet);
            return null;
        }
        return (Portlet)portletClass.newInstance();
    }

    private <T> T _newInstance(Class<? extends T> interfaceClass, String implClassName) throws Exception {
        if (this._warFile.booleanValue()) {
            return (T)ProxyFactory.newInstance((ClassLoader)this._classLoader, (Class[])new Class[]{interfaceClass}, (String)implClassName);
        }
        Class<?> clazz = this._classLoader.loadClass(implClassName);
        return (T)clazz.newInstance();
    }

    private void _registerAssetRendererFactoryInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String assetRendererFactoryClass : portlet.getAssetRendererFactoryClasses()) {
            String assetRendererEnabledPropertyKey = "asset.renderer.enabled." + assetRendererFactoryClass;
            String assetRendererEnabledPropertyValue = null;
            assetRendererEnabledPropertyValue = this._warFile != false ? this._getPluginPropertyValue(assetRendererEnabledPropertyKey) : PropsUtil.get((String)assetRendererEnabledPropertyKey);
            boolean assetRendererEnabledValue = GetterUtil.getBoolean((String)assetRendererEnabledPropertyValue, (boolean)true);
            if (!assetRendererEnabledValue) continue;
            AssetRendererFactory assetRendererFactoryInstance = this._newInstance(AssetRendererFactory.class, assetRendererFactoryClass);
            assetRendererFactoryInstance.setClassName(assetRendererFactoryInstance.getClassName());
            assetRendererFactoryInstance.setPortletId(portlet.getPortletId());
            ServiceRegistration serviceRegistration = registry.registerService(AssetRendererFactory.class, (Object)assetRendererFactoryInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerAtomCollectionAdapterInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String atomCollectionAdapterClass : portlet.getAtomCollectionAdapterClasses()) {
            AtomCollectionAdapter atomCollectionAdapterInstance = this._newInstance(AtomCollectionAdapter.class, atomCollectionAdapterClass);
            ServiceRegistration serviceRegistration = registry.registerService(AtomCollectionAdapter.class, (Object)atomCollectionAdapterInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerConfigurationActions(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getConfigurationActionClass())) {
            ConfigurationAction configurationAction = this._newInstance(ConfigurationAction.class, portlet.getConfigurationActionClass());
            ServiceRegistration serviceRegistration = registry.registerService(ConfigurationAction.class, (Object)configurationAction, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerControlPanelEntryInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getControlPanelEntryClass())) {
            ControlPanelEntry controlPanelEntryInstance = this._newInstance(ControlPanelEntry.class, portlet.getControlPanelEntryClass());
            ServiceRegistration serviceRegistration = registry.registerService(ControlPanelEntry.class, (Object)controlPanelEntryInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerCustomAttributesDisplayInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String customAttributesDisplayClass : portlet.getCustomAttributesDisplayClasses()) {
            CustomAttributesDisplay customAttributesDisplayInstance = this._newInstance(CustomAttributesDisplay.class, customAttributesDisplayClass);
            customAttributesDisplayInstance.setClassNameId(PortalUtil.getClassNameId((String)customAttributesDisplayInstance.getClassName()));
            customAttributesDisplayInstance.setPortletId(portlet.getPortletId());
            ServiceRegistration serviceRegistration = registry.registerService(CustomAttributesDisplay.class, (Object)customAttributesDisplayInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private FriendlyURLMapperTracker _registerFriendlyURLMappers(com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        FriendlyURLMapperTrackerImpl friendlyURLMapperTracker = new FriendlyURLMapperTrackerImpl(portlet);
        if (Validator.isNotNull((String)portlet.getFriendlyURLMapperClass())) {
            FriendlyURLMapper friendlyURLMapper = this._newInstance(FriendlyURLMapper.class, portlet.getFriendlyURLMapperClass());
            friendlyURLMapperTracker.register(friendlyURLMapper);
        }
        return friendlyURLMapperTracker;
    }

    private void _registerIndexers(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String indexerClass : portlet.getIndexerClasses()) {
            Indexer indexerInstance = this._newInstance(Indexer.class, indexerClass);
            ServiceRegistration serviceRegistration = registry.registerService(Indexer.class, (Object)indexerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerOpenSearches(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getOpenSearchClass())) {
            OpenSearch openSearch = this._newInstance(OpenSearch.class, portlet.getOpenSearchClass());
            ServiceRegistration serviceRegistration = registry.registerService(OpenSearch.class, (Object)openSearch, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPermissionPropagators(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPermissionPropagatorClass())) {
            PermissionPropagator permissionPropagatorInstance = this._newInstance(PermissionPropagator.class, portlet.getPermissionPropagatorClass());
            ServiceRegistration serviceRegistration = registry.registerService(PermissionPropagator.class, (Object)permissionPropagatorInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPollerProcessors(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPollerProcessorClass())) {
            PollerProcessor pollerProcessorInstance = this._newInstance(PollerProcessor.class, portlet.getPollerProcessorClass());
            ServiceRegistration serviceRegistration = registry.registerService(PollerProcessor.class, (Object)pollerProcessorInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPOPMessageListeners(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPopMessageListenerClass())) {
            com.liferay.portal.kernel.pop.MessageListener popMessageListenerInstance = this._newInstance(com.liferay.portal.kernel.pop.MessageListener.class, portlet.getPopMessageListenerClass());
            ServiceRegistration serviceRegistration = registry.registerService(com.liferay.portal.kernel.pop.MessageListener.class, (Object)popMessageListenerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPortletDataHandlers(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPortletDataHandlerClass())) {
            PortletDataHandler portletDataHandlerInstance = this._newInstance(PortletDataHandler.class, portlet.getPortletDataHandlerClass());
            portletDataHandlerInstance.setPortletId(portlet.getPortletId());
            ServiceRegistration serviceRegistration = registry.registerService(PortletDataHandler.class, (Object)portletDataHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPortletLayoutListeners(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPortletLayoutListenerClass())) {
            PortletLayoutListener portletLayoutListener = this._newInstance(PortletLayoutListener.class, portlet.getPortletLayoutListenerClass());
            ServiceRegistration serviceRegistration = registry.registerService(PortletLayoutListener.class, (Object)portletLayoutListener, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPreferencesValidatorInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getPreferencesValidator())) {
            PreferencesValidator preferencesValidatorInstance;
            block4: {
                preferencesValidatorInstance = this._newInstance(PreferencesValidator.class, portlet.getPreferencesValidator());
                try {
                    if (PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                        preferencesValidatorInstance.validate(PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences()));
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)("Portlet with the name " + portlet.getPortletId() + " does not have valid default preferences"));
                }
            }
            ServiceRegistration serviceRegistration = registry.registerService(PreferencesValidator.class, (Object)preferencesValidatorInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerSchedulerEventMessageListeners(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (SchedulerEntry schedulerEntry : portlet.getSchedulerEntries()) {
            SchedulerEventMessageListenerWrapper schedulerEventMessageListenerWrapper = new SchedulerEventMessageListenerWrapper();
            MessageListener messageListener = (MessageListener)InstanceFactory.newInstance((ClassLoader)this._classLoader, (String)schedulerEntry.getEventListenerClass());
            schedulerEventMessageListenerWrapper.setMessageListener(messageListener);
            schedulerEventMessageListenerWrapper.setSchedulerEntry(schedulerEntry);
            ServiceRegistration serviceRegistration = registry.registerService(SchedulerEventMessageListener.class, (Object)schedulerEventMessageListenerWrapper, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerSocialActivityInterpreterInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String socialActivityInterpreterClass : portlet.getSocialActivityInterpreterClasses()) {
            SocialActivityInterpreter socialActivityInterpreterInstance = this._newInstance(SocialActivityInterpreter.class, socialActivityInterpreterClass);
            socialActivityInterpreterInstance = new SocialActivityInterpreterImpl(portlet.getPortletId(), socialActivityInterpreterInstance);
            ServiceRegistration serviceRegistration = registry.registerService(SocialActivityInterpreter.class, (Object)socialActivityInterpreterInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerSocialRequestInterpreterInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getSocialRequestInterpreterClass())) {
            SocialRequestInterpreter socialRequestInterpreterInstance = this._newInstance(SocialRequestInterpreter.class, portlet.getSocialRequestInterpreterClass());
            socialRequestInterpreterInstance = new SocialRequestInterpreterImpl(portlet.getPortletId(), socialRequestInterpreterInstance);
            ServiceRegistration serviceRegistration = registry.registerService(SocialRequestInterpreter.class, (Object)socialRequestInterpreterInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerStagedModelDataHandler(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String stagedModelDataHandlerClass : portlet.getStagedModelDataHandlerClasses()) {
            StagedModelDataHandler stagedModelDataHandler = this._newInstance(StagedModelDataHandler.class, stagedModelDataHandlerClass);
            ServiceRegistration serviceRegistration = registry.registerService(StagedModelDataHandler.class, (Object)stagedModelDataHandler, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerTemplateHandlers(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getTemplateHandlerClass())) {
            TemplateHandler templateHandler = this._newInstance(TemplateHandler.class, portlet.getTemplateHandlerClass());
            ServiceRegistration serviceRegistration = registry.registerService(TemplateHandler.class, (Object)templateHandler, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerTrashHandlerInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String trashHandlerClass : portlet.getTrashHandlerClasses()) {
            TrashHandler trashHandlerInstance = this._newInstance(TrashHandler.class, trashHandlerClass);
            ServiceRegistration serviceRegistration = registry.registerService(TrashHandler.class, (Object)trashHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerURLEncoders(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getURLEncoderClass())) {
            URLEncoder urlEncoder = this._newInstance(URLEncoder.class, portlet.getURLEncoderClass());
            ServiceRegistration serviceRegistration = registry.registerService(URLEncoder.class, (Object)urlEncoder, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerUserNotificationDefinitionInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNull((String)portlet.getUserNotificationDefinitions())) {
            return;
        }
        String xml = this._getContent(portlet.getUserNotificationDefinitions());
        xml = JavaFieldsParser.parse(this._classLoader, xml);
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        for (Element definitionElement : rootElement.elements("definition")) {
            String modelName = definitionElement.elementText("model-name");
            long classNameId = 0L;
            if (Validator.isNotNull((String)modelName)) {
                classNameId = PortalUtil.getClassNameId((String)modelName);
            }
            int notificationType = GetterUtil.getInteger((String)definitionElement.elementText("notification-type"));
            String description = GetterUtil.getString((String)definitionElement.elementText("description"));
            UserNotificationDefinition userNotificationDefinition = new UserNotificationDefinition(portlet.getPortletId(), classNameId, notificationType, description);
            for (Element deliveryTypeElement : definitionElement.elements("delivery-type")) {
                String name = deliveryTypeElement.elementText("name");
                int type = GetterUtil.getInteger((String)deliveryTypeElement.elementText("type"));
                boolean defaultValue = GetterUtil.getBoolean((String)deliveryTypeElement.elementText("default"));
                boolean modifiable = GetterUtil.getBoolean((String)deliveryTypeElement.elementText("modifiable"));
                userNotificationDefinition.addUserNotificationDeliveryType(new UserNotificationDeliveryType(name, type, defaultValue, modifiable));
            }
            ServiceRegistration serviceRegistration = registry.registerService(UserNotificationDefinition.class, (Object)userNotificationDefinition, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerUserNotificationHandlerInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String userNotificationHandlerClass : portlet.getUserNotificationHandlerClasses()) {
            UserNotificationHandler userNotificationHandlerInstance = this._newInstance(UserNotificationHandler.class, userNotificationHandlerClass);
            userNotificationHandlerInstance = new UserNotificationHandlerImpl(userNotificationHandlerInstance);
            ServiceRegistration serviceRegistration = registry.registerService(UserNotificationHandler.class, (Object)userNotificationHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerWebDAVStorageInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        if (Validator.isNotNull((String)portlet.getWebDAVStorageClass())) {
            WebDAVStorage webDAVStorageInstance = this._newInstance(WebDAVStorage.class, portlet.getWebDAVStorageClass());
            HashMap<String, String> webDAVProperties = new HashMap<String, String>();
            webDAVProperties.put("javax.portlet.name", portlet.getPortletId());
            webDAVProperties.put("webdav.storage.token", portlet.getWebDAVStorageToken());
            registry.registerService(WebDAVStorage.class, (Object)webDAVStorageInstance, webDAVProperties);
        }
    }

    private void _registerWorkflowHandlerInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String workflowHandlerClass : portlet.getWorkflowHandlerClasses()) {
            WorkflowHandler workflowHandlerInstance = this._newInstance(WorkflowHandler.class, workflowHandlerClass);
            ServiceRegistration serviceRegistration = registry.registerService(WorkflowHandler.class, (Object)workflowHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerXmlRpcMethodInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull((String)portlet.getXmlRpcMethodClass())) {
            Method xmlRpcMethodInstance = this._newInstance(Method.class, portlet.getXmlRpcMethodClass());
            ServiceRegistration serviceRegistration = registry.registerService(Method.class, (Object)xmlRpcMethodInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _validate() {
        if (this._classLoader == null) {
            throw new IllegalStateException("Class loader is null");
        }
        if (this._servletContext == null) {
            throw new IllegalStateException("Servlet context is null");
        }
        if (this._warFile == null) {
            throw new IllegalStateException("WAR file is null");
        }
    }
}

