/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.PortletRequestProcessor;
import com.liferay.portal.struts.StrutsUtil;
import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletException;

public class StrutsPortlet
extends LiferayPortlet {
    protected String aboutAction;
    protected String configAction;
    protected boolean copyRequestParameters;
    protected String editAction;
    protected String editDefaultsAction;
    protected String editGuestAction;
    protected String helpAction;
    protected String previewAction;
    protected String printAction;
    protected String templatePath;
    protected String viewAction;
    private LiferayPortletConfig _liferayPortletConfig;

    public void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.aboutAction);
        this.include(renderRequest, renderResponse);
    }

    public void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.configAction);
        this.include(renderRequest, renderResponse);
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.editAction);
            this.include(renderRequest, renderResponse);
        }
    }

    public void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.editDefaultsAction);
            this.include(renderRequest, renderResponse);
        }
    }

    public void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.editGuestAction);
            this.include(renderRequest, renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.helpAction);
        this.include(renderRequest, renderResponse);
    }

    public void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.previewAction);
        this.include(renderRequest, renderResponse);
    }

    public void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.printAction);
        this.include(renderRequest, renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.viewAction);
        this.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.templatePath = this.getInitParameter("template-path");
        if (Validator.isNull((String)this.templatePath)) {
            this.templatePath = "/";
        } else {
            if (this.templatePath.contains("\\") || this.templatePath.contains("//") || this.templatePath.contains(".") || this.templatePath.contains(" ")) {
                throw new PortletException("template-path " + this.templatePath + " has invalid characters");
            }
            if (!this.templatePath.startsWith("/") || !this.templatePath.endsWith("/")) {
                throw new PortletException("template-path " + this.templatePath + " must start and end with a /");
            }
        }
        this.aboutAction = this.getInitParameter("about-action");
        this.configAction = this.getInitParameter("config-action");
        this.editAction = this.getInitParameter("edit-action");
        this.editDefaultsAction = this.getInitParameter("edit-defaults-action");
        this.editGuestAction = this.getInitParameter("edit-guest-action");
        this.helpAction = this.getInitParameter("help-action");
        this.previewAction = this.getInitParameter("preview-action");
        this.printAction = this.getInitParameter("print-action");
        this.viewAction = this.getInitParameter("view-action");
        this.copyRequestParameters = GetterUtil.getBoolean((String)this.getInitParameter("copy-request-parameters"), (boolean)true);
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this.initValidPaths(this.templatePath, ".jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        String path = actionRequest.getParameter("struts_action");
        if (Validator.isNotNull((String)path)) {
            try {
                PortletRequestProcessor processor = this._getPortletRequestProcessor();
                processor.process(actionRequest, actionResponse, path);
            }
            catch (ServletException se) {
                throw new PortletException((Throwable)se);
            }
        }
        if (this.copyRequestParameters) {
            PortalUtil.copyRequestParameters((ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    public void processEvent(EventRequest request, EventResponse response) throws IOException, PortletException {
        request.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.viewAction);
        try {
            PortletRequestProcessor processor = this._getPortletRequestProcessor();
            processor.process(request, response);
        }
        catch (ServletException se) {
            throw new PortletException((Throwable)se);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String resourceID = resourceRequest.getResourceID();
        this.checkPath(resourceID);
        resourceRequest.setAttribute("PORTLET_STRUTS_ACTION", (Object)this.viewAction);
        try {
            PortletRequestProcessor processor = this._getPortletRequestProcessor();
            processor.process(resourceRequest, resourceResponse);
        }
        catch (ServletException se) {
            throw new PortletException((Throwable)se);
        }
    }

    protected void checkPath(String path) throws PortletException {
        super.checkPath(path);
    }

    protected void include(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        Map<String, Object> strutsAttributes = null;
        if (this._liferayPortletConfig.isWARFile()) {
            strutsAttributes = StrutsUtil.removeStrutsAttributes(this.getPortletContext(), (PortletRequest)renderRequest);
        }
        try {
            PortletRequestProcessor processor = this._getPortletRequestProcessor();
            processor.process(renderRequest, renderResponse);
        }
        catch (ServletException se) {
            throw new PortletException((Throwable)se);
        }
        finally {
            if (this._liferayPortletConfig.isWARFile()) {
                StrutsUtil.setStrutsAttributes((PortletRequest)renderRequest, strutsAttributes);
            }
        }
        if (this.copyRequestParameters) {
            PortalUtil.clearRequestParameters((RenderRequest)renderRequest);
        }
    }

    private PortletRequestProcessor _getPortletRequestProcessor() {
        PortletContext portletContext = this.getPortletContext();
        return (PortletRequestProcessor)((Object)portletContext.getAttribute("PORTLET_STRUTS_PROCESSOR"));
    }
}

