/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryProperty;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.model.NullClassTypeReader;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import com.liferay.portlet.asset.util.AssetPublisherAddItemHolder;
import com.liferay.portlet.asset.util.AssetSearcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

@Deprecated
public class AssetUtil {
    public static final int ASSET_ENTRY_ABSTRACT_LENGTH = 200;
    public static final String CLASSNAME_SEPARATOR = "_CLASSNAME_";
    public static final char[] INVALID_CHARACTERS = new char[]{'&', '\'', '@', '\\', ']', '}', ':', ',', '=', '>', '/', '<', '\n', '[', '{', '%', '|', '+', '#', '`', '?', '\"', '\r', ';', '/', '*', '~'};
    private static final Log _log = LogFactoryUtil.getLog(AssetUtil.class);

    public static Set<String> addLayoutTags(HttpServletRequest request, List<AssetTag> tags) {
        Set<String> layoutTags = AssetUtil.getLayoutTagNames(request);
        for (AssetTag tag : tags) {
            layoutTags.add(tag.getName());
        }
        return layoutTags;
    }

    public static void addPortletBreadcrumbEntries(long assetCategoryId, HttpServletRequest request, PortletURL portletURL) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        boolean portletBreadcrumbEntry = false;
        if (Validator.isNotNull((String)portletDisplay.getId()) && !portletDisplay.isFocused()) {
            portletBreadcrumbEntry = true;
        }
        AssetUtil.addPortletBreadcrumbEntries(assetCategoryId, request, portletURL, portletBreadcrumbEntry);
    }

    public static void addPortletBreadcrumbEntries(long assetCategoryId, HttpServletRequest request, PortletURL portletURL, boolean portletBreadcrumbEntry) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetCategory assetCategory = AssetCategoryLocalServiceUtil.getCategory((long)assetCategoryId);
        List ancestorCategories = assetCategory.getAncestors();
        Collections.reverse(ancestorCategories);
        for (AssetCategory ancestorCategory : ancestorCategories) {
            portletURL.setParameter("categoryId", String.valueOf(ancestorCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorCategory.getTitle(themeDisplay.getLocale()), (String)portletURL.toString(), null, (boolean)portletBreadcrumbEntry);
        }
        portletURL.setParameter("categoryId", String.valueOf(assetCategoryId));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)assetCategory.getTitle(themeDisplay.getLocale()), (String)portletURL.toString(), null, (boolean)portletBreadcrumbEntry);
    }

    public static String checkViewURL(AssetEntry assetEntry, boolean viewInContext, String viewURL, String currentURL, ThemeDisplay themeDisplay) {
        if (Validator.isNull((String)viewURL)) {
            return viewURL;
        }
        viewURL = HttpUtil.setParameter((String)viewURL, (String)"inheritRedirect", (boolean)viewInContext);
        Layout layout = themeDisplay.getLayout();
        String assetEntryLayoutUuid = assetEntry.getLayoutUuid();
        if (!viewInContext || Validator.isNotNull((String)assetEntryLayoutUuid) && !assetEntryLayoutUuid.equals(layout.getUuid())) {
            viewURL = HttpUtil.setParameter((String)viewURL, (String)"redirect", (String)currentURL);
        }
        return viewURL;
    }

    public static long[] filterCategoryIds(PermissionChecker permissionChecker, long[] categoryIds) throws PortalException {
        ArrayList<Long> viewableCategoryIds = new ArrayList<Long>();
        for (long categoryId : categoryIds) {
            AssetCategory category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
            if (category == null || !AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            viewableCategoryIds.add(categoryId);
        }
        return ArrayUtil.toArray((Long[])viewableCategoryIds.toArray(new Long[viewableCategoryIds.size()]));
    }

    public static List<AssetVocabulary> filterVocabularies(List<AssetVocabulary> vocabularies, String className, final long classTypePK) {
        final long classNameId = PortalUtil.getClassNameId((String)className);
        PredicateFilter<AssetVocabulary> predicateFilter = new PredicateFilter<AssetVocabulary>(){

            public boolean filter(AssetVocabulary assetVocabulary) {
                return assetVocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK);
            }
        };
        return ListUtil.filter(vocabularies, (PredicateFilter)predicateFilter);
    }

    public static long[] filterVocabularyIds(PermissionChecker permissionChecker, long[] vocabularyIds) throws PortalException {
        ArrayList<Long> viewableVocabularyIds = new ArrayList<Long>();
        for (long vocabularyId : vocabularyIds) {
            if (!AssetVocabularyPermission.contains(permissionChecker, vocabularyId, "VIEW")) continue;
            viewableVocabularyIds.add(vocabularyId);
        }
        return ArrayUtil.toArray((Long[])viewableVocabularyIds.toArray(new Long[viewableVocabularyIds.size()]));
    }

    public static PortletURL getAddPortletURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long groupId, String className, long classTypeId, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        String referringPortletResource;
        PortletURL addPortletURL;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null || !assetRendererFactory.hasAddPermission(themeDisplay.getPermissionChecker(), groupId, classTypeId)) {
            return null;
        }
        if (groupId > 0L) {
            Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
            liferayPortletRequest.setAttribute("ASSET_RENDERER_FACTORY_GROUP", (Object)group);
        }
        if ((addPortletURL = assetRendererFactory.getURLAdd(liferayPortletRequest, liferayPortletResponse, classTypeId)) == null) {
            return null;
        }
        if (redirect != null) {
            addPortletURL.setParameter("redirect", redirect);
        }
        if (Validator.isNotNull((String)(referringPortletResource = ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"portletResource")))) {
            addPortletURL.setParameter("referringPortletResource", referringPortletResource);
        } else {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            addPortletURL.setParameter("referringPortletResource", portletDisplay.getId());
            if (allAssetCategoryIds != null) {
                HashMap<Long, String> assetVocabularyAssetCategoryIds = new HashMap<Long, String>();
                for (long assetCategoryId : allAssetCategoryIds) {
                    AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)assetCategoryId);
                    if (assetCategory == null) continue;
                    long assetVocabularyId = assetCategory.getVocabularyId();
                    if (assetVocabularyAssetCategoryIds.containsKey(assetVocabularyId)) {
                        String assetCategoryIds = (String)assetVocabularyAssetCategoryIds.get(assetVocabularyId);
                        assetVocabularyAssetCategoryIds.put(assetVocabularyId, assetCategoryIds + "," + assetCategoryId);
                        continue;
                    }
                    assetVocabularyAssetCategoryIds.put(assetVocabularyId, String.valueOf(assetCategoryId));
                }
                Object object = assetVocabularyAssetCategoryIds.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    long assetVocabularyId = (Long)entry.getKey();
                    String assetCategoryIds = (String)entry.getValue();
                    addPortletURL.setParameter("assetCategoryIds_" + assetVocabularyId, assetCategoryIds);
                }
            }
            if (allAssetTagNames != null) {
                addPortletURL.setParameter("assetTagNames", StringUtil.merge((Object[])allAssetTagNames));
            }
        }
        addPortletURL.setPortletMode(PortletMode.VIEW);
        addPortletURL.setWindowState(LiferayWindowState.POP_UP);
        return addPortletURL;
    }

    @Deprecated
    public static PortletURL getAddPortletURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String className, long classTypeId, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return AssetUtil.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, themeDisplay.getScopeGroupId(), className, classTypeId, allAssetCategoryIds, allAssetTagNames, redirect);
    }

    @Deprecated
    public static Map<String, PortletURL> getAddPortletURLs(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long groupId, long[] classNameIds, long[] classTypeIds, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        List<AssetPublisherAddItemHolder> assetPublisherAddItemHolders = AssetUtil.getAssetPublisherAddItemHolders(liferayPortletRequest, liferayPortletResponse, groupId, classNameIds, classTypeIds, allAssetCategoryIds, allAssetTagNames, redirect);
        LinkedHashMap<String, PortletURL> addPortletURLs = new LinkedHashMap<String, PortletURL>();
        for (AssetPublisherAddItemHolder assetPublisherAddItemHolder : assetPublisherAddItemHolders) {
            addPortletURLs.put(assetPublisherAddItemHolder.getName(), assetPublisherAddItemHolder.getPortletURL());
        }
        return addPortletURLs;
    }

    @Deprecated
    public static Map<String, PortletURL> getAddPortletURLs(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long[] classNameIds, long[] classTypeIds, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return AssetUtil.getAddPortletURLs(liferayPortletRequest, liferayPortletResponse, themeDisplay.getScopeGroupId(), classNameIds, classTypeIds, allAssetCategoryIds, allAssetTagNames, redirect);
    }

    public static String getAddURLPopUp(long groupId, long plid, PortletURL addPortletURL, boolean addDisplayPageParameter, Layout layout) {
        addPortletURL.setParameter("hideDefaultSuccessMessage", Boolean.TRUE.toString());
        addPortletURL.setParameter("groupId", String.valueOf(groupId));
        addPortletURL.setParameter("showHeader", Boolean.FALSE.toString());
        if (addDisplayPageParameter && layout != null) {
            addPortletURL.setParameter("layoutUuid", layout.getUuid());
        }
        if (addPortletURL instanceof LiferayPortletURL) {
            LiferayPortletURL liferayPortletURL = (LiferayPortletURL)addPortletURL;
            liferayPortletURL.setRefererPlid(plid);
            return liferayPortletURL.toString();
        }
        return HttpUtil.addParameter((String)addPortletURL.toString(), (String)"refererPlid", (long)plid);
    }

    @Deprecated
    public static String getAddURLPopUp(long groupId, long plid, PortletURL addPortletURL, String portletId, boolean addDisplayPageParameter, Layout layout) {
        return AssetUtil.getAddURLPopUp(groupId, plid, addPortletURL, addDisplayPageParameter, layout);
    }

    public static List<AssetEntry> getAssetEntries(Hits hits) {
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        if (hits.getDocs() == null) {
            return assetEntries;
        }
        for (Document document : hits.getDocs()) {
            String className = GetterUtil.getString((String)document.get("entryClassName"));
            long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
                assetEntries.add(assetEntry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return assetEntries;
    }

    public static String getAssetKeywords(String className, long classPK) {
        List tags = AssetTagLocalServiceUtil.getTags((String)className, (long)classPK);
        List categories = AssetCategoryLocalServiceUtil.getCategories((String)className, (long)classPK);
        StringBuffer sb = new StringBuffer();
        sb.append(ListUtil.toString((List)tags, (Accessor)AssetTag.NAME_ACCESSOR));
        if (!tags.isEmpty()) {
            sb.append(",");
        }
        sb.append(ListUtil.toString((List)categories, (Accessor)AssetCategory.NAME_ACCESSOR));
        return sb.toString();
    }

    public static List<AssetPublisherAddItemHolder> getAssetPublisherAddItemHolders(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long groupId, long[] classNameIds, long[] classTypeIds, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Locale locale = themeDisplay.getLocale();
        ArrayList<AssetPublisherAddItemHolder> assetPublisherAddItemHolders = new ArrayList<AssetPublisherAddItemHolder>();
        for (long classNameId : classNameIds) {
            PortletURL addPortletURL;
            PortletBag portletBag;
            Portlet portlet;
            String className = PortalUtil.getClassName((long)classNameId);
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
            if (Validator.isNull((String)assetRendererFactory.getPortletId()) || !(portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)assetRendererFactory.getPortletId())).isActive() || (portletBag = PortletBagPool.get((String)portlet.getRootPortletId())) == null) continue;
            ResourceBundle resourceBundle = portletBag.getResourceBundle(locale);
            ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
            List classTypes = Collections.emptyList();
            if (!(classTypeReader instanceof NullClassTypeReader)) {
                classTypes = classTypeReader.getAvailableClassTypes(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId), themeDisplay.getLocale());
            }
            if (classTypes.isEmpty() && (addPortletURL = AssetUtil.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, groupId, className, 0L, allAssetCategoryIds, allAssetTagNames, redirect)) != null) {
                assetPublisherAddItemHolders.add(new AssetPublisherAddItemHolder(portlet.getPortletId(), className, resourceBundle, locale, addPortletURL));
            }
            for (ClassType classType : classTypes) {
                PortletURL addPortletURL2;
                long classTypeId = classType.getClassTypeId();
                if (!ArrayUtil.contains((long[])classTypeIds, (long)classTypeId) && classTypeIds.length != 0 || (addPortletURL2 = AssetUtil.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, groupId, className, classTypeId, allAssetCategoryIds, allAssetTagNames, redirect)) == null) continue;
                assetPublisherAddItemHolders.add(new AssetPublisherAddItemHolder(portlet.getPortletId(), classType.getName(), resourceBundle, locale, addPortletURL2));
            }
        }
        if (assetPublisherAddItemHolders.size() <= 1) {
            return assetPublisherAddItemHolders;
        }
        assetPublisherAddItemHolders.sort(null);
        return assetPublisherAddItemHolders;
    }

    public static String getClassName(String className) {
        int pos = className.indexOf(CLASSNAME_SEPARATOR);
        if (pos != -1) {
            className = className.substring(0, pos);
        }
        return className;
    }

    @Deprecated
    public static String getClassNameMessage(String className, Locale locale) {
        String message = null;
        int pos = className.indexOf(CLASSNAME_SEPARATOR);
        if (pos != -1) {
            message = className.substring(pos + CLASSNAME_SEPARATOR.length());
            className = className.substring(0, pos);
            return message;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        return assetRendererFactory.getTypeName(locale);
    }

    public static String getDefaultAssetPublisherId(Layout layout) {
        return layout.getTypeSettingsProperty("default-asset-publisher-portlet-id", "");
    }

    public static Set<String> getLayoutTagNames(HttpServletRequest request) {
        HashSet tagNames = (HashSet)request.getAttribute("ASSET_LAYOUT_TAG_NAMES");
        if (tagNames == null) {
            tagNames = new HashSet();
            request.setAttribute("ASSET_LAYOUT_TAG_NAMES", tagNames);
        }
        return tagNames;
    }

    public static boolean hasSubtype(String subtypeClassName, Map<String, PortletURL> addPortletURLs) {
        for (Map.Entry<String, PortletURL> entry : addPortletURLs.entrySet()) {
            String className = entry.getKey();
            if (!className.startsWith(subtypeClassName) || className.equals(subtypeClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefaultAssetPublisher(Layout layout, String portletId, String portletResource) {
        String defaultAssetPublisherPortletId = AssetUtil.getDefaultAssetPublisherId(layout);
        if (Validator.isNull((String)defaultAssetPublisherPortletId)) {
            return false;
        }
        return defaultAssetPublisherPortletId.equals(portletId) || defaultAssetPublisherPortletId.equals(portletResource);
    }

    public static boolean isValidWord(String word) {
        char[] wordCharArray;
        if (Validator.isBlank((String)word)) {
            return false;
        }
        for (char c : wordCharArray = word.toCharArray()) {
            for (char invalidChar : INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Word ", word, " is not valid because ", String.valueOf(c), " is not allowed"}));
                }
                return false;
            }
        }
        return true;
    }

    public static Hits search(HttpServletRequest request, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)request);
        return AssetUtil.search(searchContext, assetEntryQuery, start, end);
    }

    public static Hits search(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        AssetSearcher assetSearcher = AssetUtil.getAssetSearcher(searchContext, assetEntryQuery, start, end);
        return assetSearcher.search(searchContext);
    }

    public static BaseModelSearchResult<AssetEntry> searchAssetEntries(AssetEntryQuery assetEntryQuery, long[] assetCategoryIds, String[] assetTagNames, Map<String, Serializable> attributes, long companyId, String keywords, Layout layout, Locale locale, long scopeGroupId, TimeZone timeZone, long userId, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((long[])assetCategoryIds, (String[])assetTagNames, attributes, (long)companyId, (String)keywords, (Layout)layout, (Locale)locale, (long)scopeGroupId, (TimeZone)timeZone, (long)userId);
        return AssetUtil.searchAssetEntries(searchContext, assetEntryQuery, start, end);
    }

    public static BaseModelSearchResult<AssetEntry> searchAssetEntries(HttpServletRequest request, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)request);
        return AssetUtil.searchAssetEntries(searchContext, assetEntryQuery, start, end);
    }

    public static BaseModelSearchResult<AssetEntry> searchAssetEntries(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        AssetSearcher assetSearcher = AssetUtil.getAssetSearcher(searchContext, assetEntryQuery, start, end);
        Hits hits = assetSearcher.search(searchContext);
        List<AssetEntry> assetEntries = AssetUtil.getAssetEntries(hits);
        return new BaseModelSearchResult(assetEntries, hits.getLength());
    }

    public static String substituteCategoryPropertyVariables(long groupId, long categoryId, String s) {
        String result = s;
        AssetCategory category = null;
        if (categoryId > 0L) {
            category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
        }
        if (category != null) {
            List categoryProperties = AssetCategoryPropertyLocalServiceUtil.getCategoryProperties((long)categoryId);
            for (AssetCategoryProperty categoryProperty : categoryProperties) {
                result = StringUtil.replace((String)result, (String)("[$" + categoryProperty.getKey() + "$]"), (String)categoryProperty.getValue());
            }
        }
        return StringUtil.stripBetween((String)result, (String)"[$", (String)"$]");
    }

    public static String toWord(String text) {
        if (Validator.isNull((String)text)) {
            return text;
        }
        char[] textCharArray = text.toCharArray();
        block0: for (int i = 0; i < textCharArray.length; ++i) {
            char c = textCharArray[i];
            for (char invalidChar : INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                textCharArray[i] = 32;
                continue block0;
            }
        }
        return new String(textCharArray);
    }

    protected static AssetSearcher getAssetSearcher(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        String paginationType;
        Indexer<?> searcher = AssetSearcher.getInstance();
        AssetSearcher assetSearcher = (AssetSearcher)searcher;
        assetSearcher.setAssetEntryQuery(assetEntryQuery);
        Layout layout = assetEntryQuery.getLayout();
        if (layout != null) {
            searchContext.setAttribute("layoutUuid", (Serializable)((Object)layout.getUuid()));
        }
        String ddmStructureFieldName = (String)((Object)assetEntryQuery.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = assetEntryQuery.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            searchContext.setAttribute("ddmStructureFieldName", (Serializable)((Object)ddmStructureFieldName));
            searchContext.setAttribute("ddmStructureFieldValue", ddmStructureFieldValue);
        }
        if (!(paginationType = GetterUtil.getString((String)assetEntryQuery.getPaginationType(), (String)"more")).equals("none") && !paginationType.equals("simple")) {
            searchContext.setAttribute("paginationType", (Serializable)((Object)paginationType));
        }
        searchContext.setClassTypeIds(assetEntryQuery.getClassTypeIds());
        searchContext.setEnd(end);
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        if (Validator.isNull((String)assetEntryQuery.getKeywords())) {
            QueryConfig queryConfig = searchContext.getQueryConfig();
            queryConfig.setScoreEnabled(false);
        } else {
            searchContext.setLike(true);
        }
        searchContext.setSorts(AssetUtil.getSorts(assetEntryQuery, searchContext.getLocale()));
        searchContext.setStart(start);
        return assetSearcher;
    }

    protected static String getDDMFormFieldType(String sortField) throws PortalException {
        String[] sortFields = sortField.split("__");
        long ddmStructureId = GetterUtil.getLong((String)sortFields[2]);
        String fieldName = sortFields[3];
        DDMStructure ddmStructure = DDMStructureManagerUtil.getStructure((long)ddmStructureId);
        return ddmStructure.getFieldType(fieldName);
    }

    protected static String getOrderByCol(String sortField, String fieldType, int sortType, Locale locale) {
        if (sortField.startsWith("ddm__")) {
            StringBundler sb = new StringBundler(5);
            sb.append(sortField);
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
            sb.append("_");
            String suffix = "String";
            if (!(fieldType.equals("ddm-date") || sortType != 7 && sortType != 5 && sortType != 4 && sortType != 6)) {
                suffix = "Number";
            }
            sb.append(suffix);
            sortField = Field.getSortableFieldName((String)sb.toString());
        } else if (sortField.equals("modifiedDate")) {
            sortField = "modified";
        } else if (sortField.equals("title")) {
            sortField = Field.getSortableFieldName((String)"localized_title_".concat(LocaleUtil.toLanguageId((Locale)locale)));
        }
        return sortField;
    }

    protected static Sort getSort(String orderByType, String sortField, Locale locale) throws Exception {
        String ddmFormFieldType = sortField;
        if (ddmFormFieldType.startsWith("ddm__")) {
            ddmFormFieldType = AssetUtil.getDDMFormFieldType(ddmFormFieldType);
        }
        int sortType = AssetUtil.getSortType(ddmFormFieldType);
        return SortFactoryUtil.getSort(AssetEntry.class, (int)sortType, (String)AssetUtil.getOrderByCol(sortField, ddmFormFieldType, sortType, locale), (!sortField.startsWith("ddm__") ? 1 : 0) != 0, (String)orderByType);
    }

    protected static Sort[] getSorts(AssetEntryQuery assetEntryQuery, Locale locale) throws Exception {
        Sort sort1 = AssetUtil.getSort(assetEntryQuery.getOrderByType1(), assetEntryQuery.getOrderByCol1(), locale);
        Sort sort2 = AssetUtil.getSort(assetEntryQuery.getOrderByType2(), assetEntryQuery.getOrderByCol2(), locale);
        return new Sort[]{sort1, sort2};
    }

    protected static int getSortType(String fieldType) {
        int sortType = 3;
        if (fieldType.equals("createDate") || fieldType.equals("expirationDate") || fieldType.equals("publishDate") || fieldType.equals("ddm-date") || fieldType.equals("modifiedDate")) {
            sortType = 6;
        } else if (fieldType.equals("priority") || fieldType.equals("ddm-decimal") || fieldType.equals("ddm-number")) {
            sortType = 7;
        } else if (fieldType.equals("ddm-integer")) {
            sortType = 4;
        }
        return sortType;
    }
}

