/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.FolderIndexer;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@Deprecated
public class DLFolderIndexer
extends BaseIndexer<DLFolder>
implements FolderIndexer {
    public static final String CLASS_NAME = DLFolder.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(DLFolderIndexer.class);
    private static volatile ModelResourcePermission<DLFolder> _dlFolderModelResourcePermission = (ModelResourcePermission)ServiceProxyFactory.newServiceTrackedInstance(ModelResourcePermission.class, DLFolderIndexer.class, (String)"_dlFolderModelResourcePermission", (String)("(model.class.name=" + DLFolder.class.getName() + ")"), (boolean)true);

    public DLFolderIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "description", "entryClassName", "entryClassPK", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String[] getFolderClassNames() {
        return new String[]{CLASS_NAME};
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return _dlFolderModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
        contextBooleanFilter.addRequiredTerm("hidden", false);
    }

    protected void doDelete(DLFolder dlFolder) throws Exception {
        this.deleteDocument(dlFolder.getCompanyId(), dlFolder.getFolderId());
    }

    protected Document doGetDocument(DLFolder dlFolder) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing folder " + dlFolder));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)dlFolder);
        document.addText("description", dlFolder.getDescription());
        document.addKeyword("folderId", dlFolder.getParentFolderId());
        document.addKeyword("hidden", dlFolder.isHidden() || dlFolder.isInHiddenFolder());
        String title = dlFolder.getName();
        if (dlFolder.isInTrash()) {
            title = TrashUtil.getOriginalTitle((String)title);
        }
        document.addText("title", title);
        document.addKeyword("treePath", dlFolder.getTreePath());
        document.addKeyword("treePath", StringUtil.split((String)dlFolder.getTreePath(), (char)'/'));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + dlFolder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(DLFolder dlFolder) throws Exception {
        if (!dlFolder.isApproved() && !dlFolder.isInTrash()) {
            return;
        }
        Document document = this.getDocument(dlFolder);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)dlFolder.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)classPK);
        this.doReindex(dlFolder);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
    }

    protected void reindexFolders(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = DLFolderLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"mountPoint");
                dynamicQuery.add(property.eq((Object)false));
            }
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFolder>(){

            public void performAction(DLFolder dlFolder) {
                block2: {
                    try {
                        Document document = DLFolderIndexer.this.getDocument(dlFolder);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index document library folder " + dlFolder.getFolderId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

