/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portlet.exportimport.service.base.ExportImportServiceBaseImpl;
import java.io.File;
import java.io.InputStream;
import java.util.Map;

public class ExportImportServiceImpl
extends ExportImportServiceBaseImpl {
    public File exportLayoutsAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)sourceGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.exportImportLocalService.exportLayoutsAsFile(exportImportConfiguration);
    }

    @Deprecated
    public File exportLayoutsAsFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.exportImportLocalService.exportLayoutsAsFile(userId, groupId, privateLayout, parameterMap);
    }

    public long exportLayoutsAsFileInBackground(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)exportImportConfiguration.getGroupId(), (String)"EXPORT_IMPORT_LAYOUTS");
        return this.exportImportLocalService.exportLayoutsAsFileInBackground(this.getUserId(), exportImportConfiguration);
    }

    public long exportLayoutsAsFileInBackground(long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)exportImportConfiguration.getGroupId(), (String)"EXPORT_IMPORT_LAYOUTS");
        return this.exportImportLocalService.exportLayoutsAsFileInBackground(this.getUserId(), exportImportConfigurationId);
    }

    public File exportPortletInfoAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourcePlid = MapUtil.getLong((Map)settingsMap, (String)"sourcePlid");
        Layout layout = this.layoutLocalService.getLayout(sourcePlid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.exportImportLocalService.exportPortletInfoAsFile(exportImportConfiguration);
    }

    public long exportPortletInfoAsFileInBackground(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourcePlid = MapUtil.getLong((Map)settingsMap, (String)"sourcePlid");
        Layout layout = this.layoutLocalService.getLayout(sourcePlid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.exportImportLocalService.exportPortletInfoAsFileInBackground(this.getUserId(), exportImportConfiguration);
    }

    public void importLayouts(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.exportImportLocalService.importLayouts(exportImportConfiguration, file);
    }

    public void importLayouts(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.exportImportLocalService.importLayouts(exportImportConfiguration, inputStream);
    }

    @Deprecated
    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.exportImportLocalService.importLayouts(userId, groupId, privateLayout, parameterMap, file);
    }

    public long importLayoutsInBackground(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.exportImportLocalService.importLayoutsInBackground(this.getUserId(), exportImportConfiguration, file);
    }

    public long importLayoutsInBackground(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.exportImportLocalService.importLayoutsInBackground(this.getUserId(), exportImportConfiguration, inputStream);
    }

    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.exportImportLocalService.importPortletInfo(exportImportConfiguration, file);
    }

    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.exportImportLocalService.importPortletInfo(exportImportConfiguration, inputStream);
    }

    public long importPortletInfoInBackground(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.exportImportLocalService.importPortletInfoInBackground(this.getUserId(), exportImportConfiguration, file);
    }

    public long importPortletInfoInBackground(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.exportImportLocalService.importPortletInfoInBackground(this.getUserId(), exportImportConfiguration, inputStream);
    }

    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.exportImportLocalService.validateImportLayoutsFile(exportImportConfiguration, file);
    }

    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.exportImportLocalService.validateImportLayoutsFile(exportImportConfiguration, inputStream);
    }

    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetPlid, (String)portletId, (String)"CONFIGURATION");
        return this.exportImportLocalService.validateImportPortletInfo(exportImportConfiguration, file);
    }

    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetPlid, (String)portletId, (String)"CONFIGURATION");
        return this.exportImportLocalService.validateImportPortletInfo(exportImportConfiguration, inputStream);
    }
}

