/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.internal.CacheControlImpl;
import com.liferay.portlet.internal.PortletResponseImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.portlet.MimeResponse;
import javax.portlet.WindowState;

public abstract class MimeResponseImpl
extends PortletResponseImpl
implements MimeResponse {
    private boolean _calledFlushBuffer;
    private boolean _calledGetPortletOutputStream;
    private boolean _calledGetWriter;
    private String _contentType;

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
        this._calledFlushBuffer = true;
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public CacheControl getCacheControl() {
        Portlet portlet = this.getPortlet();
        int expirationTime = 0;
        Integer expCache = portlet.getExpCache();
        if (expCache != null) {
            expirationTime = expCache;
        }
        return new CacheControlImpl(null, expirationTime, false, false, this);
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public String getContentType() {
        return this._contentType;
    }

    public Locale getLocale() {
        return this.portletRequestImpl.getLocale();
    }

    public OutputStream getPortletOutputStream() throws IllegalStateException, IOException {
        if (this._calledGetWriter) {
            throw new IllegalStateException("Unable to obtain OutputStream because Writer is already in use");
        }
        if (this._contentType == null) {
            this.setContentType(this.portletRequestImpl.getResponseContentType());
        }
        this._calledGetPortletOutputStream = true;
        return this.response.getOutputStream();
    }

    public PrintWriter getWriter() throws IllegalStateException, IOException {
        if (this._calledGetPortletOutputStream) {
            throw new IllegalStateException("Unable to obtain Writer because OutputStream is already in use");
        }
        if (this._contentType == null) {
            this.setContentType(this.portletRequestImpl.getResponseContentType());
        }
        this._calledGetWriter = true;
        return this.response.getWriter();
    }

    public boolean isCalledFlushBuffer() {
        return this._calledFlushBuffer;
    }

    public boolean isCalledGetPortletOutputStream() {
        return this._calledGetPortletOutputStream;
    }

    public boolean isCalledGetWriter() {
        return this._calledGetWriter;
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        if (this._calledFlushBuffer) {
            throw new IllegalStateException("Unable to reset a buffer that has been flushed");
        }
    }

    public void resetBuffer() {
        if (this._calledFlushBuffer) {
            throw new IllegalStateException("Unable to reset a buffer that has been flushed");
        }
        this.response.resetBuffer();
    }

    public void setBufferSize(int bufferSize) {
        this.response.setBufferSize(bufferSize);
    }

    public void setContentType(String contentType) {
        if (this._calledGetPortletOutputStream || this._calledGetWriter) {
            return;
        }
        if (Validator.isNull((String)contentType)) {
            throw new IllegalArgumentException("Content type is null");
        }
        String lifecycle = this.getLifecycle();
        WindowState windowState = this.portletRequestImpl.getWindowState();
        if (!(contentType.startsWith(this.portletRequestImpl.getResponseContentType()) || lifecycle.equals("RESOURCE_PHASE") || windowState.equals((Object)LiferayWindowState.EXCLUSIVE))) {
            throw new IllegalArgumentException(contentType + " is an unsupported content type");
        }
        this._contentType = contentType;
        this.response.setContentType(contentType);
    }
}

