/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletSession;
import com.liferay.portal.kernel.servlet.HttpSessionWrapper;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletSessionAttributeMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpSession;

public class PortletSessionImpl
implements LiferayPortletSession {
    protected final PortletContext portletContext;
    protected final String scopePrefix;
    protected HttpSession session;
    private boolean _invalidated;

    public PortletSessionImpl(HttpSession session, PortletContext portletContext, String portletName, long plid) {
        this.session = this._wrapHttpSession(session);
        this.portletContext = portletContext;
        StringBundler sb = new StringBundler(5);
        sb.append("javax.portlet.p.");
        sb.append(portletName);
        sb.append("_LAYOUT_");
        sb.append(plid);
        sb.append("?");
        this.scopePrefix = sb.toString();
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._invalidated) {
            throw new IllegalStateException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        return this.session.getAttribute(name);
    }

    public Map<String, Object> getAttributeMap() {
        return this.getAttributeMap(2);
    }

    public Map<String, Object> getAttributeMap(int scope) {
        if (scope == 2) {
            return new PortletSessionAttributeMap(this.session, this.scopePrefix);
        }
        return new PortletSessionAttributeMap(this.session);
    }

    public Enumeration<String> getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public Enumeration<String> getAttributeNames(int scope) {
        if (scope != 2) {
            return this.session.getAttributeNames();
        }
        ArrayList<String> attributeNames = new ArrayList<String>();
        Enumeration enu = this.session.getAttributeNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(this.scopePrefix)) continue;
            name = name.substring(this.scopePrefix.length());
            attributeNames.add(name);
        }
        return Collections.enumeration(attributeNames);
    }

    public long getCreationTime() {
        if (this._invalidated) {
            throw new IllegalStateException();
        }
        return this.session.getCreationTime();
    }

    public HttpSession getHttpSession() {
        return this.session;
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void invalidate() {
        this._invalidated = true;
        this.session.invalidate();
    }

    public boolean isInvalidated() {
        return this._invalidated;
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        this.session.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        this.session.setAttribute(name, value);
    }

    public void setHttpSession(HttpSession session) {
        this.session = this._wrapHttpSession(session);
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    private HttpSession _wrapHttpSession(HttpSession session) {
        if (PropsValues.PORTLET_SESSION_REPLICATE_ENABLED && !(session instanceof SerializableHttpSessionWrapper)) {
            return new SerializableHttpSessionWrapper(session);
        }
        return session;
    }

    private static class SerializableHttpSessionWrapper
    extends HttpSessionWrapper {
        public Object getAttribute(String name) {
            Object value = super.getAttribute(name);
            if (value instanceof LazySerializableObjectWrapper) {
                LazySerializableObjectWrapper lazySerializableObjectWrapper = (LazySerializableObjectWrapper)value;
                return lazySerializableObjectWrapper.getSerializable();
            }
            return value;
        }

        public void setAttribute(String name, Object value) {
            if (!(value instanceof Serializable)) {
                super.setAttribute(name, value);
                return;
            }
            Class<?> clazz = value.getClass();
            if (!PortalClassLoaderUtil.isPortalClassLoader((ClassLoader)clazz.getClassLoader())) {
                value = new LazySerializableObjectWrapper((Serializable)value);
            }
            super.setAttribute(name, value);
        }

        private SerializableHttpSessionWrapper(HttpSession session) {
            super(session);
        }
    }

    private static class LazySerializableObjectWrapper
    implements Externalizable {
        private volatile Serializable _serializable;

        public LazySerializableObjectWrapper() {
        }

        public Serializable getSerializable() {
            if (this._serializable instanceof LazySerializable) {
                LazySerializable lazySerializable = (LazySerializable)this._serializable;
                Serializable serializable = lazySerializable.getSerializable();
                if (serializable == null) {
                    return null;
                }
                this._serializable = serializable;
            }
            return this._serializable;
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException {
            byte[] data = new byte[objectInput.readInt()];
            objectInput.readFully(data);
            this._serializable = new LazySerializable(data);
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            byte[] data = this._getData();
            objectOutput.writeInt(data.length);
            objectOutput.write(data, 0, data.length);
        }

        private LazySerializableObjectWrapper(Serializable serializable) {
            this._serializable = serializable;
        }

        private byte[] _getData() {
            if (this._serializable instanceof LazySerializable) {
                LazySerializable lazySerializable = (LazySerializable)this._serializable;
                return lazySerializable.getData();
            }
            Serializer serializer = new Serializer();
            serializer.writeObject(this._serializable);
            ByteBuffer byteBuffer = serializer.toByteBuffer();
            return byteBuffer.array();
        }
    }

    private static class LazySerializable
    implements Serializable {
        private static final Log _log = LogFactoryUtil.getLog(LazySerializable.class);
        private final byte[] _data;

        public byte[] getData() {
            return this._data;
        }

        public Serializable getSerializable() {
            Deserializer deserializer = new Deserializer(ByteBuffer.wrap(this._data));
            try {
                return deserializer.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                _log.error((Object)"Unable to deserialize object", (Throwable)cnfe);
                return null;
            }
        }

        private LazySerializable(byte[] data) {
            this._data = data;
        }
    }
}

