/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.util;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.exportimport.kernel.service.ExportImportServiceUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.persistence.LayoutSetUtil;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.sites.kernel.util.Sites;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SitesImpl
implements Sites {
    private static final String _TEMP_DIR = SystemProperties.get((String)"java.io.tmpdir") + "/liferay/layout_set_prototype/";
    private static final Log _log = LogFactoryUtil.getLog(SitesImpl.class);

    public void addMergeFailFriendlyURLLayout(Layout layout) throws PortalException {
        LayoutSet layoutSet = layout.getLayoutSet();
        layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout());
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        String mergeFailFriendlyURLLayouts = settingsProperties.getProperty("merge-fail-friendly-url-layouts", "");
        mergeFailFriendlyURLLayouts = StringUtil.add((String)mergeFailFriendlyURLLayouts, (String)layout.getUuid());
        settingsProperties.setProperty("merge-fail-friendly-url-layouts", mergeFailFriendlyURLLayouts);
        LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
    }

    public void addPortletBreadcrumbEntries(Group group, HttpServletRequest request, PortletURL portletURL) throws Exception {
        List ancestorGroups = group.getAncestors();
        Collections.reverse(ancestorGroups);
        for (Group ancestorGroup : ancestorGroups) {
            portletURL.setParameter("groupId", String.valueOf(ancestorGroup.getGroupId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorGroup.getDescriptiveName(), (String)portletURL.toString());
        }
        Group unescapedGroup = group.toUnescapedModel();
        portletURL.setParameter("groupId", String.valueOf(unescapedGroup.getGroupId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedGroup.getDescriptiveName(), (String)portletURL.toString());
    }

    public void addPortletBreadcrumbEntries(Group group, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        PortletURL portletURL = renderResponse.createRenderURL();
        this.addPortletBreadcrumbEntries(group, request, portletURL);
    }

    public void addPortletBreadcrumbEntries(Group group, String pagesName, PortletURL redirectURL, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (renderResponse == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group unescapedGroup = group.toUnescapedModel();
        Locale locale = themeDisplay.getLocale();
        if (group.isLayoutPrototype()) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)LanguageUtil.get((Locale)locale, (String)"page-template"), null);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedGroup.getDescriptiveName(), (String)redirectURL.toString());
        } else {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedGroup.getDescriptiveName(), null);
        }
        if (!group.isLayoutPrototype()) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)LanguageUtil.get((Locale)locale, (String)pagesName), (String)redirectURL.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyLayoutPrototype(LayoutPrototype layoutPrototype, Layout targetLayout, boolean linkEnabled) throws Exception {
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        LayoutTypePortlet targetLayoutType = (LayoutTypePortlet)targetLayout.getLayoutType();
        List targetLayoutPortletIds = targetLayoutType.getPortletIds();
        Layout layoutPrototypeLayout = layoutPrototype.getLayout();
        byte[] iconBytes = null;
        if (layoutPrototypeLayout.isIconImage()) {
            Image image = ImageLocalServiceUtil.getImage((long)layoutPrototypeLayout.getIconImageId());
            iconBytes = image.getTextObj();
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)Boolean.valueOf(linkEnabled));
        serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
        try {
            Locale targetSiteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)targetLayout.getGroupId());
            LocaleThreadLocal.setSiteDefaultLocale((Locale)targetSiteDefaultLocale);
            targetLayout = LayoutLocalServiceUtil.updateLayout((long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId(), (long)targetLayout.getParentLayoutId(), (Map)targetLayout.getNameMap(), (Map)targetLayout.getTitleMap(), (Map)targetLayout.getDescriptionMap(), (Map)targetLayout.getKeywordsMap(), (Map)targetLayout.getRobotsMap(), (String)layoutPrototypeLayout.getType(), (boolean)targetLayout.isHidden(), (Map)targetLayout.getFriendlyURLMap(), (boolean)layoutPrototypeLayout.isIconImage(), (byte[])iconBytes, (ServiceContext)serviceContext);
        }
        finally {
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
        targetLayout = LayoutLocalServiceUtil.updateLayout((long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId(), (String)layoutPrototypeLayout.getTypeSettings());
        this.copyPortletPermissions(targetLayout, layoutPrototypeLayout);
        this.copyPortletSetups(layoutPrototypeLayout, targetLayout);
        this.copyLookAndFeel(targetLayout, layoutPrototypeLayout);
        this.deleteUnreferencedPortlets(targetLayoutPortletIds, targetLayout, layoutPrototypeLayout);
        targetLayout = LayoutLocalServiceUtil.getLayout((long)targetLayout.getPlid());
        UnicodeProperties typeSettingsProperties = targetLayout.getTypeSettingsProperties();
        Date modifiedDate = targetLayout.getModifiedDate();
        typeSettingsProperties.setProperty("last-merge-time", String.valueOf(modifiedDate.getTime()));
        LayoutLocalServiceUtil.updateLayout((Layout)targetLayout);
        UnicodeProperties prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        prototypeTypeSettingsProperties.setProperty("merge-fail-count", "0");
        LayoutLocalServiceUtil.updateLayout((Layout)layoutPrototypeLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyLayout(long userId, Layout sourceLayout, Layout targetLayout, ServiceContext serviceContext) throws Exception {
        User user = UserLocalServiceUtil.getUser((long)userId);
        Map<String, String[]> parameterMap = this.getLayoutSetPrototypeParameters(serviceContext);
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        Map exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap((User)user, (long)sourceLayout.getGroupId(), (boolean)sourceLayout.isPrivateLayout(), (long[])new long[]{sourceLayout.getLayoutId()}, parameterMap);
        ExportImportConfiguration exportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration((long)user.getUserId(), (int)0, (Map)exportLayoutSettingsMap);
        File file = ExportImportLocalServiceUtil.exportLayoutsAsFile((ExportImportConfiguration)exportConfiguration);
        try {
            Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((long)userId, (long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), null, parameterMap, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
            ExportImportConfiguration importConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration((long)userId, (int)6, (Map)importLayoutSettingsMap);
            ExportImportLocalServiceUtil.importLayouts((ExportImportConfiguration)importConfiguration, (File)file);
        }
        finally {
            file.delete();
        }
    }

    public void copyLookAndFeel(Layout targetLayout, Layout sourceLayout) throws Exception {
        LayoutLocalServiceUtil.updateLookAndFeel((long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId(), (String)sourceLayout.getThemeId(), (String)sourceLayout.getColorSchemeId(), (String)sourceLayout.getCss());
    }

    public void copyPortletPermissions(Layout targetLayout, Layout sourceLayout) throws Exception {
        List roles = RoleLocalServiceUtil.getGroupRelatedRoles((long)targetLayout.getGroupId());
        Group targetGroup = targetLayout.getGroup();
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List sourcePortletIds = sourceLayoutTypePortlet.getPortletIds();
        for (String sourcePortletId : sourcePortletIds) {
            String resourceName = PortletIdCodec.decodePortletName((String)sourcePortletId);
            String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)sourceLayout.getPlid(), (String)sourcePortletId);
            String targetResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)targetLayout.getPlid(), (String)sourcePortletId);
            List actionIds = ResourceActionsUtil.getPortletResourceActions((String)resourceName);
            for (Role role : roles) {
                String roleName = role.getName();
                if (roleName.equals("Administrator") || !targetGroup.isLayoutSetPrototype() && targetLayout.isPrivateLayout() && roleName.equals("Guest")) continue;
                List actions = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)targetLayout.getCompanyId(), (String)resourceName, (int)4, (String)sourceResourcePrimKey, (long)role.getRoleId(), (Collection)actionIds);
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)targetLayout.getCompanyId(), (String)resourceName, (int)4, (String)targetResourcePrimKey, (long)role.getRoleId(), (String[])actions.toArray(new String[actions.size()]));
            }
        }
    }

    public void copyPortletSetups(Layout sourceLayout, Layout targetLayout) throws Exception {
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List sourcePortletIds = sourceLayoutTypePortlet.getPortletIds();
        for (String sourcePortletId : sourcePortletIds) {
            PortletPreferences sourcePreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)sourceLayout, (String)sourcePortletId, null);
            PortletPreferencesImpl sourcePreferencesImpl = (PortletPreferencesImpl)sourcePreferences;
            PortletPreferences targetPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)targetLayout, (String)sourcePortletId, null);
            PortletPreferencesImpl targetPreferencesImpl = (PortletPreferencesImpl)targetPreferences;
            PortletPreferencesLocalServiceUtil.updatePreferences((long)targetPreferencesImpl.getOwnerId(), (int)targetPreferencesImpl.getOwnerType(), (long)targetPreferencesImpl.getPlid(), (String)sourcePortletId, (PortletPreferences)sourcePreferences);
            if (sourcePreferencesImpl.getOwnerId() != 0L && sourcePreferencesImpl.getOwnerType() != 3) {
                sourcePreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)sourceLayout, (String)sourcePortletId);
                sourcePreferencesImpl = (PortletPreferencesImpl)sourcePreferences;
                targetPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)targetLayout, (String)sourcePortletId);
                targetPreferencesImpl = (PortletPreferencesImpl)targetPreferences;
                PortletPreferencesLocalServiceUtil.updatePreferences((long)targetPreferencesImpl.getOwnerId(), (int)targetPreferencesImpl.getOwnerType(), (long)targetPreferencesImpl.getPlid(), (String)sourcePortletId, (PortletPreferences)sourcePreferences);
            }
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            this.updateLayoutScopes(serviceContext.getUserId(), sourceLayout, targetLayout, sourcePreferences, targetPreferences, sourcePortletId, serviceContext.getLanguageId());
        }
    }

    public void copyTypeSettings(Group sourceGroup, Group targetGroup) throws Exception {
        GroupServiceUtil.updateGroup((long)targetGroup.getGroupId(), (String)sourceGroup.getTypeSettings());
    }

    public Object[] deleteLayout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long selPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"selPlid");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
        Layout layout = null;
        if (selPlid <= 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        } else {
            layout = LayoutLocalServiceUtil.getLayout((long)selPlid);
            groupId = layout.getGroupId();
            privateLayout = layout.isPrivateLayout();
            layoutId = layout.getLayoutId();
        }
        Group group = layout.getGroup();
        String oldFriendlyURL = themeDisplay.getLayoutFriendlyURL(layout);
        if (group.isStagingGroup() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), group.getGroupId(), new String[]{"MANAGE_STAGING", "PUBLISH_STAGING"});
        }
        if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"DELETE")) {
            LayoutType layoutType = layout.getLayoutType();
            EventsProcessorUtil.process("layout.configuration.action.delete", layoutType.getConfigurationActionDelete(), request, response);
        }
        if (group.isGuest() && !layout.isPrivateLayout() && layout.isRootLayout() && LayoutLocalServiceUtil.getLayoutsCount((Group)group, (boolean)false, (long)0L) == 1) {
            throw new RequiredLayoutException(1);
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        LayoutServiceUtil.deleteLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (ServiceContext)serviceContext);
        return new Object[]{group, oldFriendlyURL, 0L};
    }

    public Object[] deleteLayout(PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        return this.deleteLayout(request, response);
    }

    public void deleteLayout(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
        this.deleteLayout(request, response);
    }

    public File exportLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, ServiceContext serviceContext) throws PortalException {
        BackgroundTask backgroundTask;
        User user = UserLocalServiceUtil.fetchUser((long)serviceContext.getUserId());
        if (user == null && (backgroundTask = BackgroundTaskManagerUtil.fetchBackgroundTask((long)BackgroundTaskThreadLocal.getBackgroundTaskId())) != null) {
            user = UserLocalServiceUtil.getUser((long)backgroundTask.getUserId());
        }
        if (user == null) {
            user = UserLocalServiceUtil.getUser((long)GetterUtil.getLong((String)PrincipalThreadLocal.getName()));
        }
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        List layoutSetPrototypeLayouts = LayoutLocalServiceUtil.getLayouts((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout());
        Map<String, String[]> parameterMap = this.getLayoutSetPrototypeParameters(serviceContext);
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.FALSE.toString()});
        Map exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap((User)user, (long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long[])ExportImportHelperUtil.getLayoutIds((List)layoutSetPrototypeLayouts), parameterMap);
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration((long)user.getUserId(), (int)0, (Map)exportLayoutSettingsMap);
        return ExportImportLocalServiceUtil.exportLayoutsAsFile((ExportImportConfiguration)exportImportConfiguration);
    }

    public Long[] filterGroups(List<Group> groups, String[] groupKeys) {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (Group group : groups) {
            if (ArrayUtil.contains((Object[])groupKeys, (Object)group.getGroupKey())) continue;
            groupIds.add(group.getGroupId());
        }
        return ArrayUtil.toArray((long[])ArrayUtil.toLongArray(groupIds));
    }

    public Layout getLayoutSetPrototypeLayout(Layout layout) {
        try {
            LayoutSet layoutSet = layout.getLayoutSet();
            if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                return null;
            }
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSet.getLayoutSetPrototypeUuid(), (long)layout.getCompanyId());
            return LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layout.getSourcePrototypeLayoutUuid(), (long)layoutSetPrototype.getGroupId(), (boolean)true);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to fetch the the layout set prototype's layout", (Throwable)e);
            return null;
        }
    }

    public Map<String, String[]> getLayoutSetPrototypeParameters(ServiceContext serviceContext) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_SETTINGS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"CREATED_FROM_PROTOTYPE"});
        parameterMap.put("LOGO", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        return parameterMap;
    }

    public int getMergeFailCount(LayoutPrototype layoutPrototype) throws PortalException {
        if (layoutPrototype == null || layoutPrototype.getLayoutPrototypeId() == 0L) {
            return 0;
        }
        Layout layoutPrototypeLayout = layoutPrototype.getLayout();
        UnicodeProperties prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        return GetterUtil.getInteger((String)prototypeTypeSettingsProperties.getProperty("merge-fail-count"));
    }

    public int getMergeFailCount(LayoutSetPrototype layoutSetPrototype) throws PortalException {
        if (layoutSetPrototype == null || layoutSetPrototype.getLayoutSetPrototypeId() == 0L) {
            return 0;
        }
        LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
        UnicodeProperties layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
        return GetterUtil.getInteger((String)layoutSetPrototypeSettingsProperties.getProperty("merge-fail-count"));
    }

    public List<Layout> getMergeFailFriendlyURLLayouts(LayoutSet layoutSet) throws PortalException {
        if (layoutSet == null) {
            return Collections.emptyList();
        }
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        String uuids = settingsProperties.getProperty("merge-fail-friendly-url-layouts");
        if (Validator.isNotNull((String)uuids)) {
            ArrayList<Layout> layouts = new ArrayList<Layout>();
            for (String uuid : StringUtil.split((String)uuids)) {
                Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)uuid, (long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout());
                layouts.add(layout);
            }
            return layouts;
        }
        return Collections.emptyList();
    }

    public List<String> getOrganizationNames(Group group, User user) throws Exception {
        List organizations = OrganizationLocalServiceUtil.getGroupUserOrganizations((long)group.getGroupId(), (long)user.getUserId());
        return ListUtil.toList((List)organizations, (Accessor)Organization.NAME_ACCESSOR);
    }

    public List<String> getUserGroupNames(Group group, User user) throws Exception {
        List userGroups = UserGroupLocalServiceUtil.getGroupUserUserGroups((long)group.getGroupId(), (long)user.getUserId());
        return ListUtil.toList((List)userGroups, (Accessor)UserGroup.NAME_ACCESSOR);
    }

    public void importLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        BackgroundTask backgroundTask;
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        Map<String, String[]> parameterMap = this.getLayoutSetPrototypeParameters(serviceContext);
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.FALSE.toString()});
        this.setLayoutSetPrototypeLinkEnabledParameter(parameterMap, layoutSet, serviceContext);
        User user = UserLocalServiceUtil.fetchUser((long)serviceContext.getUserId());
        if (user == null && (backgroundTask = BackgroundTaskManagerUtil.fetchBackgroundTask((long)BackgroundTaskThreadLocal.getBackgroundTaskId())) != null) {
            user = UserLocalServiceUtil.getUser((long)backgroundTask.getUserId());
        }
        if (user == null) {
            user = UserLocalServiceUtil.getUser((long)GetterUtil.getLong((String)PrincipalThreadLocal.getName()));
        }
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((long)user.getUserId(), (long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), null, parameterMap, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration((long)user.getUserId(), (int)6, (Map)importLayoutSettingsMap);
        ExportImportServiceUtil.importLayouts((ExportImportConfiguration)exportImportConfiguration, (InputStream)inputStream);
    }

    public boolean isContentSharingWithChildrenEnabled(Group group) {
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        int companyContentSharingEnabled = PrefsPropsUtil.getInteger((long)group.getCompanyId(), (String)"sites.content.sharing.with.children.enabled");
        if (companyContentSharingEnabled == 0) {
            return false;
        }
        int groupContentSharingEnabled = GetterUtil.getInteger((String)typeSettingsProperties.getProperty("contentSharingWithChildrenEnabled"), (int)-1);
        return groupContentSharingEnabled == 3 || companyContentSharingEnabled == 2 && groupContentSharingEnabled == -1;
    }

    public boolean isFirstLayout(long groupId, boolean privateLayout, long layoutId) {
        Layout firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)groupId, (boolean)privateLayout, (long)0L);
        return firstLayout != null && firstLayout.getLayoutId() == layoutId;
    }

    public boolean isLayoutDeleteable(Layout layout) {
        block6: {
            try {
                if (layout instanceof VirtualLayout) {
                    return false;
                }
                if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) {
                    return true;
                }
                LayoutSet layoutSet = layout.getLayoutSet();
                if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                    return true;
                }
                if (LayoutLocalServiceUtil.hasLayoutSetPrototypeLayout((String)layoutSet.getLayoutSetPrototypeUuid(), (long)layout.getCompanyId(), (String)layout.getSourcePrototypeLayoutUuid())) {
                    return false;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return true;
    }

    public boolean isLayoutModifiedSinceLastMerge(Layout layout) {
        if (layout == null || Validator.isNull((String)layout.getSourcePrototypeLayoutUuid()) || layout.isLayoutPrototypeLinkActive() || !this.isLayoutUpdateable(layout)) {
            return false;
        }
        long lastMergeTime = GetterUtil.getLong((String)layout.getTypeSettingsProperty("last-merge-time"));
        if (lastMergeTime == 0L) {
            return false;
        }
        Date existingLayoutModifiedDate = layout.getModifiedDate();
        return existingLayoutModifiedDate != null && existingLayoutModifiedDate.getTime() > lastMergeTime;
    }

    public boolean isLayoutSetMergeable(Group group, LayoutSet layoutSet) throws PortalException {
        LayoutSetPrototype layoutSetPrototype;
        Date modifiedDate;
        if (!layoutSet.isLayoutSetPrototypeLinkActive() || group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
            return false;
        }
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        long lastMergeTime = GetterUtil.getLong((String)settingsProperties.getProperty("last-merge-time"));
        if (lastMergeTime >= (modifiedDate = (layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSet.getLayoutSetPrototypeUuid(), (long)layoutSet.getCompanyId())).getModifiedDate()).getTime()) {
            return false;
        }
        LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
        UnicodeProperties layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
        int mergeFailCount = GetterUtil.getInteger((String)layoutSetPrototypeSettingsProperties.getProperty("merge-fail-count"));
        if (mergeFailCount > PropsValues.LAYOUT_SET_PROTOTYPE_MERGE_FAIL_THRESHOLD) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(6);
                sb.append("Merge not performed because the fail threshold ");
                sb.append("was reached for layoutSetPrototypeId ");
                sb.append(layoutSetPrototype.getLayoutSetPrototypeId());
                sb.append(" and layoutId ");
                sb.append(layoutSetPrototypeLayoutSet.getLayoutSetId());
                sb.append(". Update the count in the database to try again.");
                _log.warn((Object)sb.toString());
            }
            return false;
        }
        return true;
    }

    public boolean isLayoutSetPrototypeUpdateable(LayoutSet layoutSet) {
        block4: {
            if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                return true;
            }
            try {
                LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSet.getLayoutSetPrototypeUuid(), (long)layoutSet.getCompanyId());
                String layoutsUpdateable = layoutSetPrototype.getSettingsProperty("layoutsUpdateable");
                if (Validator.isNotNull((String)layoutsUpdateable)) {
                    return GetterUtil.getBoolean((String)layoutsUpdateable, (boolean)true);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return true;
    }

    public boolean isLayoutSortable(Layout layout) {
        return this.isLayoutDeleteable(layout);
    }

    public boolean isLayoutUpdateable(Layout layout) {
        block7: {
            try {
                if (layout instanceof VirtualLayout) {
                    return false;
                }
                if (Validator.isNull((String)layout.getLayoutPrototypeUuid()) && Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) {
                    return true;
                }
                LayoutSet layoutSet = layout.getLayoutSet();
                if (layoutSet.isLayoutSetPrototypeLinkActive()) {
                    boolean layoutSetPrototypeUpdateable = this.isLayoutSetPrototypeUpdateable(layoutSet);
                    if (!layoutSetPrototypeUpdateable) {
                        return false;
                    }
                    Layout layoutSetPrototypeLayout = this.getLayoutSetPrototypeLayout(layout);
                    String layoutUpdateable = layoutSetPrototypeLayout.getTypeSettingsProperty("layoutUpdateable");
                    if (Validator.isNull((String)layoutUpdateable)) {
                        return true;
                    }
                    return GetterUtil.getBoolean((String)layoutUpdateable);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return true;
    }

    public boolean isUserGroupLayout(Layout layout) throws PortalException {
        if (!(layout instanceof VirtualLayout)) {
            return false;
        }
        VirtualLayout virtualLayout = (VirtualLayout)layout;
        Layout sourceLayout = virtualLayout.getSourceLayout();
        Group sourceGroup = sourceLayout.getGroup();
        return sourceGroup.isUserGroup();
    }

    public boolean isUserGroupLayoutSetViewable(PermissionChecker permissionChecker, Group userGroupGroup) throws PortalException {
        if (!userGroupGroup.isUserGroup()) {
            return false;
        }
        if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)userGroupGroup, (String)"VIEW")) {
            return true;
        }
        UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)userGroupGroup.getClassPK());
        return UserLocalServiceUtil.hasUserGroupUser((long)userGroup.getUserGroupId(), (long)permissionChecker.getUserId());
    }

    public void mergeLayoutPrototypeLayout(Group group, Layout layout) throws Exception {
        Group layoutSetPrototypeGroup;
        Layout sourcePrototypeLayout;
        String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
        if (Validator.isNull((String)sourcePrototypeLayoutUuid)) {
            this.doMergeLayoutPrototypeLayout(group, layout);
            return;
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        long layoutSetPrototypeId = layoutSet.getLayoutSetPrototypeId();
        if (layoutSetPrototypeId > 0L && (sourcePrototypeLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)sourcePrototypeLayoutUuid, (long)(layoutSetPrototypeGroup = GroupLocalServiceUtil.getLayoutSetPrototypeGroup((long)layout.getCompanyId(), (long)layoutSetPrototypeId)).getGroupId(), (boolean)true)) != null) {
            this.doMergeLayoutPrototypeLayout(layoutSetPrototypeGroup, sourcePrototypeLayout);
        }
        this.doMergeLayoutPrototypeLayout(group, layout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeLayoutSetPrototypeLayouts(Group group, LayoutSet layoutSet) throws Exception {
        String owner;
        int mergeFailCount;
        UnicodeProperties layoutSetPrototypeSettingsProperties;
        LayoutSet layoutSetPrototypeLayoutSet;
        LayoutSetPrototype layoutSetPrototype;
        long lastMergeTime;
        UnicodeProperties settingsProperties;
        block12: {
            if (!this.isLayoutSetMergeable(group, layoutSet)) {
                return;
            }
            settingsProperties = layoutSet.getSettingsProperties();
            lastMergeTime = GetterUtil.getLong((String)settingsProperties.getProperty("last-merge-time"));
            layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSet.getLayoutSetPrototypeUuid(), (long)layoutSet.getCompanyId());
            layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
            layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
            mergeFailCount = GetterUtil.getInteger((String)layoutSetPrototypeSettingsProperties.getProperty("merge-fail-count"));
            owner = PortalUUIDUtil.generate();
            try {
                Lock lock = LockManagerUtil.lock((String)SitesImpl.class.getName(), (String)String.valueOf(layoutSet.getLayoutSetId()), (String)owner);
                if (owner.equals(lock.getOwner())) break block12;
                Date createDate = lock.getCreateDate();
                if (System.currentTimeMillis() - createDate.getTime() >= PropsValues.LAYOUT_SET_PROTOTYPE_MERGE_LOCK_MAX_TIME) {
                    lock = LockManagerUtil.lock((String)SitesImpl.class.getName(), (String)String.valueOf(layoutSet.getLayoutSetId()), (String)lock.getOwner(), (String)owner);
                    if (!owner.equals(lock.getOwner())) {
                        return;
                    }
                    break block12;
                }
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
            boolean importData = true;
            long lastResetTime = GetterUtil.getLong((String)settingsProperties.getProperty("last-reset-time"));
            if (lastMergeTime > 0L || lastResetTime > 0L) {
                importData = false;
            }
            Map<String, String[]> parameterMap = this.getLayoutSetPrototypesParameters(importData);
            layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSet.getLayoutSetId());
            this.removeMergeFailFriendlyURLLayouts(layoutSet);
            this.importLayoutSetPrototype(layoutSetPrototype, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parameterMap, importData);
        }
        catch (Exception e) {
            ++mergeFailCount;
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(6);
                sb.append("Merge fail count increased to ");
                sb.append(mergeFailCount);
                sb.append(" for layout set prototype ");
                sb.append(layoutSetPrototype.getLayoutSetPrototypeId());
                sb.append(" and layout set ");
                sb.append(layoutSet.getLayoutSetId());
                _log.warn((Object)sb.toString(), (Throwable)e);
            }
            layoutSetPrototypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(mergeFailCount));
            LayoutSetUtil.updateImpl((LayoutSet)layoutSetPrototypeLayoutSet);
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
            LockManagerUtil.unlock((String)SitesImpl.class.getName(), (String)String.valueOf(layoutSet.getLayoutSetId()), (String)owner);
        }
    }

    public void removeMergeFailFriendlyURLLayouts(LayoutSet layoutSet) {
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        settingsProperties.remove((Object)"merge-fail-friendly-url-layouts");
        LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
    }

    public void resetPrototype(Layout layout) throws PortalException {
        this.checkResetPrototypePermissions(layout.getGroup(), layout);
        this.doResetPrototype(layout);
    }

    public void resetPrototype(LayoutSet layoutSet) throws PortalException {
        this.checkResetPrototypePermissions(layoutSet.getGroup(), null);
        this.doResetPrototype(layoutSet);
    }

    public void setMergeFailCount(LayoutPrototype layoutPrototype, int newMergeFailCount) throws PortalException {
        Layout layoutPrototypeLayout = layoutPrototype.getLayout();
        UnicodeProperties prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        if (newMergeFailCount == 0) {
            prototypeTypeSettingsProperties.remove((Object)"merge-fail-count");
        } else {
            prototypeTypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(newMergeFailCount));
        }
        LayoutServiceUtil.updateLayout((long)layoutPrototypeLayout.getGroupId(), (boolean)layoutPrototypeLayout.isPrivateLayout(), (long)layoutPrototypeLayout.getLayoutId(), (String)layoutPrototypeLayout.getTypeSettings());
    }

    public void setMergeFailCount(LayoutSetPrototype layoutSetPrototype, int newMergeFailCount) throws PortalException {
        LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
        UnicodeProperties layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
        if (newMergeFailCount == 0) {
            layoutSetPrototypeSettingsProperties.remove((Object)"merge-fail-count");
        } else {
            layoutSetPrototypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(newMergeFailCount));
        }
        LayoutSetServiceUtil.updateSettings((long)layoutSetPrototypeLayoutSet.getGroupId(), (boolean)layoutSetPrototypeLayoutSet.isPrivateLayout(), (String)layoutSetPrototypeLayoutSet.getSettings());
    }

    public void updateLayoutScopes(long userId, Layout sourceLayout, Layout targetLayout, PortletPreferences sourcePreferences, PortletPreferences targetPreferences, String sourcePortletId, String languageId) throws Exception {
        String scopeType = GetterUtil.getString((String)sourcePreferences.getValue("lfrScopeType", null));
        if (Validator.isNull((String)scopeType) || !scopeType.equals("layout")) {
            return;
        }
        Layout targetScopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)targetLayout.getUuid(), (long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout());
        if (!targetScopeLayout.hasScopeGroup()) {
            GroupLocalServiceUtil.addGroup((long)userId, (long)0L, (String)Layout.class.getName(), (long)targetLayout.getPlid(), (long)0L, (Map)targetLayout.getNameMap(), null, (int)0, (boolean)true, (int)0, null, (boolean)false, (boolean)true, null);
        }
        String portletTitle = PortalUtil.getPortletTitle((String)PortletIdCodec.decodePortletName((String)sourcePortletId), (String)languageId);
        String newPortletTitle = PortalUtil.getNewPortletTitle((String)portletTitle, (String)String.valueOf(sourceLayout.getLayoutId()), (String)targetLayout.getName(languageId));
        targetPreferences.setValue("groupId", String.valueOf(targetLayout.getGroupId()));
        targetPreferences.setValue("lfrScopeType", "layout");
        targetPreferences.setValue("lfrScopeLayoutUuid", targetLayout.getUuid());
        targetPreferences.setValue("portletSetupTitle_" + languageId, newPortletTitle);
        targetPreferences.setValue("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        targetPreferences.store();
    }

    public void updateLayoutSetPrototypesLinks(Group group, long publicLayoutSetPrototypeId, long privateLayoutSetPrototypeId, boolean publicLayoutSetPrototypeLinkEnabled, boolean privateLayoutSetPrototypeLinkEnabled) throws Exception {
        this.updateLayoutSetPrototypeLink(group.getGroupId(), true, privateLayoutSetPrototypeId, privateLayoutSetPrototypeLinkEnabled);
        this.updateLayoutSetPrototypeLink(group.getGroupId(), false, publicLayoutSetPrototypeId, publicLayoutSetPrototypeLinkEnabled);
    }

    protected void checkResetPrototypePermissions(Group group, Layout layout) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (layout != null && !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, layout.getName(), layout.getLayoutId(), new String[]{"UPDATE"});
        }
        if (!(GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"UPDATE") || group.isUser() && permissionChecker.getUserId() == group.getClassPK())) {
            throw new PrincipalException.MustHavePermission(permissionChecker, group.getName(), group.getGroupId(), new String[]{"UPDATE"});
        }
    }

    protected void deleteUnreferencedPortlets(List<String> targetLayoutPortletIds, Layout targetLayout, Layout sourceLayout) throws Exception {
        LayoutTypePortlet sourceLayoutType = (LayoutTypePortlet)sourceLayout.getLayoutType();
        ArrayList<String> unreferencedPortletIds = new ArrayList<String>(targetLayoutPortletIds);
        unreferencedPortletIds.removeAll(sourceLayoutType.getPortletIds());
        PortletLocalServiceUtil.deletePortlets((long)targetLayout.getCompanyId(), (String[])unreferencedPortletIds.toArray(new String[unreferencedPortletIds.size()]), (long)targetLayout.getPlid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMergeLayoutPrototypeLayout(Group group, Layout layout) throws Exception {
        String owner;
        int mergeFailCount;
        UnicodeProperties prototypeTypeSettingsProperties;
        LayoutPrototype layoutPrototype;
        Layout layoutPrototypeLayout;
        block13: {
            Date modifiedDate;
            if (!layout.isLayoutPrototypeLinkActive() || group.isLayoutPrototype() || group.hasStagingGroup()) {
                return;
            }
            long lastMergeTime = GetterUtil.getLong((String)layout.getTypeSettingsProperty("last-merge-time"));
            if (lastMergeTime >= (modifiedDate = (layoutPrototypeLayout = (layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layout.getLayoutPrototypeUuid(), (long)layout.getCompanyId())).getLayout()).getModifiedDate()).getTime()) {
                return;
            }
            prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
            mergeFailCount = GetterUtil.getInteger((String)prototypeTypeSettingsProperties.getProperty("merge-fail-count"));
            if (mergeFailCount > PropsValues.LAYOUT_PROTOTYPE_MERGE_FAIL_THRESHOLD) {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(6);
                    sb.append("Merge not performed because the fail threshold ");
                    sb.append("was reached for layoutPrototypeId ");
                    sb.append(layoutPrototype.getLayoutPrototypeId());
                    sb.append(" and layoutId ");
                    sb.append(layoutPrototypeLayout.getLayoutId());
                    sb.append(". Update the count in the database to try again.");
                    _log.warn((Object)sb.toString());
                }
                return;
            }
            owner = PortalUUIDUtil.generate();
            try {
                Lock lock = LockManagerUtil.lock((String)SitesImpl.class.getName(), (String)String.valueOf(layout.getPlid()), (String)owner);
                if (owner.equals(lock.getOwner())) break block13;
                Date createDate = lock.getCreateDate();
                if (System.currentTimeMillis() - createDate.getTime() >= PropsValues.LAYOUT_PROTOTYPE_MERGE_LOCK_MAX_TIME) {
                    lock = LockManagerUtil.lock((String)SitesImpl.class.getName(), (String)String.valueOf(layout.getPlid()), (String)lock.getOwner(), (String)owner);
                    if (!owner.equals(lock.getOwner())) {
                        return;
                    }
                    break block13;
                }
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
            this.applyLayoutPrototype(layoutPrototype, layout, true);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            prototypeTypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(++mergeFailCount));
            LayoutUtil.updateImpl((Layout)layoutPrototypeLayout);
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
            LockManagerUtil.unlock((String)SitesImpl.class.getName(), (String)String.valueOf(layout.getPlid()), (String)owner);
        }
    }

    protected void doResetPrototype(Layout layout) throws PortalException {
        layout.setModifiedDate(null);
        LayoutLocalServiceUtil.updateLayout((Layout)layout);
        LayoutSet layoutSet = layout.getLayoutSet();
        this.doResetPrototype(layoutSet);
    }

    protected void doResetPrototype(LayoutSet layoutSet) {
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        settingsProperties.remove((Object)"last-merge-time");
        settingsProperties.setProperty("last-reset-time", String.valueOf(System.currentTimeMillis()));
        LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
    }

    protected Map<String, String[]> getLayoutSetPrototypesParameters(boolean importData) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("IGNORE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_SETTINGS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"CREATED_FROM_PROTOTYPE"});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        if (importData) {
            parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
            parameterMap.put("LOGO", new String[]{Boolean.TRUE.toString()});
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        } else {
            if (PropsValues.LAYOUT_SET_PROTOTYPE_PROPAGATE_LOGO) {
                parameterMap.put("LOGO", new String[]{Boolean.TRUE.toString()});
            } else {
                parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
            }
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.FALSE.toString()});
        }
        return parameterMap;
    }

    protected void importLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, boolean importData) throws PortalException {
        File file = null;
        StringBundler sb = new StringBundler(importData ? 4 : 3);
        sb.append(_TEMP_DIR);
        sb.append(layoutSetPrototype.getUuid());
        if (importData) {
            sb.append("-data");
        }
        sb.append(".lar");
        File cacheFile = new File(sb.toString());
        if (cacheFile.exists() && !importData) {
            Date modifiedDate = layoutSetPrototype.getModifiedDate();
            if (cacheFile.lastModified() >= modifiedDate.getTime()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Using cached layout set prototype LAR file " + cacheFile.getAbsolutePath()));
                }
                file = cacheFile;
            }
        }
        User user = UserLocalServiceUtil.getDefaultUser((long)layoutSetPrototype.getCompanyId());
        boolean newFile = false;
        if (file == null) {
            List layoutSetPrototypeLayouts = LayoutLocalServiceUtil.getLayouts((long)layoutSetPrototype.getGroupId(), (boolean)true);
            Map exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap((User)user, (long)layoutSetPrototype.getGroupId(), (boolean)true, (long[])ExportImportHelperUtil.getLayoutIds((List)layoutSetPrototypeLayouts), parameterMap);
            ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration((long)user.getUserId(), (int)0, (Map)exportLayoutSettingsMap);
            file = ExportImportLocalServiceUtil.exportLayoutsAsFile((ExportImportConfiguration)exportImportConfiguration);
            newFile = true;
        }
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((long)user.getUserId(), (long)groupId, (boolean)privateLayout, null, parameterMap, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addExportImportConfiguration((long)user.getUserId(), (long)groupId, (String)"", (String)"", (int)6, (Map)importLayoutSettingsMap, (int)2, (ServiceContext)new ServiceContext());
        ExportImportLocalServiceUtil.importLayouts((ExportImportConfiguration)exportImportConfiguration, (File)file);
        if (newFile) {
            try {
                FileUtil.copyFile((File)file, (File)cacheFile);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Copied ", file.getAbsolutePath(), " to ", cacheFile.getAbsolutePath()}));
                }
            }
            catch (Exception e) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to copy file ", file.getAbsolutePath(), " to ", cacheFile.getAbsolutePath()}), (Throwable)e);
            }
        }
    }

    protected void setLayoutSetPrototypeLinkEnabledParameter(Map<String, String[]> parameterMap, LayoutSet targetLayoutSet, ServiceContext serviceContext) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"UNLINK_LAYOUT_SET_PROTOTYPE")) {
            return;
        }
        if (targetLayoutSet.isPrivateLayout()) {
            boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"privateLayoutSetPrototypeLinkEnabled", (boolean)true);
            if (!privateLayoutSetPrototypeLinkEnabled) {
                privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutSetPrototypeLinkEnabled");
            }
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{String.valueOf(privateLayoutSetPrototypeLinkEnabled)});
        } else {
            boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"publicLayoutSetPrototypeLinkEnabled");
            if (!publicLayoutSetPrototypeLinkEnabled) {
                publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutSetPrototypeLinkEnabled", (boolean)true);
            }
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{String.valueOf(publicLayoutSetPrototypeLinkEnabled)});
        }
    }

    protected void updateLayoutSetPrototypeLink(long groupId, boolean privateLayout, long layoutSetPrototypeId, boolean layoutSetPrototypeLinkEnabled) throws Exception {
        LayoutSetPrototype layoutSetPrototype;
        String layoutSetPrototypeUuid = null;
        if (layoutSetPrototypeId > 0L && (layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototype((long)layoutSetPrototypeId)) != null) {
            layoutSetPrototypeUuid = layoutSetPrototype.getUuid();
            if (!layoutSetPrototypeLinkEnabled && layoutSetPrototypeId > 0L) {
                Map<String, String[]> parameterMap = this.getLayoutSetPrototypesParameters(true);
                this.importLayoutSetPrototype(layoutSetPrototype, groupId, privateLayout, parameterMap, true);
            }
        }
        LayoutSetServiceUtil.updateLayoutSetPrototypeLinkEnabled((long)groupId, (boolean)privateLayout, (boolean)layoutSetPrototypeLinkEnabled, layoutSetPrototypeUuid);
        LayoutLocalServiceUtil.updatePriorities((long)groupId, (boolean)privateLayout);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        this.mergeLayoutSetPrototypeLayouts(group, layoutSet);
    }
}

