/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@OSGiBeanProperties
public class OrganizationIndexer
extends BaseIndexer<Organization> {
    public static final String CLASS_NAME = Organization.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(OrganizationIndexer.class);

    public OrganizationIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "organizationId", "uid"});
        this.setPermissionAware(true);
        this.setStagingAware(false);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        List organizationsTree;
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params == null) {
            return;
        }
        List excludedOrganizationIds = (List)params.get("excludedOrganizationIds");
        if (ListUtil.isNotEmpty((List)excludedOrganizationIds)) {
            TermsFilter termsFilter = new TermsFilter("organizationId");
            termsFilter.addValues(ArrayUtil.toStringArray((Object[])excludedOrganizationIds.toArray(new Long[excludedOrganizationIds.size()])));
            contextBooleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST_NOT);
        }
        if ((organizationsTree = (List)params.get("organizationsTree")) != null) {
            BooleanFilter booleanFilter = new BooleanFilter();
            if (organizationsTree.isEmpty()) {
                TermQueryImpl termQuery = new TermQueryImpl("treePath", "");
                booleanFilter.add((Filter)new QueryFilter((Query)termQuery));
            }
            for (Organization organization : organizationsTree) {
                String treePath = organization.buildTreePath();
                WildcardQueryImpl wildcardQuery = new WildcardQueryImpl("treePath", treePath);
                booleanFilter.add((Filter)new QueryFilter((Query)wildcardQuery));
            }
            contextBooleanFilter.add((Filter)booleanFilter, BooleanClauseOccur.MUST);
        } else {
            long parentOrganizationId = GetterUtil.getLong((Object)searchContext.getAttribute("parentOrganizationId"));
            if (parentOrganizationId != -1L) {
                contextBooleanFilter.addRequiredTerm("parentOrganizationId", parentOrganizationId);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected String buildNameTreePath(Organization organization) throws PortalException {
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        while (organization != null) {
            organizations.add(organization);
            organization = OrganizationLocalServiceUtil.fetchOrganization((long)organization.getParentOrganizationId());
        }
        int size = organizations.size();
        StringBundler sb = new StringBundler((size - 1) * 4 + 1);
        organization = (Organization)organizations.get(size - 1);
        sb.append(organization.getName());
        for (int i = size - 2; i >= 0; --i) {
            organization = (Organization)organizations.get(i);
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
            sb.append(organization.getName());
        }
        return sb.toString();
    }

    protected void doDelete(Organization organization) throws Exception {
        this.deleteDocument(organization.getCompanyId(), organization.getOrganizationId());
    }

    protected Document doGetDocument(Organization organization) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)organization);
        document.addKeyword("companyId", organization.getCompanyId());
        document.addText("name", organization.getName());
        document.addKeyword("organizationId", organization.getOrganizationId());
        document.addKeyword("treePath", organization.buildTreePath());
        document.addKeyword("type", organization.getType());
        document.addTextSortable("nameTreePath", this.buildNameTreePath(organization));
        document.addKeyword("parentOrganizationId", organization.getParentOrganizationId());
        this.populateAddresses(document, organization.getAddresses(), organization.getRegionId(), organization.getCountryId());
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("name")) {
            return "name";
        }
        if (orderByCol.equals("type")) {
            return "type";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String title = document.get("name");
        String content = null;
        return new Summary(title, content);
    }

    protected void doReindex(Organization organization) throws Exception {
        Document document = this.getDocument(organization);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)organization.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Organization organization = OrganizationLocalServiceUtil.getOrganization((long)classPK);
        this.doReindex(organization);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexOrganizations(companyId);
    }

    protected void reindexOrganizations(long companyId) throws Exception {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = OrganizationLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Organization>(){

            public void performAction(Organization organization) {
                block2: {
                    try {
                        Document document = OrganizationIndexer.this.getDocument(organization);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index organization " + organization.getOrganizationId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

