/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.easyconf;

import com.germinus.easyconf.AggregatedProperties;
import com.germinus.easyconf.ComponentProperties;
import com.liferay.petra.string.CharPool;
import com.liferay.portal.configuration.easyconf.ClassLoaderAggregateProperties;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public class ComponentPropertiesUtil {
    private static final Constructor<ComponentProperties> _CONSTRUCTOR;
    private static final String _ENV_OVERRIDE_PREFIX = "LIFERAY_";
    private static final Log _log;
    private static final Map<String, Character> _charPoolChars;

    public static ComponentProperties createComponentProperties(ClassLoader classLoader, String companyId, String componentName) {
        SystemProperties.set((String)"base.path", (String)".");
        ClassLoaderAggregateProperties classLoaderAggregateProperties = new ClassLoaderAggregateProperties(classLoader, companyId, componentName);
        classLoaderAggregateProperties.addGlobalFileName("global-configuration.properties");
        classLoaderAggregateProperties.addBaseFileName(componentName.concat(".properties"));
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Properties for ", componentName, " loaded from ", String.valueOf(classLoaderAggregateProperties.loadedSources())}));
        }
        ComponentPropertiesUtil._loadEnvOverrides((Configuration)classLoaderAggregateProperties);
        try {
            return _CONSTRUCTOR.newInstance(new Object[]{classLoaderAggregateProperties});
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private static String _decode(String s) {
        int index = -1;
        int openUnderLine = -1;
        int position = 0;
        StringBundler sb = new StringBundler();
        while ((index = s.indexOf(95, index + 1)) != -1) {
            if (openUnderLine == -1) {
                sb.append(s.substring(position, index));
                openUnderLine = index;
                position = index;
                continue;
            }
            String encoded = s.substring(openUnderLine + 1, index);
            Character character = _charPoolChars.get(StringUtil.toUpperCase((String)encoded));
            if (character == null) {
                int value = GetterUtil.get((String)encoded, (int)-1);
                if (Character.isDefined(value)) {
                    sb.append(new String(Character.toChars(value)));
                } else {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to decode part \"", encoded, "\" from \"", s, "\", preserve it literally"}));
                    }
                    sb.append(s.substring(openUnderLine, index + 1));
                }
            } else {
                sb.append((Object)character);
            }
            openUnderLine = -1;
            position = index + 1;
        }
        sb.append(s.substring(position));
        return sb.toString();
    }

    private static void _loadEnvOverrides(Configuration configuration) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(_ENV_OVERRIDE_PREFIX)) continue;
            String newKey = ComponentPropertiesUtil._decode(StringUtil.toLowerCase((String)key.substring(_ENV_OVERRIDE_PREFIX.length())));
            configuration.setProperty(newKey, (Object)entry.getValue());
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)StringBundler.concat((String[])new String[]{"Overrode property ", newKey, " with the value from the environment variable ", key}));
        }
    }

    static {
        _log = LogFactoryUtil.getLog(ComponentPropertiesUtil.class);
        Constructor constructor = null;
        try {
            constructor = ComponentProperties.class.getDeclaredConstructor(AggregatedProperties.class);
            constructor.setAccessible(true);
            _charPoolChars = new HashMap<String, Character>();
            for (Field field : CharPool.class.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Character.TYPE) continue;
                _charPoolChars.put(StringUtil.removeChar((String)field.getName(), (char)'_'), Character.valueOf(field.getChar(null)));
            }
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        _CONSTRUCTOR = constructor;
    }
}

