/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.jabsorb.serializer;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.portal.json.jabsorb.serializer.LiferayJSONDeserializationWhitelist;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.HashMap;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.Serializer;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONObject;

public class LiferayJSONSerializer
extends JSONSerializer {
    private static final Log _log = LogFactoryUtil.getLog(LiferayJSONSerializer.class);
    private final LiferayJSONDeserializationWhitelist _liferayJSONDeserializationWhitelist;

    public LiferayJSONSerializer(LiferayJSONDeserializationWhitelist liferayJSONDeserializationWhitelist) {
        this._liferayJSONDeserializationWhitelist = liferayJSONDeserializationWhitelist;
    }

    public void registerSerializer(Serializer serializer) {
        if (serializer != null) {
            this._liferayJSONDeserializationWhitelist.register(LiferayJSONSerializer._toClassNames(serializer.getSerializableClasses()));
        }
        super.registerSerializer(serializer);
    }

    protected Class getClassFromHint(Object object) throws UnmarshallException {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            String className = "";
            try {
                JSONObject jsonObject = (JSONObject)object;
                className = jsonObject.getString("javaClass");
                if (!this._liferayJSONDeserializationWhitelist.isWhitelisted(className)) {
                    if (jsonObject.has("serializable")) {
                        jsonObject.put("map", jsonObject.remove("serializable"));
                    } else {
                        jsonObject.put("map", (Object)new JSONObject());
                    }
                    jsonObject.put("javaClass", (Object)"java.util.HashMap");
                    return HashMap.class;
                }
                if (jsonObject.has("contextName")) {
                    String contextName = jsonObject.getString("contextName");
                    ClassLoader classLoader = ClassLoaderPool.getClassLoader((String)contextName);
                    if (classLoader != null) {
                        return Class.forName(className, true, classLoader);
                    }
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to get class loader for class ", className, " in context ", contextName}));
                    }
                }
            }
            catch (Exception e) {
                throw new UnmarshallException("Unable to get class " + className, (Throwable)e);
            }
        }
        return super.getClassFromHint(object);
    }

    private static String[] _toClassNames(Class<?>[] classes) {
        String[] classNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            classNames[i] = classes[i].getName();
        }
        return classNames;
    }
}

