/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.UserBagFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.comparator.GroupIdComparator;
import com.liferay.portal.service.base.GroupServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.ratings.kernel.transformer.RatingsDataTransformerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GroupServiceImpl
extends GroupServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(GroupServiceImpl.class);

    public Group addGroup(long parentGroupId, long liveGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        if (parentGroupId == 0L) {
            PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_COMMUNITY");
        } else {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentGroupId, (String)"ADD_COMMUNITY");
        }
        Group group = this.groupLocalService.addGroup(this.getUserId(), parentGroupId, null, 0L, liveGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, inheritContent, active, serviceContext);
        if (site) {
            SiteMembershipPolicyUtil.verifyPolicy((Group)group);
        }
        return group;
    }

    public Group addGroup(long parentGroupId, long liveGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.addGroup(parentGroupId, liveGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, false, active, serviceContext);
    }

    @Deprecated
    public Group addGroup(long parentGroupId, long liveGroupId, String name, String description, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.addGroup(parentGroupId, liveGroupId, this.getLocalizationMap(name), this.getLocalizationMap(description), type, manualMembership, membershipRestriction, friendlyURL, site, false, active, serviceContext);
    }

    public void addRoleGroups(long roleId, long[] groupIds) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.groupLocalService.addRoleGroups(roleId, groupIds);
    }

    public void checkRemoteStagingGroup(long groupId) throws PortalException {
        Group group = this.getGroup(groupId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (group.getCompanyId() != permissionChecker.getCompanyId()) {
            throw new NoSuchGroupException(StringBundler.concat((String[])new String[]{"Group ", String.valueOf(groupId), " does not belong in company ", String.valueOf(permissionChecker.getCompanyId())}));
        }
    }

    public void deleteGroup(long groupId) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"DELETE");
        this.groupLocalService.deleteGroup(groupId);
    }

    public void disableStaging(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        this.groupLocalService.disableStaging(groupId);
    }

    public void enableStaging(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        this.groupLocalService.enableStaging(groupId);
    }

    public Group getCompanyGroup(long companyId) throws PortalException {
        Group group = this.groupLocalService.getCompanyGroup(companyId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"VIEW");
        return group;
    }

    public Group getGroup(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"VIEW");
        return group;
    }

    public Group getGroup(long companyId, String groupKey) throws PortalException {
        Group group = this.groupLocalService.getGroup(companyId, groupKey);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"VIEW");
        return group;
    }

    public String getGroupDisplayURL(long groupId, boolean privateLayout, boolean secureConnection) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"VIEW");
        if (!privateLayout && group.getPublicLayoutsPageCount() > 0) {
            return PortalUtil.getLayoutSetDisplayURL((LayoutSet)group.getPublicLayoutSet(), (boolean)secureConnection);
        }
        if (privateLayout && group.getPrivateLayoutsPageCount() > 0) {
            return PortalUtil.getLayoutSetDisplayURL((LayoutSet)group.getPrivateLayoutSet(), (boolean)secureConnection);
        }
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        String portletId = PortletProviderUtil.getPortletId((String)Layout.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        return PortalUtil.getControlPanelFullURL((long)groupId, (String)portletId, null);
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site) throws PortalException {
        return this.filterGroups(this.groupLocalService.getGroups(companyId, parentGroupId, site));
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site, int start, int end) throws PortalException {
        return this.filterGroups(this.groupLocalService.getGroups(companyId, parentGroupId, site, start, end));
    }

    public int getGroupsCount(long companyId, long parentGroupId, boolean site) throws PortalException {
        if (parentGroupId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"VIEW");
        } else {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentGroupId, (String)"VIEW");
        }
        return this.groupLocalService.getGroupsCount(companyId, parentGroupId, site);
    }

    public int getGroupsCount(long companyId, String className, long parentGroupId) throws PortalException {
        if (parentGroupId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"VIEW");
        } else {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentGroupId, (String)"VIEW");
        }
        return this.groupLocalService.getGroupsCount(companyId, className, parentGroupId);
    }

    public List<Group> getGtGroups(long gtGroupId, long companyId, long parentGroupId, boolean site, int size) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(companyId)) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.groupPersistence.findByG_C_P_S(gtGroupId, companyId, parentGroupId, site, 0, size, (OrderByComparator)new GroupIdComparator(true));
    }

    public List<Group> getManageableSiteGroups(Collection<Portlet> portlets, int max) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
            params.put("site", Boolean.TRUE);
            return ListUtil.unique((List)this.groupLocalService.search(permissionChecker.getCompanyId(), null, null, null, params, true, 0, max));
        }
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        List<Group> userSitesGroups = this.getUserSitesGroups(null, max);
        for (Group group : userSitesGroups) {
            if (!group.isSite() || !PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)permissionChecker, (long)group.getGroupId(), portlets)) continue;
            groups.add(group);
        }
        return new ArrayList<Group>(groups);
    }

    public List<Group> getOrganizationsGroups(List<Organization> organizations) throws PortalException {
        List groups = this.groupLocalService.getOrganizationsGroups(organizations);
        return this.filterGroups(groups);
    }

    public Group getUserGroup(long companyId, long userId) throws PortalException {
        Group group = this.groupLocalService.getUserGroup(companyId, userId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"VIEW");
        return group;
    }

    public List<Group> getUserGroupsGroups(List<UserGroup> userGroups) throws PortalException {
        List groups = this.groupLocalService.getUserGroupsGroups(userGroups);
        return this.filterGroups(groups);
    }

    public List<Group> getUserOrganizationsGroups(long userId, int start, int end) throws PortalException {
        List groups = this.groupLocalService.getUserOrganizationsGroups(userId, start, end);
        return this.filterGroups(groups);
    }

    public List<Group> getUserSitesGroups() throws PortalException {
        return this.getUserSitesGroups(null, -1);
    }

    public List<Group> getUserSitesGroups(long userId, String[] classNames, int max) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        boolean checkPermissions = true;
        if (userId == this.getUserId()) {
            checkPermissions = false;
        }
        if (checkPermissions) {
            UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        }
        if (user.isDefaultUser()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Group> userSiteGroups = new LinkedHashSet<Group>();
        if (classNames == null) {
            classNames = new String[]{Company.class.getName(), Group.class.getName(), Organization.class.getName(), User.class.getName()};
        }
        if (ArrayUtil.contains((Object[])classNames, (Object)User.class.getName()) && (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED)) {
            userSiteGroups.add(user.getGroup());
            if (userSiteGroups.size() == max) {
                if (checkPermissions) {
                    return this.filterGroups(new ArrayList<Group>(userSiteGroups));
                }
                return new ArrayList<Group>(userSiteGroups);
            }
        }
        if (ArrayUtil.contains((Object[])classNames, (Object)Company.class.getName())) {
            Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
            if (GroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (Group)companyGroup, (String)"VIEW_SITE_ADMINISTRATION")) {
                userSiteGroups.add(companyGroup);
                if (userSiteGroups.size() == max) {
                    return new ArrayList<Group>(userSiteGroups);
                }
            }
        }
        if (ArrayUtil.contains((Object[])classNames, (Object)Group.class.getName()) || ArrayUtil.contains((Object[])classNames, (Object)Organization.class.getName())) {
            UserBag userBag = UserBagFactoryUtil.create((long)userId);
            if (ArrayUtil.contains((Object[])classNames, (Object)Group.class.getName())) {
                for (Group group : userBag.getUserGroups()) {
                    if (!this.groupLocalService.isLiveGroupActive(group) || !group.isSite() || !userSiteGroups.add(group) || userSiteGroups.size() != max) continue;
                    if (checkPermissions) {
                        return this.filterGroups(new ArrayList<Group>(userSiteGroups));
                    }
                    return new ArrayList<Group>(userSiteGroups);
                }
            }
            if (ArrayUtil.contains((Object[])classNames, (Object)Organization.class.getName())) {
                for (Group group : userBag.getUserOrgGroups()) {
                    if (!this.groupLocalService.isLiveGroupActive(group) || !group.isSite() || !userSiteGroups.add(group) || userSiteGroups.size() != max) continue;
                    if (checkPermissions) {
                        return this.filterGroups(new ArrayList<Group>(userSiteGroups));
                    }
                    return new ArrayList<Group>(userSiteGroups);
                }
            }
        }
        if (checkPermissions) {
            return this.filterGroups(new ArrayList<Group>(userSiteGroups));
        }
        return new ArrayList<Group>(userSiteGroups);
    }

    public List<Group> getUserSitesGroups(String[] classNames, int max) throws PortalException {
        return this.getUserSitesGroups(this.getGuestOrUserId(), classNames, max);
    }

    public int getUserSitesGroupsCount() throws PortalException {
        List<Group> userSitesGroups = this.getUserSitesGroups(this.getGuestOrUserId(), null, -1);
        return userSitesGroups.size();
    }

    public boolean hasUserGroup(long userId, long groupId) throws PortalException {
        try {
            UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW_MEMBERS");
        }
        return this.groupLocalService.hasUserGroup(userId, groupId);
    }

    public List<Group> search(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> obc) throws PortalException {
        List groups = this.groupLocalService.search(companyId, classNameIds, keywords, params, start, end, obc);
        return this.filterGroups(groups);
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> obc) throws PortalException {
        List groups = this.groupLocalService.search(companyId, classNameIds, name, description, params, andOperator, start, end, obc);
        return this.filterGroups(groups);
    }

    public List<Group> search(long companyId, String name, String description, String[] params, int start, int end) throws PortalException {
        if (params == null) {
            params = new String[]{};
        }
        LinkedHashMap paramsObj = MapUtil.toLinkedHashMap((String[])params);
        List groups = this.groupLocalService.search(companyId, name, description, paramsObj, true, start, end);
        return this.filterGroups(groups);
    }

    public int searchCount(long companyId, String name, String description, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        LinkedHashMap paramsObj = MapUtil.toLinkedHashMap((String[])params);
        return this.groupLocalService.searchCount(companyId, name, description, paramsObj, true);
    }

    public void setRoleGroups(long roleId, long[] groupIds) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.groupLocalService.setRoleGroups(roleId, groupIds);
    }

    public void unsetRoleGroups(long roleId, long[] groupIds) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.groupLocalService.unsetRoleGroups(roleId, groupIds);
    }

    public Group updateFriendlyURL(long groupId, String friendlyURL) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.groupLocalService.updateFriendlyURL(groupId, friendlyURL);
    }

    public Group updateGroup(long groupId, long parentGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        if (group.getParentGroupId() != parentGroupId) {
            if (parentGroupId == 0L) {
                PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_COMMUNITY");
            } else {
                GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentGroupId, (String)"ADD_COMMUNITY");
            }
        }
        if (group.isSite()) {
            Group oldGroup = group;
            List oldAssetCategories = this.assetCategoryLocalService.getCategories(Group.class.getName(), groupId);
            List oldAssetTags = this.assetTagLocalService.getTags(Group.class.getName(), groupId);
            ExpandoBridge oldExpandoBridge = oldGroup.getExpandoBridge();
            Map oldExpandoAttributes = oldExpandoBridge.getAttributes();
            group = this.groupLocalService.updateGroup(groupId, parentGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, inheritContent, active, serviceContext);
            SiteMembershipPolicyUtil.verifyPolicy((Group)group, (Group)oldGroup, (List)oldAssetCategories, (List)oldAssetTags, (Map)oldExpandoAttributes, null);
            return group;
        }
        return this.groupLocalService.updateGroup(groupId, parentGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, inheritContent, active, serviceContext);
    }

    @Deprecated
    public Group updateGroup(long groupId, long parentGroupId, String name, String description, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.updateGroup(groupId, parentGroupId, this.getLocalizationMap(name), this.getLocalizationMap(description), type, manualMembership, membershipRestriction, friendlyURL, inheritContent, active, serviceContext);
    }

    public Group updateGroup(long groupId, String typeSettings) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        if (group.isSite()) {
            Group oldGroup = group;
            UnicodeProperties oldTypeSettingsProperties = oldGroup.getTypeSettingsProperties();
            group = this.groupLocalService.updateGroup(groupId, typeSettings);
            RatingsDataTransformerUtil.transformGroupRatingsData((long)groupId, (UnicodeProperties)oldTypeSettingsProperties, (UnicodeProperties)group.getTypeSettingsProperties());
            SiteMembershipPolicyUtil.verifyPolicy((Group)group, (Group)oldGroup, null, null, null, (UnicodeProperties)oldTypeSettingsProperties);
            return group;
        }
        return this.groupLocalService.updateGroup(groupId, typeSettings);
    }

    public void updateStagedPortlets(long groupId, Map<String, String> stagedPortletIds) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        for (Map.Entry<String, String> entry : stagedPortletIds.entrySet()) {
            typeSettingsProperties.setProperty(StagingUtil.getStagedPortletId((String)entry.getKey()), entry.getValue());
        }
        this.groupLocalService.updateGroup(group);
    }

    protected List<Group> filterGroups(List<Group> groups) throws PortalException {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!GroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"VIEW")) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    protected Map<Locale, String> getLocalizationMap(String value) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        map.put(LocaleUtil.getDefault(), value);
        return map;
    }
}

