/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.spring.util.SpringFactoryUtil;
import com.liferay.portal.spring.context.PortletApplicationContext;
import java.util.Map;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class PortletBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        ClassLoader classLoader = this.getClassLoader();
        configurableListableBeanFactory.setBeanClassLoader(classLoader);
        ListableBeanFactory parentListableBeanFactory = (ListableBeanFactory)configurableListableBeanFactory.getParentBeanFactory();
        if (parentListableBeanFactory != null) {
            Map beanPostProcessors = parentListableBeanFactory.getBeansOfType(BeanPostProcessor.class, true, false);
            for (BeanPostProcessor beanPostProcessor : beanPostProcessors.values()) {
                if (beanPostProcessor instanceof BeanFactoryAware) {
                    BeanFactoryAware beanFactoryAware = (BeanFactoryAware)beanPostProcessor;
                    beanFactoryAware.setBeanFactory((BeanFactory)configurableListableBeanFactory);
                }
                if (beanPostProcessor instanceof AbstractAutoProxyCreator) {
                    AbstractAutoProxyCreator abstractAutoProxyCreator = (AbstractAutoProxyCreator)beanPostProcessor;
                    abstractAutoProxyCreator.setProxyClassLoader(classLoader);
                }
                configurableListableBeanFactory.addBeanPostProcessor(beanPostProcessor);
            }
        }
        String[] names = configurableListableBeanFactory.getBeanDefinitionNames();
        for (String name : names) {
            if (!name.contains(SpringFactoryUtil.class.getName())) continue;
            try {
                Object bean = configurableListableBeanFactory.getBean(name);
                if (!(bean instanceof BeanPostProcessor)) continue;
                configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)bean);
            }
            catch (BeanIsAbstractException biae) {
                // empty catch block
            }
        }
    }

    protected ClassLoader getClassLoader() {
        return PortletApplicationContext.getBeanClassLoader();
    }
}

