/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import aQute.bnd.version.Version;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ReleaseLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.transaction.TransactionsUtil;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistrar;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.commons.lang.time.StopWatch;

public class DBUpgrader {
    private static final Version _VERSION_7010 = new Version("0.0.6");
    private static final Log _log = LogFactoryUtil.getLog(DBUpgrader.class);

    public static void checkRequiredBuildNumber(int requiredBuildNumber) throws PortalException {
        int buildNumber = ReleaseLocalServiceUtil.getBuildNumberOrCreate();
        if (buildNumber > ReleaseInfo.getParentBuildNumber()) {
            StringBundler sb = new StringBundler(6);
            sb.append("Attempting to deploy an older Liferay Portal version. ");
            sb.append("Current build number is ");
            sb.append(buildNumber);
            sb.append(" and attempting to deploy number ");
            sb.append(ReleaseInfo.getParentBuildNumber());
            sb.append(".");
            throw new IllegalStateException(sb.toString());
        }
        if (buildNumber < requiredBuildNumber) {
            String msg = "You must first upgrade to Liferay Portal " + requiredBuildNumber;
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
    }

    public static void main(String[] args) {
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            ClassPathUtil.initializeClassPaths(null);
            PortalClassPathUtil.initializeClassPaths(null);
            InitUtil.initWithSpring(true, false);
            StartupHelperUtil.printPatchLevel();
            DBUpgrader.upgrade();
            DBUpgrader._checkClassNamesAndResourceActions();
            DBUpgrader.verify();
            DBUpgrader._registerModuleServiceLifecycle("database.initialized");
            InitUtil.registerContext();
            DBUpgrader._registerModuleServiceLifecycle("portal.initialized");
            System.out.println("\nCompleted Liferay core upgrade and verify processes in " + stopWatch.getTime() / 1000L + " seconds");
            System.out.println("Running modules upgrades. Connect to Gogo shell to check the status.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void upgrade() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Disable cache registry");
        }
        CacheRegistryUtil.setActive((boolean)false);
        DBUpgrader.checkRequiredBuildNumber(6100);
        try (Connection connection = DataAccess.getConnection();){
            if (PortalUpgradeProcess.isInLatestSchemaVersion(connection)) {
                return;
            }
        }
        int buildNumber = ReleaseLocalServiceUtil.getBuildNumberOrCreate();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Update build " + buildNumber));
        }
        DBUpgrader._checkPermissionAlgorithm();
        DBUpgrader._checkReleaseState(DBUpgrader._getReleaseState());
        if (PropsValues.UPGRADE_DATABASE_TRANSACTIONS_DISABLED) {
            TransactionsUtil.disableTransactions();
        }
        try {
            buildNumber = DBUpgrader._getBuildNumberForMissedUpgradeProcesses(buildNumber);
            StartupHelperUtil.upgradeProcess(buildNumber);
        }
        catch (Exception e) {
            DBUpgrader._updateReleaseState(1);
            throw e;
        }
        finally {
            if (PropsValues.UPGRADE_DATABASE_TRANSACTIONS_DISABLED) {
                TransactionsUtil.enableTransactions();
            }
        }
        CustomSQLUtil.reloadCustomSQL();
        SQLTransformer.reloadSQLTransformer();
        if (StartupHelperUtil.isUpgraded()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Update company key");
            }
            DBUpgrader._updateCompanyKey();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Clear cache if upgrade process was run");
        }
        if (StartupHelperUtil.isUpgraded()) {
            MultiVMPoolUtil.clear();
        }
    }

    public static void verify() throws Exception {
        Release release = ReleaseLocalServiceUtil.fetchRelease((String)"portal");
        if (release == null) {
            release = ReleaseLocalServiceUtil.addRelease((String)"portal", (int)ReleaseInfo.getParentBuildNumber());
        }
        DBUpgrader._checkReleaseState(release.getState());
        if (PropsValues.DATABASE_INDEXES_UPDATE_ON_STARTUP) {
            StartupHelperUtil.setDropIndexes(true);
            StartupHelperUtil.updateIndexes();
        } else if (StartupHelperUtil.isUpgraded()) {
            StartupHelperUtil.updateIndexes();
        }
        if (PropsValues.VERIFY_DATABASE_TRANSACTIONS_DISABLED) {
            TransactionsUtil.disableTransactions();
        }
        boolean newBuildNumber = false;
        if (ReleaseInfo.getBuildNumber() > release.getBuildNumber()) {
            newBuildNumber = true;
        }
        try {
            StartupHelperUtil.verifyProcess(newBuildNumber, release.isVerified());
        }
        catch (Exception e) {
            DBUpgrader._updateReleaseState(2);
            _log.error((Object)("Unable to execute verify process: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            if (PropsValues.VERIFY_DATABASE_TRANSACTIONS_DISABLED) {
                TransactionsUtil.enableTransactions();
            }
        }
        if (PropsValues.DATABASE_INDEXES_UPDATE_ON_STARTUP || StartupHelperUtil.isUpgraded()) {
            StartupHelperUtil.updateIndexes(false);
        }
        boolean verified = StartupHelperUtil.isVerified();
        if (release.isVerified()) {
            verified = true;
        }
        release.setBuildNumber(ReleaseInfo.getParentBuildNumber());
        release.setBuildDate(ReleaseInfo.getBuildDate());
        release.setVerified(verified);
        release = ReleaseLocalServiceUtil.updateRelease((Release)release);
        CacheRegistryUtil.setActive((boolean)true);
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistrar serviceRegistrar = registry.getServiceRegistrar(Release.class);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("build.date", release.getBuildDate());
        properties.put("build.number", release.getBuildNumber());
        properties.put("servlet.context.name", release.getServletContextName());
        serviceRegistrar.registerService(Release.class, (Object)release, properties);
    }

    private static void _checkClassNamesAndResourceActions() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check class names");
        }
        ClassNameLocalServiceUtil.checkClassNames();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource actions");
        }
        ResourceActionLocalServiceUtil.checkResourceActions();
    }

    private static void _checkPermissionAlgorithm() throws Exception {
        long count = DBUpgrader._getResourceCodesCount();
        if (count == 0L) {
            return;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("Permission conversion to algorithm 6 has not been ");
        sb.append("completed. Please complete the conversion prior to ");
        sb.append("starting the portal. The conversion process is available ");
        sb.append("in portal versions starting with 5203 and prior to ");
        sb.append(6200);
        sb.append(".");
        throw new IllegalStateException(sb.toString());
    }

    private static void _checkReleaseState(int state) throws Exception {
        if (state == 0) {
            return;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("The database contains changes from a previous upgrade ");
        sb.append("attempt that failed. Please restore the old database and ");
        sb.append("file system and retry the upgrade. A patch may be ");
        sb.append("required if the upgrade failed due to a bug or an ");
        sb.append("unforeseen data permutation that resulted from a corrupt ");
        sb.append("database.");
        throw new IllegalStateException(sb.toString());
    }

    private static int _getBuildNumberForMissedUpgradeProcesses(int buildNumber) throws Exception {
        if (buildNumber == 7010) {
            try (Connection connection = DataAccess.getConnection();){
                Version schemaVersion = PortalUpgradeProcess.getCurrentSchemaVersion(connection);
                if (!schemaVersion.equals((Object)_VERSION_7010)) {
                    int n = 7001;
                    return n;
                }
            }
        }
        return buildNumber;
    }

    private static int _getReleaseState() throws Exception {
        block3: {
            int n;
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select state_ from Release_ where releaseId = ?");
                ps.setLong(1, 1L);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt("state_");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return n;
        }
        throw new IllegalArgumentException("No Release exists with the primary key 1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long _getResourceCodesCount() throws Exception {
        long count2;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block5: {
            con = null;
            ps = null;
            rs = null;
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select count(*) from ResourceCode");
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            int count2 = rs.getInt(1);
            long l = count2;
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        try {
            count2 = 0L;
        }
        catch (Exception e) {
            long l;
            try {
                l = 0L;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return count2;
    }

    private static void _registerModuleServiceLifecycle(String moduleServiceLifecycle) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("module.service.lifecycle", moduleServiceLifecycle);
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        registry.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, properties);
    }

    private static void _updateCompanyKey() throws Exception {
        DB db = DBManagerUtil.getDB();
        db.runSQL("update Company set key_ = null");
    }

    private static void _updateReleaseState(int state) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update Release_ set modifiedDate = ?, state_ = ? where releaseId = ?");
            ps.setDate(1, new Date(System.currentTimeMillis()));
            ps.setInt(2, state);
            ps.setLong(3, 1L);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

