/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.tools.deploy.DeploymentProgressListener;
import java.io.File;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class DeploymentHandler {
    private static final Log _log = LogFactoryUtil.getLog(DeploymentHandler.class);
    private final DeploymentManager _deploymentManager;
    private boolean _error;
    private boolean _started;

    public DeploymentHandler(String dmId, String dmUser, String dmPassword, String dfClassName) {
        DeploymentManager deploymentManager = null;
        try {
            ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
            DeploymentFactoryManager deploymentFactoryManager = DeploymentFactoryManager.getInstance();
            Class<?> clazz = classLoader.loadClass(dfClassName);
            DeploymentFactory deploymentFactory = (DeploymentFactory)clazz.newInstance();
            deploymentFactoryManager.registerDeploymentFactory(deploymentFactory);
            deploymentManager = deploymentFactoryManager.getDeploymentManager(dmId, dmUser, dmPassword);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._deploymentManager = deploymentManager;
    }

    public void deploy(File warDir, String warContext) throws Exception {
        TargetModuleID[] targetModuleIDs;
        this.setStarted(false);
        ProgressObject deployProgress = null;
        for (TargetModuleID targetModuleID : targetModuleIDs = this._deploymentManager.getAvailableModules(ModuleType.WAR, this._deploymentManager.getTargets())) {
            String moduleId = targetModuleID.getModuleID();
            if (!moduleId.equals(warContext)) continue;
            deployProgress = this._deploymentManager.redeploy(new TargetModuleID[]{targetModuleID}, warDir, null);
            break;
        }
        if (deployProgress == null) {
            deployProgress = this._deploymentManager.distribute(this._deploymentManager.getTargets(), warDir, null);
        }
        deployProgress.addProgressListener((ProgressListener)new DeploymentProgressListener(this, warContext));
        this.waitForStart(warContext);
        if (this._error) {
            throw new Exception("Failed to deploy " + warDir);
        }
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public void releaseDeploymentManager() {
        this._deploymentManager.release();
    }

    public synchronized void setError(boolean error) {
        this._error = error;
    }

    public synchronized void setStarted(boolean started) {
        this._started = started;
        this.notifyAll();
    }

    protected synchronized void waitForStart(String warContext) throws Exception {
        while (!this._error && !this._started) {
            this.wait();
        }
        if (this._error) {
            return;
        }
    }
}

