/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_1;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeLayout
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateSourcePrototypeLayoutUuid();
    }

    protected long getLayoutPrototypeGroupId(String layoutPrototypeUuid) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select groupId from Group_ where classPK = (select layoutPrototypeId from LayoutPrototype where uuid_ = ?)");){
            ps.setString(1, layoutPrototypeUuid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    long groupId;
                    long l = groupId = rs.getLong("groupId");
                    return l;
                }
            }
        }
        return 0L;
    }

    protected boolean isGroupPrivateLayout(long groupId, String sourcePrototypeLayoutUuid) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select count(*) from Layout where uuid_ = ? and groupId = ? and privateLayout = ?");){
            ps.setString(1, sourcePrototypeLayoutUuid);
            ps.setLong(2, groupId);
            ps.setBoolean(3, true);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    int count = rs.getInt(1);
                    if (count > 0) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return false;
    }

    protected void updateSourcePrototypeLayoutUuid() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("select plid, layoutPrototypeUuid, ");
            sb.append("sourcePrototypeLayoutUuid from Layout where ");
            sb.append("layoutPrototypeUuid != '' and ");
            sb.append("sourcePrototypeLayoutUuid != ''");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String sourcePrototypeLayoutUuid;
                    String layoutPrototypeUuid = rs.getString("layoutPrototypeUuid");
                    long groupId = this.getLayoutPrototypeGroupId(layoutPrototypeUuid);
                    if (groupId == 0L || !this.isGroupPrivateLayout(groupId, sourcePrototypeLayoutUuid = rs.getString("sourcePrototypeLayoutUuid"))) continue;
                    long plid = rs.getLong("plid");
                    this.runSQL("update Layout set sourcePrototypeLayoutUuid = null where plid = " + plid);
                }
            }
        }
    }
}

