/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.v6_2_0.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.upgrade.v6_2_0.util.JournalFeedTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class UpgradeJournal
extends BaseUpgradePortletPreferences {
    private static final int _DDM_STRUCTURE_TYPE_DEFAULT = 0;
    private static final String _DDM_TEMPLATE_MODE_CREATE = "create";
    private static final String _DDM_TEMPLATE_TYPE_DISPLAY = "display";
    private static final String _PORTLET_ID_ASSET_PUBLISHER = "101";
    private static final String _PORTLET_ID_JOURNAL_CONTENT = "56";
    private static final String _PORTLET_ID_JOURNAL_CONTENT_LIST = "62";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeJournal.class);
    private final Map<String, String> _ddmDataTypes = new HashMap<String, String>();
    private final Map<String, String> _ddmMetadataAttributes = new HashMap<String, String>();
    private final Map<String, Long> _ddmStructureIds = new HashMap<String, Long>();
    private final Map<Long, Long> _ddmStructurePKs = new HashMap<Long, Long>();
    private final Map<String, String> _journalTypesToDDMTypes = new HashMap<String, String>();

    protected void addDDMStructure(String uuid, long ddmStructureId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long parentDDMStructureId, long classNameId, String ddmStructureKey, String name, String description, String xsd, String storageType, int type) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("insert into DDMStructure (uuid_, structureId, groupId, ");
        sb.append("companyId, userId, userName, createDate, modifiedDate, ");
        sb.append("parentStructureId, classNameId, structureKey, name, ");
        sb.append("description, xsd, storageType, type_) values (?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        String sql = sb.toString();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.setLong(2, ddmStructureId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, modifiedDate);
            ps.setLong(9, parentDDMStructureId);
            ps.setLong(10, classNameId);
            ps.setString(11, ddmStructureKey);
            ps.setString(12, name);
            ps.setString(13, description);
            ps.setString(14, this.getDDMXSD(xsd, this.getDefaultLocale(companyId)));
            ps.setString(15, storageType);
            ps.setInt(16, type);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.error((Object)("Unable to upgrade dynamic data mapping structure with UUID " + uuid));
            throw e;
        }
    }

    protected void addDDMStructure(String uuid, long ddmStructureId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, String parentStructureId, String ddmStructureKey, String name, String description, String xsd) throws Exception {
        long insertedDDMStructureId;
        long parentDDMStructureId = 0L;
        if (Validator.isNotNull((String)parentStructureId)) {
            parentDDMStructureId = this.updateStructure(parentStructureId);
        }
        if ((insertedDDMStructureId = this.getDDMStructureId(groupId, ddmStructureKey, false)) == 0L) {
            this.addDDMStructure(uuid, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentDDMStructureId, PortalUtil.getClassNameId((String)"com.liferay.portlet.journal.model.JournalArticle"), ddmStructureKey, name, description, xsd, "xml", 0);
        }
    }

    protected void addDDMTemplate(String uuid, long ddmTemplateId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, String templateKey, String name, String description, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, long smallImageId, String smallImageURL) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("insert into DDMTemplate (uuid_, templateId, groupId, ");
        sb.append("companyId, userId, userName, createDate, modifiedDate,");
        sb.append("classNameId, classPK , templateKey, name, description,");
        sb.append("type_, mode_, language, script, cacheable, smallImage,");
        sb.append("smallImageId, smallImageURL) values (?, ?, ?, ?, ?, ?,?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        String sql = sb.toString();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.setLong(2, ddmTemplateId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, modifiedDate);
            ps.setLong(9, classNameId);
            ps.setLong(10, classPK);
            ps.setString(11, templateKey);
            ps.setString(12, name);
            ps.setString(13, description);
            ps.setString(14, type);
            ps.setString(15, mode);
            ps.setString(16, language);
            ps.setString(17, script);
            ps.setBoolean(18, cacheable);
            ps.setBoolean(19, smallImage);
            ps.setLong(20, smallImageId);
            ps.setString(21, smallImageURL);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.error((Object)("Unable to upgrade dynamic data mapping template with UUID " + uuid));
            throw e;
        }
    }

    protected void addMetadataEntry(Element metadataElement, String name, String value) {
        Element entryElement = metadataElement.addElement("entry");
        entryElement.addAttribute("name", name);
        entryElement.addCDATA(value);
    }

    protected void addResourcePermission(PreparedStatement ps, long companyId, String primKey, long roleId) {
        try {
            ps.setLong(1, this.increment());
            ps.setLong(2, companyId);
            ps.setString(3, "com.liferay.portlet.journal");
            ps.setInt(4, 4);
            ps.setString(5, primKey);
            ps.setLong(6, roleId);
            ps.setLong(7, 0L);
            ps.setLong(8, 1L);
            ps.addBatch();
        }
        catch (Exception e) {
            _log.error((Object)"Unable to insert ResourcePermission", (Throwable)e);
        }
    }

    protected String decodeURL(String url) {
        try {
            return HttpUtil.decodeURL((String)url);
        }
        catch (IllegalArgumentException iae) {
            return url;
        }
    }

    protected void doUpgrade() throws Exception {
        this.alter(JournalFeedTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnName((UpgradeProcess)this, "feedType", "feedFormat VARCHAR(75) null")});
        this.setUpStrutureAttributesMappings();
        this.updateContentSearch();
        this.updateLinkToLayoutContent();
        this.updateStructures();
        this.updateTemplates();
        this.upgradeURLTitle();
        this.updateAssetEntryClassTypeId();
        this.updateJournalResourcePermission();
        super.doUpgrade();
    }

    protected Element fetchMetadataEntry(Element parentElement, String attributeName, String attributeValue) {
        StringBundler sb = new StringBundler(5);
        sb.append("entry[@");
        sb.append(attributeName);
        sb.append("=");
        sb.append(HtmlUtil.escapeXPathAttribute((String)attributeValue));
        sb.append("]");
        XPath xPath = SAXReaderUtil.createXPath((String)sb.toString());
        return (Element)xPath.selectSingleNode((Object)parentElement);
    }

    /*
     * Exception decompiling
     */
    protected long getCompanyGroupId(long companyId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getDDMStructureClassNameId() {
        return PortalUtil.getClassNameId((String)"com.liferay.portlet.dynamicdatamapping.model.DDMStructure");
    }

    protected long getDDMStructureId(long groupId, long companyGroupId, String structureId) {
        return this.getDDMStructureId(groupId, companyGroupId, structureId, true);
    }

    protected long getDDMStructureId(long groupId, long companyGroupId, String structureId, boolean warn) {
        if (Validator.isNull((String)structureId)) {
            return 0L;
        }
        Long ddmStructureId = this._ddmStructureIds.get(groupId + "#" + structureId);
        if (ddmStructureId == null && companyGroupId != 0L) {
            ddmStructureId = this._ddmStructureIds.get(companyGroupId + "#" + structureId);
        }
        if (ddmStructureId != null) {
            return ddmStructureId;
        }
        if (warn && _log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Unable to get the DDM structure ID for group ");
            sb.append(groupId);
            if (companyGroupId != 0L) {
                sb.append(" or global group");
            }
            sb.append(" and journal structure ID ");
            sb.append(structureId);
            _log.warn((Object)sb.toString());
        }
        return 0L;
    }

    protected long getDDMStructureId(long groupId, String structureId, boolean warn) {
        return this.getDDMStructureId(groupId, 0L, structureId, warn);
    }

    protected String getDDMXSD(String journalXSD, Locale defaultLocale) throws Exception {
        Document document = SAXReaderUtil.read((String)journalXSD);
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("available-locales", defaultLocale.toString());
        rootElement.addAttribute("default-locale", defaultLocale.toString());
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement, defaultLocale.toString());
        }
        return XMLUtil.formatXML((Document)document);
    }

    protected Locale getDefaultLocale(long companyId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select languageId from User_ where companyId = ? and defaultUser = ?");){
            ps.setLong(1, companyId);
            ps.setBoolean(2, true);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String languageId = rs.getString("languageId");
                    Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                    return locale;
                }
            }
        }
        return LocaleUtil.getSiteDefault();
    }

    protected long getJournalStructureClassNameId() {
        return PortalUtil.getClassNameId((String)"com.liferay.portlet.journal.model.JournalStructure");
    }

    protected String[] getPortletIds() {
        return new String[]{"56_INSTANCE_%", "62_INSTANCE_%", "101_INSTANCE_%"};
    }

    /*
     * Exception decompiling
     */
    protected long getRoleId(String roleName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void removeAttribute(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return;
        }
        element.remove(attribute);
    }

    protected void setUpStrutureAttributesMappings() {
        this._ddmDataTypes.put("boolean", "boolean");
        this._ddmDataTypes.put("document_library", "document-library");
        this._ddmDataTypes.put("image", "image");
        this._ddmDataTypes.put("link_to_layout", "link-to-page");
        this._ddmDataTypes.put("list", "string");
        this._ddmDataTypes.put("multi-list", "string");
        this._ddmDataTypes.put("text", "string");
        this._ddmDataTypes.put("text_area", "html");
        this._ddmDataTypes.put("text_box", "string");
        this._ddmMetadataAttributes.put("instructions", "tip");
        this._ddmMetadataAttributes.put("label", "label");
        this._ddmMetadataAttributes.put("predefinedValue", "predefinedValue");
        this._journalTypesToDDMTypes.put("boolean", "checkbox");
        this._journalTypesToDDMTypes.put("document_library", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("image", "ddm-image");
        this._journalTypesToDDMTypes.put("image_gallery", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("link_to_layout", "ddm-link-to-page");
        this._journalTypesToDDMTypes.put("list", "select");
        this._journalTypesToDDMTypes.put("multi-list", "select");
        this._journalTypesToDDMTypes.put("selection_break", "ddm-separator");
        this._journalTypesToDDMTypes.put("text", "text");
        this._journalTypesToDDMTypes.put("text_area", "ddm-text-html");
        this._journalTypesToDDMTypes.put("text_box", "textarea");
    }

    protected void updateAssetEntryClassTypeId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select distinct companyId, groupId, resourcePrimKey, structureId from JournalArticle where structureId != ''");
             ResultSet rs = ps1.executeQuery();){
            long classNameId = PortalUtil.getClassNameId((String)"com.liferay.portlet.journal.model.JournalArticle");
            try (PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update AssetEntry set classTypeId = ? where classNameId = ? AND classPK = ?");){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long companyId = rs.getLong("companyId");
                    long resourcePrimKey = rs.getLong("resourcePrimKey");
                    String structureId = rs.getString("structureId");
                    long ddmStructureId = this.getDDMStructureId(groupId, this.getCompanyGroupId(companyId), structureId);
                    ps2.setLong(1, ddmStructureId);
                    ps2.setLong(2, classNameId);
                    ps2.setLong(3, resourcePrimKey);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    protected void updateContentSearch() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select groupId, portletId from JournalContentSearch group by groupId, portletId having count(groupId) > 1 and count(portletId) > 1");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                String portletId = rs.getString("portletId");
                this.updateContentSearch(groupId, portletId);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateContentSearch(long groupId, String portletId) throws Exception {
        try (PreparedStatement selectPreferencesPS = this.connection.prepareStatement("select preferences from PortletPreferences inner join Layout on PortletPreferences.plid = Layout.plid where groupId = ? and portletId = ?");
             PreparedStatement selectSearchPS = this.connection.prepareStatement("select companyId, privateLayout, layoutId, portletId from JournalContentSearch where JournalContentSearch.groupId = ? and JournalContentSearch.articleId = ?");
             PreparedStatement deleteSearchPS = this.connection.prepareStatement("delete from JournalContentSearch where JournalContentSearch.groupId = ? and JournalContentSearch.articleId = ?");
             PreparedStatement insertSearchPS = this.connection.prepareStatement("insert into JournalContentSearch(contentSearchId, companyId, groupId, privateLayout, layoutId, portletId, articleId) values (?, ?, ?, ?, ?, ?, ?)");){
            selectPreferencesPS.setLong(1, groupId);
            selectPreferencesPS.setString(2, portletId);
            try (ResultSet preferencesRS = selectPreferencesPS.executeQuery();){
                while (preferencesRS.next()) {
                    ResultSet searchRS;
                    block71: {
                        String xml = preferencesRS.getString("preferences");
                        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)xml);
                        String articleId = portletPreferences.getValue("articleId", null);
                        selectSearchPS.setLong(1, groupId);
                        selectSearchPS.setString(2, articleId);
                        searchRS = selectSearchPS.executeQuery();
                        Throwable throwable = null;
                        try {
                            if (searchRS.next()) {
                                long companyId = searchRS.getLong("companyId");
                                boolean privateLayout = searchRS.getBoolean("privateLayout");
                                long layoutId = searchRS.getLong("layoutId");
                                String journalContentSearchPortletId = searchRS.getString("portletId");
                                deleteSearchPS.setLong(1, groupId);
                                deleteSearchPS.setString(2, articleId);
                                deleteSearchPS.executeUpdate();
                                insertSearchPS.setLong(1, this.increment());
                                insertSearchPS.setLong(2, companyId);
                                insertSearchPS.setLong(3, groupId);
                                insertSearchPS.setBoolean(4, privateLayout);
                                insertSearchPS.setLong(5, layoutId);
                                insertSearchPS.setString(6, journalContentSearchPortletId);
                                insertSearchPS.setString(7, articleId);
                                insertSearchPS.executeUpdate();
                            }
                            if (searchRS == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (searchRS == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        searchRS.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                searchRS.close();
                                throw throwable3;
                            }
                        }
                        try {
                            searchRS.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    searchRS.close();
                }
                return;
            }
        }
    }

    protected void updateElement(long groupId, Element element) {
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateElement(groupId, dynamicElementElement);
        }
        String type = element.attributeValue("type");
        if (type.equals("link_to_layout")) {
            this.updateLinkToLayoutElements(groupId, element);
        }
    }

    protected void updateJournalArticleClassNameIdAndClassPK(long journalStructureId, Long ddmStructureId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update JournalArticle set classNameId = ?, classPK = ? where classNameId = ? and classPK = ?");){
            ps.setLong(1, this.getDDMStructureClassNameId());
            ps.setLong(2, ddmStructureId);
            ps.setLong(3, this.getJournalStructureClassNameId());
            ps.setLong(4, journalStructureId);
            ps.execute();
        }
    }

    protected void updateJournalResourcePermission() throws Exception {
        long guestRoleId = this.getRoleId("Guest");
        long ownerRoleId = this.getRoleId("Owner");
        long siteMemberRoleId = this.getRoleId("Site Member");
        StringBundler updateSB = new StringBundler(10);
        updateSB.append("update ResourcePermission set actionIds = actionIds ");
        updateSB.append("+ 1 where name = 'com.liferay.portlet.journal' and ");
        updateSB.append("roleId in (");
        updateSB.append(guestRoleId);
        updateSB.append(",");
        updateSB.append(ownerRoleId);
        updateSB.append(",");
        updateSB.append(siteMemberRoleId);
        updateSB.append(") and ownerId = 0 and MOD(actionIds, 2) = 0 and ");
        updateSB.append("scope = 4");
        this.runSQL(updateSB.toString());
        StringBundler selectSB = new StringBundler(10);
        selectSB.append("select companyId, primKey, roleId from ");
        selectSB.append("ResourcePermission where name = ");
        selectSB.append("'com.liferay.portlet.journal' and ownerId = 0 and ");
        selectSB.append("scope = 4 and roleId in (");
        selectSB.append(guestRoleId);
        selectSB.append(",");
        selectSB.append(ownerRoleId);
        selectSB.append(",");
        selectSB.append(siteMemberRoleId);
        selectSB.append(") order by companyId, primKey, roleId");
        StringBundler insertSB = new StringBundler(4);
        insertSB.append("insert into ResourcePermission ");
        insertSB.append("(resourcePermissionId, companyId, name, scope, ");
        insertSB.append("primKey, roleId, ownerId, actionIds) values (?, ?, ");
        insertSB.append("?, ?, ?, ?, ?, ?)");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement selectPS = this.connection.prepareStatement(selectSB.toString());
             PreparedStatement insertPS = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(insertSB.toString()));
             ResultSet rs = selectPS.executeQuery();){
            long currentCompanyId = 0L;
            String currentPrimKey = null;
            boolean hasGuestResourcePermissions = false;
            boolean hasOwnerResourcePermissions = false;
            boolean hasSiteMemberResourcePermissions = false;
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                String primKey = rs.getString("primKey");
                long roleId = rs.getLong("roleId");
                if (currentPrimKey != null && !primKey.equals(currentPrimKey)) {
                    if (!hasGuestResourcePermissions) {
                        this.addResourcePermission(insertPS, currentCompanyId, currentPrimKey, guestRoleId);
                    }
                    if (!hasOwnerResourcePermissions) {
                        this.addResourcePermission(insertPS, currentCompanyId, currentPrimKey, ownerRoleId);
                    }
                    if (!hasSiteMemberResourcePermissions) {
                        this.addResourcePermission(insertPS, currentCompanyId, currentPrimKey, siteMemberRoleId);
                    }
                    currentPrimKey = primKey;
                    currentCompanyId = companyId;
                    hasGuestResourcePermissions = false;
                    hasOwnerResourcePermissions = false;
                    hasSiteMemberResourcePermissions = false;
                }
                if (currentPrimKey == null) {
                    currentCompanyId = companyId;
                    currentPrimKey = primKey;
                }
                if (guestRoleId == roleId) {
                    hasGuestResourcePermissions = true;
                    continue;
                }
                if (ownerRoleId == roleId) {
                    hasOwnerResourcePermissions = true;
                    continue;
                }
                if (siteMemberRoleId != roleId) continue;
                hasSiteMemberResourcePermissions = true;
            }
            if (currentPrimKey != null) {
                if (!hasGuestResourcePermissions) {
                    this.addResourcePermission(insertPS, currentCompanyId, currentPrimKey, guestRoleId);
                }
                if (!hasOwnerResourcePermissions) {
                    this.addResourcePermission(insertPS, currentCompanyId, currentPrimKey, ownerRoleId);
                }
                if (!hasSiteMemberResourcePermissions) {
                    this.addResourcePermission(insertPS, currentCompanyId, currentPrimKey, siteMemberRoleId);
                }
            }
            insertPS.executeBatch();
        }
    }

    protected void updateJournalXSDDynamicElement(Element element, String defaultLanguageId) {
        String name = element.attributeValue("name");
        String type = element.attributeValue("type");
        Element metadataElement = element.element("meta-data");
        if (metadataElement == null) {
            metadataElement = element.addElement("meta-data");
        }
        if (type.equals("multi-list")) {
            element.addAttribute("multiple", "true");
        } else {
            Element parentElement = element.getParent();
            String parentType = parentElement.attributeValue("type");
            if (parentType != null && parentType.equals("select")) {
                metadataElement.addAttribute("locale", defaultLanguageId);
                this.addMetadataEntry(metadataElement, "label", this.decodeURL(name));
                this.removeAttribute(element, "index-type");
                element.addAttribute("name", "option" + StringUtil.randomId());
                element.addAttribute("type", "option");
                element.addAttribute("value", this.decodeURL(type));
                return;
            }
        }
        String indexType = "";
        Attribute indexTypeAttribute = element.attribute("index-type");
        if (indexTypeAttribute != null) {
            indexType = indexTypeAttribute.getValue();
            element.remove(indexTypeAttribute);
        }
        element.remove(element.attribute("type"));
        if (!type.equals("selection_break")) {
            String dataType = this._ddmDataTypes.get(type);
            if (dataType == null) {
                dataType = "string";
            }
            element.addAttribute("dataType", dataType);
        }
        element.addAttribute("indexType", indexType);
        String required = "false";
        Element requiredElement = this.fetchMetadataEntry(metadataElement, "name", "required");
        if (requiredElement != null) {
            required = requiredElement.getText();
        }
        element.addAttribute("required", required);
        element.addAttribute("showLabel", "true");
        String newType = this._journalTypesToDDMTypes.get(type);
        if (newType == null) {
            newType = type;
        }
        element.addAttribute("type", newType);
        if (newType.startsWith("ddm")) {
            element.addAttribute("fieldNamespace", "ddm");
        }
        metadataElement.addAttribute("locale", defaultLanguageId);
        List entryElements = metadataElement.elements();
        if (entryElements.isEmpty()) {
            this.addMetadataEntry(metadataElement, "label", name);
        } else {
            for (Element entryElement : entryElements) {
                String oldEntryName = entryElement.attributeValue("name");
                String newEntryName = this._ddmMetadataAttributes.get(oldEntryName);
                if (newEntryName == null) {
                    metadataElement.remove(entryElement);
                    continue;
                }
                entryElement.addAttribute("name", newEntryName);
            }
        }
        if (newType.equals("ddm-date") || newType.equals("ddm-decimal") || newType.equals("ddm-integer") || newType.equals("ddm-link-to-page") || newType.equals("ddm-number") || newType.equals("ddm-text-html") || newType.equals("text") || newType.equals("textarea")) {
            element.addAttribute("width", "25");
        } else if (newType.equals("ddm-image")) {
            element.addAttribute("fieldNamespace", "ddm");
            element.addAttribute("readOnly", "false");
        }
        element.add(metadataElement.detach());
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement, defaultLanguageId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateLinkToLayoutContent() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement selectPS = this.connection.prepareStatement("select id_, groupId, content from JournalArticle where structureId != '' and content like '%link_to_layout%'");
             PreparedStatement updatePS = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update JournalArticle set content = ? where id_ = ?"));
             ResultSet rs = selectPS.executeQuery();){
            while (rs.next()) {
                long id = rs.getLong("id_");
                long groupId = rs.getLong("groupId");
                String content = rs.getString("content");
                try {
                    Document document = SAXReaderUtil.read((String)content);
                    Element rootElement = document.getRootElement();
                    for (Element element : rootElement.elements()) {
                        this.updateElement(groupId, element);
                    }
                    updatePS.setString(1, document.asXML());
                    updatePS.setLong(2, id);
                    updatePS.addBatch();
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to update content for article " + id), (Throwable)e);
                }
            }
            updatePS.executeBatch();
            return;
        }
    }

    protected void updateLinkToLayoutElements(long groupId, Element element) {
        Element dynamicContentElement = element.element("dynamic-content");
        Node node = dynamicContentElement.node(0);
        String text = node.getText();
        if (!text.isEmpty() && !text.endsWith("@" + groupId)) {
            node.setText(dynamicContentElement.getStringValue() + "@" + groupId);
        }
    }

    protected void updatePreferencesClassPKs(PortletPreferences preferences, String key) throws Exception {
        String[] oldValues = preferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] oldPrimaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String oldPrimaryKey : oldPrimaryKeys = StringUtil.split((String)oldValue)) {
                if (!Validator.isNumber((String)oldPrimaryKey)) break;
                Long newPrimaryKey = this._ddmStructurePKs.get(GetterUtil.getLong((String)oldPrimaryKey));
                if (!Validator.isNotNull((Long)newPrimaryKey)) continue;
                newValue = StringUtil.replace((String)newValue, (String)oldPrimaryKey, (String)String.valueOf(newPrimaryKey));
            }
            newValues[i] = newValue;
        }
        preferences.setValues(key, newValues);
    }

    protected void updateResourcePermission(long companyId, String oldClassName, String newClassName, long oldPrimKey, long newPrimKey) throws Exception {
        StringBundler sb = new StringBundler(11);
        sb.append("update ResourcePermission set name = '");
        sb.append(newClassName);
        sb.append("', primKey = '");
        sb.append(newPrimKey);
        sb.append("' where companyId = ");
        sb.append(companyId);
        sb.append(" and name = '");
        sb.append(oldClassName);
        sb.append("' and primKey = '");
        sb.append(oldPrimKey);
        sb.append("'");
        this.runSQL(sb.toString());
    }

    protected long updateStructure(ResultSet rs) throws Exception {
        String uuid_ = rs.getString("uuid_");
        long id_ = rs.getLong("id_");
        long groupId = rs.getLong("groupId");
        long companyId = rs.getLong("companyId");
        long userId = rs.getLong("userId");
        String userName = rs.getString("userName");
        Timestamp createDate = rs.getTimestamp("createDate");
        Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
        String structureId = rs.getString("structureId");
        String parentStructureId = rs.getString("parentStructureId");
        String name = rs.getString("name");
        String description = rs.getString("description");
        String xsd = rs.getString("xsd");
        Long ddmStructureId = this._ddmStructureIds.get(groupId + "#" + structureId);
        if (ddmStructureId != null) {
            return ddmStructureId;
        }
        ddmStructureId = this.increment();
        this.addDDMStructure(uuid_, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentStructureId, structureId, name, description, xsd);
        this.updateJournalArticleClassNameIdAndClassPK(id_, ddmStructureId);
        this.updateResourcePermission(companyId, "com.liferay.portlet.journal.model.JournalStructure", "com.liferay.portlet.dynamicdatamapping.model.DDMStructure", id_, ddmStructureId);
        this._ddmStructureIds.put(groupId + "#" + structureId, ddmStructureId);
        this._ddmStructurePKs.put(id_, ddmStructureId);
        return ddmStructureId;
    }

    /*
     * Exception decompiling
     */
    protected long updateStructure(String structureId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateStructures() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select * from JournalStructure");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                this.updateStructure(rs);
            }
            this.runSQL("drop table JournalStructure");
        }
    }

    protected void updateTemplates() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select * from JournalTemplate");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String uuid_ = rs.getString("uuid_");
                long id_ = rs.getLong("id_");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                String templateId = rs.getString("templateId");
                String structureId = rs.getString("structureId");
                String name = rs.getString("name");
                String description = rs.getString("description");
                String language = rs.getString("langType");
                String script = rs.getString("xsl");
                boolean cacheable = rs.getBoolean("cacheable");
                boolean smallImage = rs.getBoolean("smallImage");
                long smallImageId = rs.getLong("smallImageId");
                String smallImageURL = rs.getString("smallImageURL");
                long ddmTemplateId = this.increment();
                long classNameId = this.getDDMStructureClassNameId();
                long classPK = this.getDDMStructureId(groupId, this.getCompanyGroupId(companyId), structureId);
                this.addDDMTemplate(uuid_, ddmTemplateId, groupId, companyId, userId, userName, createDate, modifiedDate, classNameId, classPK, templateId, name, description, _DDM_TEMPLATE_TYPE_DISPLAY, _DDM_TEMPLATE_MODE_CREATE, language, script, cacheable, smallImage, smallImageId, smallImageURL);
                this.updateResourcePermission(companyId, "com.liferay.portlet.journal.model.JournalTemplate", "com.liferay.portlet.dynamicdatamapping.model.DDMTemplate", id_, ddmTemplateId);
            }
            this.runSQL("drop table JournalTemplate");
        }
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        String structureId;
        PortletPreferences preferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        if (portletId.startsWith(_PORTLET_ID_ASSET_PUBLISHER)) {
            this.updatePreferencesClassPKs(preferences, "anyClassTypeJournalArticleAssetRendererFactory");
            this.updatePreferencesClassPKs(preferences, "classTypeIds");
            this.updatePreferencesClassPKs(preferences, "classTypeIdsJournalArticleAssetRendererFactory");
        } else if (portletId.startsWith(_PORTLET_ID_JOURNAL_CONTENT)) {
            String templateId = preferences.getValue("templateId", "");
            if (Validator.isNotNull((String)templateId)) {
                preferences.reset("templateId");
                preferences.setValue("ddmTemplateKey", templateId);
            }
        } else if (portletId.startsWith(_PORTLET_ID_JOURNAL_CONTENT_LIST) && Validator.isNotNull((String)(structureId = preferences.getValue("structureId", "")))) {
            preferences.reset("structureId");
            preferences.setValue("ddmStructureKey", structureId);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)preferences);
    }

    protected void upgradeURLTitle() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select distinct groupId, articleId, urlTitle from JournalArticle");
             ResultSet rs = ps1.executeQuery();){
            HashMap<String, String> processedArticleIds = new HashMap<String, String>();
            try (PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update JournalArticle set urlTitle = ? where urlTitle = ?"));){
                while (rs.next()) {
                    String normalizedURLTitle;
                    String urlTitle = GetterUtil.getString((String)rs.getString("urlTitle"));
                    if (urlTitle.equals(normalizedURLTitle = FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)urlTitle))) continue;
                    String articleId = rs.getString("articleId");
                    long groupId = rs.getLong("groupId");
                    normalizedURLTitle = this._getUniqueUrlTitle(groupId, articleId, normalizedURLTitle, processedArticleIds);
                    ps2.setString(1, normalizedURLTitle);
                    ps2.setString(2, urlTitle);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private String _getUniqueUrlTitle(long groupId, String articleId, String urlTitle, Map<String, String> processedArticleIds) throws Exception {
        int i = 1;
        while (true) {
            String key;
            String processedArticleId;
            if (((processedArticleId = processedArticleIds.get(key = groupId + "_" + urlTitle)) == null || processedArticleId.equals(articleId)) && this._isValidUrlTitle(groupId, articleId, urlTitle)) {
                processedArticleIds.put(key, articleId);
                return urlTitle;
            }
            String suffix = "-" + i;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = prefix + suffix;
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean _isValidUrlTitle(long groupId, String articleId, String urlTitle) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

