/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortletContext;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletRequestDispatcher;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.DynamicServletRequestUtil;
import com.liferay.portal.struts.StrutsURLEncoder;
import com.liferay.portlet.LiferayPortletUtil;
import com.liferay.portlet.PortletServletRequest;
import com.liferay.portlet.PortletServletResponse;
import com.liferay.portlet.internal.MimeResponseImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletRequestDispatcherImpl
implements LiferayPortletRequestDispatcher,
RequestDispatcher {
    private static final Log _log = LogFactoryUtil.getLog(PortletRequestDispatcherImpl.class);
    private final LiferayPortletContext _liferayPortletContext;
    private final boolean _named;
    private final String _path;
    private final Portlet _portlet;
    private final RequestDispatcher _requestDispatcher;

    public PortletRequestDispatcherImpl(RequestDispatcher requestDispatcher, boolean named, PortletContext portletContext) {
        this(requestDispatcher, named, portletContext, null);
    }

    public PortletRequestDispatcherImpl(RequestDispatcher requestDispatcher, boolean named, PortletContext portletContext, String path) {
        this._requestDispatcher = requestDispatcher;
        this._named = named;
        this._path = path;
        this._liferayPortletContext = (LiferayPortletContext)portletContext;
        this._portlet = this._liferayPortletContext.getPortlet();
    }

    public PortletRequestDispatcherImpl(RequestDispatcher requestDispatcher, String path) {
        this._requestDispatcher = requestDispatcher;
        this._path = path;
        this._named = false;
        this._liferayPortletContext = null;
        this._portlet = null;
    }

    public void forward(PortletRequest portletRequest, PortletResponse portletResponse) throws IllegalStateException, IOException, PortletException {
        HttpServletResponse httpServletResponse = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        if (httpServletResponse.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        this.dispatch(portletRequest, portletResponse, false, false);
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.dispatch(servletRequest, servletResponse, false);
    }

    public void include(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, PortletException {
        this.dispatch(portletRequest, portletResponse, false, true);
    }

    public void include(PortletRequest portletRequest, PortletResponse portletResponse, boolean strutsURLEncoder) throws IOException, PortletException {
        this.dispatch(portletRequest, portletResponse, strutsURLEncoder, true);
    }

    public void include(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.dispatch((PortletRequest)renderRequest, (PortletResponse)renderResponse, false, true);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.dispatch(servletRequest, servletResponse, true);
    }

    protected void checkCalledFlushBuffer(boolean include, PortletResponse portletResponse) {
        MimeResponseImpl mimeResponseImpl;
        if (!include && portletResponse instanceof MimeResponseImpl && (mimeResponseImpl = (MimeResponseImpl)portletResponse).isCalledFlushBuffer()) {
            throw new IllegalStateException();
        }
    }

    protected HttpServletRequest createDynamicServletRequest(HttpServletRequest httpServletRequest, LiferayPortletRequest liferayPortletRequest, Map<String, String[]> parameterMap) {
        return DynamicServletRequestUtil.createDynamicServletRequest(httpServletRequest, liferayPortletRequest.getPortlet(), parameterMap, true);
    }

    protected void dispatch(PortletRequest portletRequest, PortletResponse portletResponse, boolean strutsURLEncoder, boolean include) throws IOException, PortletException {
        this.checkCalledFlushBuffer(include, portletResponse);
        LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
        LiferayPortletResponse liferayPortletResponse = LiferayPortletUtil.getLiferayPortletResponse(portletResponse);
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        httpServletRequest.setAttribute("javax.portlet.request", (Object)portletRequest);
        httpServletRequest.setAttribute("javax.portlet.response", (Object)portletResponse);
        String pathInfo = null;
        String queryString = null;
        String requestURI = null;
        String servletPath = null;
        if (this._path != null) {
            String contextPath;
            String pathNoQueryString = this._path;
            int pos = this._path.indexOf(63);
            if (pos != -1) {
                pathNoQueryString = this._path.substring(0, pos);
                queryString = this._path.substring(pos + 1);
                httpServletRequest = this.createDynamicServletRequest(httpServletRequest, liferayPortletRequest, this.toParameterMap(queryString));
            }
            Portlet portlet = liferayPortletRequest.getPortlet();
            PortletApp portletApp = portlet.getPortletApp();
            Set servletURLPatterns = portletApp.getServletURLPatterns();
            for (String urlPattern : servletURLPatterns) {
                if (!urlPattern.endsWith("/*")) continue;
                int length = urlPattern.length() - 2;
                if (pathNoQueryString.length() <= length || !pathNoQueryString.regionMatches(0, urlPattern, 0, length) || pathNoQueryString.charAt(length) != '/') continue;
                pathInfo = pathNoQueryString.substring(length);
                servletPath = urlPattern.substring(0, length);
                break;
            }
            if (servletPath == null) {
                servletPath = pathNoQueryString;
            }
            requestURI = (contextPath = portletRequest.getContextPath()).equals("/") ? pathNoQueryString : contextPath + pathNoQueryString;
        }
        PortletServletRequest portletServletRequest = new PortletServletRequest(httpServletRequest, portletRequest, pathInfo, queryString, requestURI, servletPath, this._named, include);
        PortletServletResponse portletServletResponse = new PortletServletResponse(PortalUtil.getHttpServletResponse((PortletResponse)portletResponse), portletResponse, include);
        URLEncoder urlEncoder = this._portlet.getURLEncoderInstance();
        if (urlEncoder != null) {
            liferayPortletResponse.setURLEncoder(urlEncoder);
        } else if (strutsURLEncoder) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            StrutsURLEncoder strutsURLEncoderObj = new StrutsURLEncoder(portletServletRequest.getContextPath(), themeDisplay.getPathMain(), (String)this._liferayPortletContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING"), (LiferayPortletURL)liferayPortletResponse.createRenderURL());
            liferayPortletResponse.setURLEncoder((URLEncoder)strutsURLEncoderObj);
        }
        try {
            if (include) {
                this._requestDispatcher.include((ServletRequest)portletServletRequest, (ServletResponse)portletServletResponse);
            } else {
                this._requestDispatcher.forward((ServletRequest)portletServletRequest, (ServletResponse)portletServletResponse);
            }
        }
        catch (ServletException se) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to dispatch request", (Throwable)se);
            }
            _log.error((Object)("Unable to dispatch request: " + se.getMessage()));
            throw new PortletException((Throwable)se);
        }
        finally {
            liferayPortletRequest.setPortletRequestDispatcherRequest(null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dispatch(ServletRequest servletRequest2, ServletResponse servletResponse, boolean include) throws IOException, ServletException {
        HttpServletRequest oldPortletRequestDispatcherRequest = null;
        LiferayPortletRequest liferayPortletRequest = null;
        if (servletRequest2 instanceof PortletServletRequest) {
            int pos;
            PortletRequest portletRequest = (PortletRequest)servletRequest2.getAttribute("javax.portlet.request");
            liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
            oldPortletRequestDispatcherRequest = liferayPortletRequest.getPortletRequestDispatcherRequest();
            PortletServletRequest portletServletRequest = (PortletServletRequest)((Object)servletRequest2);
            HttpServletRequest httpServletRequest = (HttpServletRequest)portletServletRequest.getRequest();
            if (this._path != null && (pos = this._path.indexOf(63)) != -1) {
                String queryString = this._path.substring(pos + 1);
                httpServletRequest = this.createDynamicServletRequest(httpServletRequest, liferayPortletRequest, this.toParameterMap(queryString));
            }
            PortletServletRequest servletRequest2 = new PortletServletRequest(httpServletRequest, portletRequest, portletServletRequest.getPathInfo(), portletServletRequest.getQueryString(), portletServletRequest.getRequestURI(), portletServletRequest.getServletPath(), this._named, (boolean)include);
        }
        try {
            void servletRequest2;
            if (include != false) {
                this._requestDispatcher.include((ServletRequest)servletRequest2, (ServletResponse)servletResponse);
            } else {
                this._requestDispatcher.forward((ServletRequest)servletRequest2, (ServletResponse)servletResponse);
            }
            if (liferayPortletRequest == null) return;
        }
        catch (ServletException se) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to dispatch request", (Throwable)se);
                }
                _log.error((Object)("Unable to dispatch request: " + se.getMessage()));
                throw new ServletException((Throwable)se);
            }
            catch (Throwable throwable) {
                if (liferayPortletRequest == null) throw throwable;
                liferayPortletRequest.setPortletRequestDispatcherRequest(oldPortletRequestDispatcherRequest);
                throw throwable;
            }
        }
        liferayPortletRequest.setPortletRequestDispatcherRequest(oldPortletRequestDispatcherRequest);
        return;
    }

    protected Map<String, String[]> toParameterMap(String queryString) {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (String parameter : StringUtil.split((String)queryString, (char)'&')) {
            String[] values;
            String[] parameterArray = StringUtil.split((String)parameter, (char)'=');
            String name = parameterArray[0];
            String value = "";
            if (parameterArray.length == 2) {
                value = parameterArray[1];
            }
            if ((values = (String[])parameterMap.get(name)) == null) {
                parameterMap.put(name, new String[]{value});
                continue;
            }
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            parameterMap.put(name, newValues);
        }
        return parameterMap;
    }
}

