/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.MVCPortletAutoDeployer;
import com.liferay.portal.deploy.auto.PluginAutoDeployListenerHelper;
import com.liferay.portal.deploy.auto.PortletAutoDeployer;
import com.liferay.portal.deploy.auto.ThreadSafeAutoDeployer;
import com.liferay.portal.deploy.auto.WAIAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.BaseAutoDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;

public class PortletAutoDeployListener
extends BaseAutoDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(PortletAutoDeployListener.class);
    private boolean _mvcDeployer;
    private boolean _portletDeployer;
    private boolean _waiDeployer;

    protected AutoDeployer buildAutoDeployer() throws AutoDeployException {
        PortletAutoDeployer autoDeployer = null;
        if (this._portletDeployer) {
            autoDeployer = new PortletAutoDeployer();
        } else if (this._mvcDeployer) {
            autoDeployer = new MVCPortletAutoDeployer();
        } else if (this._waiDeployer) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Deploying package as a web application");
            }
            autoDeployer = new WAIAutoDeployer();
        }
        if (autoDeployer == null) {
            throw new AutoDeployException("Unable to find an auto deployer");
        }
        if (_log.isDebugEnabled()) {
            Class<?> clazz = autoDeployer.getClass();
            _log.debug((Object)("Using deployer " + clazz.getName()));
        }
        return new ThreadSafeAutoDeployer(autoDeployer);
    }

    protected String getPluginPathInfoMessage(File file) {
        return "Copying portlets for " + file.getPath();
    }

    protected String getSuccessMessage(File file) {
        return "Portlets for " + file.getPath() + " copied successfully";
    }

    protected boolean isDeployable(File file) throws AutoDeployException {
        PluginAutoDeployListenerHelper pluginAutoDeployListenerHelper = new PluginAutoDeployListenerHelper(file);
        if (pluginAutoDeployListenerHelper.isMatchingFile("WEB-INF/portlet.xml") || pluginAutoDeployListenerHelper.isMatchingFile("WEB-INF/beans.xml")) {
            this._portletDeployer = true;
            return true;
        }
        if (pluginAutoDeployListenerHelper.isMatchingFile("index_mvc.jsp")) {
            this._mvcDeployer = true;
            return true;
        }
        String fileName = file.getName();
        if (!(pluginAutoDeployListenerHelper.isExtPlugin() || pluginAutoDeployListenerHelper.isHookPlugin() || pluginAutoDeployListenerHelper.isMatchingFile("WEB-INF/liferay-layout-templates.xml") || pluginAutoDeployListenerHelper.isThemePlugin() || pluginAutoDeployListenerHelper.isWebPlugin() || !fileName.endsWith(".war"))) {
            this._waiDeployer = true;
            return true;
        }
        return false;
    }
}

