/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters;

import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class IgnoreModuleRequestFilter
extends BasePortalFilter {
    private static final String _MODULE_REQUEST_PREFIX = PortalUtil.getPathModule() + "/";

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        if (this.isModuleRequest(request)) {
            return false;
        }
        return super.isFilterEnabled(request, response);
    }

    protected boolean isModuleRequest(HttpServletRequest request) {
        String requestURI;
        String contextPath = request.getContextPath();
        String resourcePath = requestURI = request.getRequestURI();
        int index = requestURI.indexOf(contextPath);
        if (index == 0) {
            resourcePath = resourcePath.substring(contextPath.length());
        }
        return resourcePath.startsWith(_MODULE_REQUEST_PREFIX);
    }
}

