/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.password.modified;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PasswordModifiedFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(PasswordModifiedFilter.class);

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (this._isPasswordModified(request)) {
            AuthenticatedSessionManagerUtil.logout((HttpServletRequest)request, (HttpServletResponse)response);
            String redirect = PortalUtil.getCurrentCompleteURL((HttpServletRequest)request);
            if (!StringUtil.equals((String)request.getMethod(), (String)"GET")) {
                redirect = PortalUtil.getPortalURL((HttpServletRequest)request);
            }
            response.sendRedirect(redirect);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean _isPasswordModified(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        try {
            User user = PortalUtil.getUser((HttpServletRequest)request);
            if (user == null || user.isDefaultUser()) {
                return false;
            }
            Date passwordModifiedDate = user.getPasswordModifiedDate();
            if (passwordModifiedDate == null) {
                return false;
            }
            return session.getCreationTime() < passwordModifiedDate.getTime();
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return false;
        }
    }
}

