/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.Normalizer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OSGiBeanProperties(property={"service.ranking:Integer=100"})
public class FriendlyURLNormalizerImpl
implements FriendlyURLNormalizer {
    private static final char[] _HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] _REPLACE_CHARS;

    public String normalize(String friendlyURL) {
        return this.normalize(friendlyURL, false);
    }

    @Deprecated
    public String normalize(String friendlyURL, Pattern friendlyURLPattern) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = StringUtil.toLowerCase((String)friendlyURL);
        friendlyURL = Normalizer.normalizeToAscii((String)friendlyURL);
        Matcher matcher = friendlyURLPattern.matcher(friendlyURL);
        friendlyURL = matcher.replaceAll("-");
        StringBuilder sb = new StringBuilder(friendlyURL.length());
        for (int i = 0; i < friendlyURL.length(); ++i) {
            char c = friendlyURL.charAt(i);
            if (c == '-') {
                if (i != 0 && '-' == sb.charAt(sb.length() - 1)) continue;
                sb.append('-');
                continue;
            }
            sb.append(c);
        }
        if (sb.length() == friendlyURL.length()) {
            return friendlyURL;
        }
        return sb.toString();
    }

    public String normalizeWithEncoding(String friendlyURL) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        StringBuilder sb = new StringBuilder(friendlyURL.length());
        boolean modified = false;
        ByteBuffer byteBuffer = null;
        CharBuffer charBuffer = null;
        CharsetEncoder charsetEncoder = null;
        for (int i = 0; i < friendlyURL.length(); ++i) {
            char c = friendlyURL.charAt(i);
            if ('A' <= c && c <= 'Z') {
                sb.append((char)(c + 32));
                modified = true;
                continue;
            }
            if ('a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '.' || c == '/' || c == '*' || c == '_') {
                sb.append(c);
                continue;
            }
            if (Arrays.binarySearch(_REPLACE_CHARS, c) >= 0) {
                if (i == 0 || '-' != sb.charAt(sb.length() - 1)) {
                    sb.append('-');
                    if (c == '-') continue;
                    modified = true;
                    continue;
                }
                modified = true;
                continue;
            }
            if (charsetEncoder == null) {
                charsetEncoder = CharsetEncoderUtil.getCharsetEncoder((String)"UTF-8");
                byteBuffer = ByteBuffer.allocate(4);
                charBuffer = CharBuffer.allocate(2);
            } else {
                byteBuffer.clear();
                charBuffer.clear();
            }
            charBuffer.put(c);
            boolean endOfInput = false;
            if (friendlyURL.length() - 1 == i) {
                endOfInput = true;
            }
            if (Character.isHighSurrogate(c) && i + 1 < friendlyURL.length()) {
                c = friendlyURL.charAt(i + 1);
                if (Character.isLowSurrogate(c)) {
                    charBuffer.put(c);
                    ++i;
                } else {
                    endOfInput = true;
                }
            }
            charBuffer.flip();
            charsetEncoder.encode(charBuffer, byteBuffer, endOfInput);
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                byte b = byteBuffer.get();
                sb.append('%');
                sb.append(_HEX_DIGITS[b >> 4 & 0xF]);
                sb.append(_HEX_DIGITS[b & 0xF]);
            }
            if (endOfInput) {
                charsetEncoder.flush(byteBuffer);
                charsetEncoder.reset();
            }
            modified = true;
        }
        if (modified) {
            return sb.toString();
        }
        return friendlyURL;
    }

    public String normalizeWithPeriodsAndSlashes(String friendlyURL) {
        return this.normalize(friendlyURL, true);
    }

    protected String normalize(String friendlyURL, boolean periodsAndSlashes) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = Normalizer.normalizeToAscii((String)friendlyURL);
        StringBuilder sb = new StringBuilder(friendlyURL.length());
        boolean modified = false;
        for (int i = 0; i < friendlyURL.length(); ++i) {
            char c = friendlyURL.charAt(i);
            if ('A' <= c && c <= 'Z') {
                sb.append((char)(c + 32));
                modified = true;
                continue;
            }
            if ('a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_' || !periodsAndSlashes && (c == '/' || c == '.')) {
                sb.append(c);
                continue;
            }
            if (i == 0 || '-' != sb.charAt(sb.length() - 1)) {
                sb.append('-');
                if (c == '-') continue;
                modified = true;
                continue;
            }
            modified = true;
        }
        if (modified) {
            return sb.toString();
        }
        return friendlyURL;
    }

    static {
        char[] replaceChars = new char[]{'-', ' ', ',', '\\', '\'', '\"', '(', ')', '[', ']', '{', '}', '?', '#', '@', '+', '~', ';', '$', '!', '=', ':', '&', '\u00a3', '\u2013', '\u2014', '\u2018', '\u2019', '\u201c', '\u201d'};
        Arrays.sort(replaceChars);
        _REPLACE_CHARS = replaceChars;
    }
}

