/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.xml.simple.Element;
import com.liferay.portlet.Preference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public abstract class BasePreferencesImpl
implements Serializable {
    private static final String _NULL_ELEMENT = "NULL_ELEMENT";
    private static final String _NULL_VALUE = "NULL_VALUE";
    private Map<String, Preference> _modifiedPreferences;
    private Map<String, Preference> _originalPreferences;
    private String _originalXML;
    private final long _ownerId;
    private final int _ownerType;

    public BasePreferencesImpl(long ownerId, int ownerType, String xml, Map<String, Preference> preferences) {
        this._ownerId = ownerId;
        this._ownerType = ownerType;
        this._originalXML = xml;
        this._originalPreferences = preferences;
    }

    public Map<String, String[]> getMap() {
        Map<String, Preference> preferences = this.getPreferences();
        if (preferences.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry<String, Preference> entry : preferences.entrySet()) {
            String key = entry.getKey();
            Preference preference = entry.getValue();
            String[] actualValues = this.getActualValues(preference.getValues());
            map.put(key, actualValues);
        }
        return map;
    }

    public Enumeration<String> getNames() {
        Map<String, Preference> preferences = this.getPreferences();
        return Collections.enumeration(preferences.keySet());
    }

    public long getOwnerId() {
        return this._ownerId;
    }

    public int getOwnerType() {
        return this._ownerType;
    }

    public String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        if (preference == null) {
            return def;
        }
        String[] values = preference.getValues();
        if (this.isNull(values)) {
            return def;
        }
        return this.getActualValue(values[0]);
    }

    public String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        if (preference == null) {
            return def;
        }
        String[] values = preference.getValues();
        if (this.isNull(values)) {
            return def;
        }
        return this.getActualValues(values);
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        return preference != null && preference.isReadOnly();
    }

    public void reset() {
        this._modifiedPreferences = null;
    }

    public abstract void reset(String var1) throws ReadOnlyException;

    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        value = this.getXMLSafeValue(value);
        Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
        Preference preference = modifiedPreferences.get(key);
        if (preference == null) {
            preference = new Preference(key, value);
            modifiedPreferences.put(key, preference);
            return;
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException(key);
        }
        preference = (Preference)preference.clone();
        modifiedPreferences.put(key, preference);
        preference.setValues(new String[]{value});
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        values = this.getXMLSafeValues(values);
        Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
        Preference preference = modifiedPreferences.get(key);
        if (preference == null) {
            preference = new Preference(key, values);
            modifiedPreferences.put(key, preference);
            return;
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException(key);
        }
        preference = (Preference)preference.clone();
        modifiedPreferences.put(key, preference);
        preference.setValues(values);
    }

    public int size() {
        Map<String, Preference> preferences = this.getPreferences();
        return preferences.size();
    }

    public abstract void store() throws IOException, ValidatorException;

    protected String getActualValue(String value) {
        if (value == null || value.equals(_NULL_VALUE)) {
            return null;
        }
        return XMLUtil.fromCompactSafe((String)value);
    }

    protected String[] getActualValues(String[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            String actualValue = this.getActualValue(values[0]);
            if (actualValue == null) {
                return null;
            }
            if (actualValue.equals(_NULL_ELEMENT)) {
                return new String[]{null};
            }
            return new String[]{actualValue};
        }
        String[] actualValues = new String[values.length];
        for (int i = 0; i < actualValues.length; ++i) {
            actualValues[i] = this.getActualValue(values[i]);
        }
        return actualValues;
    }

    protected Map<String, Preference> getModifiedPreferences() {
        if (this._modifiedPreferences == null) {
            this._modifiedPreferences = new ConcurrentHashMap<String, Preference>(this._originalPreferences);
        }
        return this._modifiedPreferences;
    }

    protected Map<String, Preference> getOriginalPreferences() {
        return this._originalPreferences;
    }

    protected String getOriginalXML() {
        return this._originalXML;
    }

    protected Map<String, Preference> getPreferences() {
        if (this._modifiedPreferences != null) {
            return this._modifiedPreferences;
        }
        return this._originalPreferences;
    }

    protected String getXMLSafeValue(String value) {
        if (value == null) {
            return _NULL_VALUE;
        }
        return XMLUtil.toCompactSafe((String)value);
    }

    protected String[] getXMLSafeValues(String[] values) {
        if (values == null) {
            return new String[]{_NULL_VALUE};
        }
        if (values.length == 1 && values[0] == null) {
            return new String[]{_NULL_ELEMENT};
        }
        String[] xmlSafeValues = new String[values.length];
        for (int i = 0; i < xmlSafeValues.length; ++i) {
            xmlSafeValues[i] = this.getXMLSafeValue(values[i]);
        }
        return xmlSafeValues;
    }

    protected boolean isNull(String[] values) {
        return ArrayUtil.isEmpty((Object[])values) || values.length == 1 && this.getActualValue(values[0]) == null;
    }

    protected void setOriginalPreferences(Map<String, Preference> originalPreferences) {
        this._originalPreferences = originalPreferences;
    }

    protected void setOriginalXML(String originalXML) {
        this._originalXML = originalXML;
    }

    protected String toXML() {
        if (this._modifiedPreferences == null && this._originalXML != null) {
            return this._originalXML;
        }
        Map<String, Preference> preferences = this.getPreferences();
        Element portletPreferencesElement = new Element("portlet-preferences", false);
        for (Map.Entry<String, Preference> entry : preferences.entrySet()) {
            Preference preference = entry.getValue();
            Element preferenceElement = portletPreferencesElement.addElement("preference");
            preferenceElement.addElement("name", preference.getName());
            for (String value : preference.getValues()) {
                preferenceElement.addElement("value", value);
            }
            if (!preference.isReadOnly()) continue;
            preferenceElement.addElement("read-only", (Object)Boolean.TRUE);
        }
        return portletPreferencesElement.toXMLString();
    }
}

